/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.renderer;

import com.dlsc.formsfx.model.structure.Element;
import com.dlsc.formsfx.model.structure.Field;
import com.dlsc.formsfx.model.structure.Group;
import com.dlsc.formsfx.model.structure.NodeElement;
import com.dlsc.formsfx.view.controls.SimpleControl;
import com.dlsc.formsfx.view.util.ViewMixin;
import javafx.geometry.Insets;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public abstract class GroupRendererBase<V extends Group>
extends StackPane
implements ViewMixin {
    protected final int SPACING = 10;
    protected GridPane grid;
    protected V element;

    @Override
    public void initializeParts() {
        this.grid = new GridPane();
    }

    @Override
    public void layoutParts() {
        int COLUMN_COUNT = 12;
        for (int i = 0; i < COLUMN_COUNT; ++i) {
            ColumnConstraints colConst = new ColumnConstraints();
            colConst.setPercentWidth(100.0 / (double)COLUMN_COUNT);
            this.grid.getColumnConstraints().add((Object)colConst);
        }
        this.grid.setHgap(10.0);
        this.grid.setVgap(10.0);
        this.setPadding(new Insets(10.0));
        int currentRow = 0;
        int currentColumnCount = 0;
        for (Element e : ((Group)this.element).getElements()) {
            int span = e.getSpan();
            if (currentColumnCount + span > COLUMN_COUNT) {
                ++currentRow;
                currentColumnCount = 0;
            }
            if (e instanceof Field) {
                Field f = (Field)e;
                SimpleControl<Field> c = f.getRenderer();
                c.setField(f);
                this.grid.add(c, currentColumnCount, currentRow, span, 1);
            } else if (e instanceof NodeElement) {
                this.grid.add(((NodeElement)e).getNode(), currentColumnCount, currentRow, span, 1);
            }
            currentColumnCount += span;
        }
    }
}

