/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.renderer;

import com.dlsc.formsfx.model.structure.Form;
import com.dlsc.formsfx.model.structure.Group;
import com.dlsc.formsfx.model.structure.Section;
import com.dlsc.formsfx.view.renderer.GroupRenderer;
import com.dlsc.formsfx.view.renderer.GroupRendererBase;
import com.dlsc.formsfx.view.renderer.SectionRenderer;
import com.dlsc.formsfx.view.util.ViewMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.layout.VBox;

public class FormRenderer
extends VBox
implements ViewMixin {
    protected Form form;
    protected List<GroupRendererBase> sections = new ArrayList<GroupRendererBase>();

    public FormRenderer(Form form) {
        this.form = form;
        this.init();
    }

    public String getUserAgentStylesheet() {
        return FormRenderer.class.getResource("style.css").toExternalForm();
    }

    @Override
    public void initializeParts() {
        this.sections = this.form.getGroups().stream().map(s -> {
            if (s instanceof Section) {
                return new SectionRenderer((Section)s);
            }
            return new GroupRenderer((Group)s);
        }).collect(Collectors.toList());
    }

    @Override
    public void layoutParts() {
        this.getStyleClass().add((Object)"formsfx-form");
        this.setPadding(new Insets(10.0));
        this.getChildren().addAll(this.sections);
    }
}

