/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.StringField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class SimpleTextControl
extends SimpleControl<StringField> {
    protected StackPane stack;
    protected TextField editableField;
    protected TextArea editableArea;
    protected Label readOnlyLabel;
    protected Label fieldLabel;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-text-control");
        this.stack = new StackPane();
        this.editableField = new TextField((String)((StringField)this.field).getValue());
        this.editableArea = new TextArea((String)((StringField)this.field).getValue());
        this.readOnlyLabel = new Label((String)((StringField)this.field).getValue());
        this.fieldLabel = new Label(((StringField)this.field).labelProperty().getValue());
        this.editableField.setPromptText(((StringField)this.field).placeholderProperty().getValue());
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        this.readOnlyLabel.getStyleClass().add((Object)"read-only-label");
        this.readOnlyLabel.setPrefHeight(26.0);
        this.editableArea.getStyleClass().add((Object)"simple-textarea");
        this.editableArea.setPrefRowCount(5);
        this.editableArea.setPrefHeight(80.0);
        this.editableArea.setWrapText(true);
        if (((StringField)this.field).isMultiline()) {
            this.stack.setPrefHeight(80.0);
            this.readOnlyLabel.setPrefHeight(80.0);
        }
        this.stack.getChildren().addAll((Object[])new Node[]{this.editableField, this.editableArea, this.readOnlyLabel});
        this.stack.setAlignment(Pos.CENTER_LEFT);
        Node labelDescription = ((StringField)this.field).getLabelDescription();
        Node valueDescription = ((StringField)this.field).getValueDescription();
        int columns = ((StringField)this.field).getSpan();
        if (columns < 3) {
            int rowIndex = 0;
            this.add((Node)this.fieldLabel, 0, rowIndex++, columns, 1);
            if (labelDescription != null) {
                GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
                this.add(labelDescription, 0, rowIndex++, columns, 1);
            }
            this.add((Node)this.stack, 0, rowIndex++, columns, 1);
            if (valueDescription != null) {
                GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
                this.add(valueDescription, 0, rowIndex, columns, 1);
            }
        } else {
            this.add((Node)this.fieldLabel, 0, 0, 2, 1);
            if (labelDescription != null) {
                GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
                this.add(labelDescription, 0, 1, 2, 1);
            }
            this.add((Node)this.stack, 2, 0, columns - 2, 1);
            if (valueDescription != null) {
                GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
                this.add(valueDescription, 2, 1, columns - 2, 1);
            }
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.editableArea.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)((StringField)this.field).editableProperty(), (ObservableBooleanValue)((StringField)this.field).multilineProperty()));
        this.editableField.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)((StringField)this.field).editableProperty(), (ObservableBooleanValue)((StringField)this.field).multilineProperty().not()));
        this.readOnlyLabel.visibleProperty().bind((ObservableValue)((StringField)this.field).editableProperty().not());
        this.editableField.textProperty().bindBidirectional((Property)((StringField)this.field).userInputProperty());
        this.editableArea.textProperty().bindBidirectional((Property)((StringField)this.field).userInputProperty());
        this.readOnlyLabel.textProperty().bind((ObservableValue)((StringField)this.field).userInputProperty());
        this.fieldLabel.textProperty().bind((ObservableValue)((StringField)this.field).labelProperty());
        this.editableField.promptTextProperty().bind((ObservableValue)((StringField)this.field).placeholderProperty());
        this.editableArea.promptTextProperty().bind((ObservableValue)((StringField)this.field).placeholderProperty());
        this.editableArea.managedProperty().bind((ObservableValue)this.editableArea.visibleProperty());
        this.editableField.managedProperty().bind((ObservableValue)this.editableField.visibleProperty());
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((StringField)this.field).multilineProperty().addListener((observable, oldValue, newValue) -> {
            this.stack.setPrefHeight(newValue != false ? 80.0 : 0.0);
            this.readOnlyLabel.setPrefHeight(newValue != false ? 80.0 : 26.0);
        });
        ((StringField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)(((StringField)this.field).isMultiline() ? this.editableArea : this.editableField)));
        this.editableField.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.editableField));
        this.editableArea.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.editableArea));
    }
}

