/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.SingleSelectionField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class SimpleRadioButtonControl<V>
extends SimpleControl<SingleSelectionField<V>> {
    protected Label fieldLabel;
    protected final List<RadioButton> radioButtons = new ArrayList<RadioButton>();
    protected ToggleGroup toggleGroup;
    protected VBox box;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-radio-control");
        this.fieldLabel = new Label(((SingleSelectionField)this.field).labelProperty().getValue());
        this.toggleGroup = new ToggleGroup();
        this.box = new VBox();
        this.createRadioButtons();
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        int columns = ((SingleSelectionField)this.field).getSpan();
        this.box.setSpacing(5.0);
        Node labelDescription = ((SingleSelectionField)this.field).getLabelDescription();
        Node valueDescription = ((SingleSelectionField)this.field).getValueDescription();
        this.add((Node)this.fieldLabel, 0, 0, 2, 1);
        if (labelDescription != null) {
            GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
            this.add(labelDescription, 0, 1, 2, 1);
        }
        this.add((Node)this.box, 2, 0, columns - 2, 1);
        if (valueDescription != null) {
            GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
            this.add(valueDescription, 2, 1, columns - 2, 1);
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.fieldLabel.textProperty().bind((ObservableValue)((SingleSelectionField)this.field).labelProperty());
        this.setupRadioButtonBindings();
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((SingleSelectionField)this.field).itemsProperty().addListener((observable, oldValue, newValue) -> {
            this.createRadioButtons();
            this.setupRadioButtonBindings();
            this.setupRadioButtonEventHandlers();
        });
        ((SingleSelectionField)this.field).selectionProperty().addListener((observable, oldValue, newValue) -> {
            if (((SingleSelectionField)this.field).getSelection() != null) {
                this.radioButtons.get(((SingleSelectionField)this.field).getItems().indexOf(((SingleSelectionField)this.field).getSelection())).setSelected(true);
            } else {
                this.toggleGroup.getSelectedToggle().setSelected(false);
            }
        });
        ((SingleSelectionField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.box, (Control)this.radioButtons.get(this.radioButtons.size() - 1)));
        ((SingleSelectionField)this.field).tooltipProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.box, (Control)this.radioButtons.get(this.radioButtons.size() - 1)));
    }

    @Override
    public void setupEventHandlers() {
        this.setOnMouseEntered(event -> this.toggleTooltip((Node)this.box, (Control)this.radioButtons.get(this.radioButtons.size() - 1)));
        this.setOnMouseExited(event -> this.toggleTooltip((Node)this.box, (Control)this.radioButtons.get(this.radioButtons.size() - 1)));
        this.setupRadioButtonEventHandlers();
    }

    protected void createRadioButtons() {
        this.box.getChildren().clear();
        this.radioButtons.clear();
        for (int i = 0; i < ((SingleSelectionField)this.field).getItems().size(); ++i) {
            RadioButton rb = new RadioButton();
            rb.setText(((SingleSelectionField)this.field).getItems().get(i).toString());
            rb.setToggleGroup(this.toggleGroup);
            this.radioButtons.add(rb);
        }
        if (((SingleSelectionField)this.field).getSelection() != null) {
            this.radioButtons.get(((SingleSelectionField)this.field).getItems().indexOf(((SingleSelectionField)this.field).getSelection())).setSelected(true);
        }
        this.box.getChildren().addAll(this.radioButtons);
    }

    protected void setupRadioButtonBindings() {
        for (RadioButton radio : this.radioButtons) {
            radio.disableProperty().bind((ObservableValue)((SingleSelectionField)this.field).editableProperty().not());
        }
    }

    protected void setupRadioButtonEventHandlers() {
        int i = 0;
        while (i < this.radioButtons.size()) {
            int j = i++;
            this.radioButtons.get(j).setOnAction(event -> ((SingleSelectionField)this.field).select(j));
        }
    }
}

