/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.PasswordField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class SimplePasswordControl
extends SimpleControl<PasswordField> {
    protected StackPane stack;
    protected javafx.scene.control.PasswordField editableField;
    protected Label readOnlyLabel;
    protected Label fieldLabel;
    protected StringBinding obfuscatedUserInputBinding;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-password-control");
        this.stack = new StackPane();
        this.editableField = new javafx.scene.control.PasswordField();
        this.editableField.setText((String)((PasswordField)this.field).getValue());
        this.readOnlyLabel = new Label(this.obfuscate((String)((PasswordField)this.field).getValue()));
        this.fieldLabel = new Label(((PasswordField)this.field).labelProperty().getValue());
        this.editableField.setPromptText(((PasswordField)this.field).placeholderProperty().getValue());
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        this.readOnlyLabel.getStyleClass().add((Object)"read-only-label");
        this.readOnlyLabel.setPrefHeight(26.0);
        this.stack.getChildren().addAll((Object[])new Node[]{this.editableField, this.readOnlyLabel});
        this.stack.setAlignment(Pos.CENTER_LEFT);
        Node labelDescription = ((PasswordField)this.field).getLabelDescription();
        Node valueDescription = ((PasswordField)this.field).getValueDescription();
        int columns = ((PasswordField)this.field).getSpan();
        if (columns < 3) {
            int rowIndex = 0;
            this.add((Node)this.fieldLabel, 0, rowIndex++, columns, 1);
            if (labelDescription != null) {
                GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
                this.add(labelDescription, 0, rowIndex++, columns, 1);
            }
            this.add((Node)this.stack, 0, rowIndex++, columns, 1);
            if (valueDescription != null) {
                GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
                this.add(valueDescription, 0, rowIndex, columns, 1);
            }
        } else {
            this.add((Node)this.fieldLabel, 0, 0, 2, 1);
            if (labelDescription != null) {
                GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
                this.add(labelDescription, 0, 1, 2, 1);
            }
            this.add((Node)this.stack, 2, 0, columns - 2, 1);
            if (valueDescription != null) {
                GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
                this.add(valueDescription, 2, 1, columns - 2, 1);
            }
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.editableField.visibleProperty().bind((ObservableValue)((PasswordField)this.field).editableProperty());
        this.readOnlyLabel.visibleProperty().bind((ObservableValue)((PasswordField)this.field).editableProperty().not());
        this.editableField.textProperty().bindBidirectional((Property)((PasswordField)this.field).userInputProperty());
        this.obfuscatedUserInputBinding = Bindings.createStringBinding(() -> this.obfuscate(((PasswordField)this.field).getUserInput()), (Observable[])new Observable[]{((PasswordField)this.field).userInputProperty()});
        this.readOnlyLabel.textProperty().bind((ObservableValue)this.obfuscatedUserInputBinding);
        this.fieldLabel.textProperty().bind((ObservableValue)((PasswordField)this.field).labelProperty());
        this.editableField.promptTextProperty().bind((ObservableValue)((PasswordField)this.field).placeholderProperty());
        this.editableField.managedProperty().bind((ObservableValue)this.editableField.visibleProperty());
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((PasswordField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.editableField));
        this.editableField.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.editableField));
    }

    protected String obfuscate(String input) {
        if (input == null) {
            return "";
        }
        int length = input.length();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            b.append('*');
        }
        return b.toString();
    }
}

