/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.DataField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public abstract class SimpleNumberControl<F extends DataField, D extends Number>
extends SimpleControl<F> {
    protected StackPane stack;
    protected Label fieldLabel;
    protected Spinner<D> editableSpinner;
    protected Label readOnlyLabel;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.stack = new StackPane();
        this.fieldLabel = new Label();
        this.readOnlyLabel = new Label();
        this.editableSpinner = new Spinner();
        this.editableSpinner.setEditable(true);
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        this.readOnlyLabel.getStyleClass().add((Object)"read-only-label");
        this.stack.getChildren().addAll((Object[])new Node[]{this.editableSpinner, this.readOnlyLabel});
        this.stack.setAlignment(Pos.CENTER_LEFT);
        this.editableSpinner.setMaxWidth(Double.MAX_VALUE);
        Node labelDescription = ((DataField)this.field).getLabelDescription();
        Node valueDescription = ((DataField)this.field).getValueDescription();
        int columns = ((DataField)this.field).getSpan();
        if (columns < 3) {
            int rowIndex = 0;
            this.add((Node)this.fieldLabel, 0, rowIndex++, columns, 1);
            if (labelDescription != null) {
                GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
                this.add(labelDescription, 0, rowIndex++, columns, 1);
            }
            this.add((Node)this.stack, 0, rowIndex++, columns, 1);
            if (valueDescription != null) {
                GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
                this.add(valueDescription, 0, rowIndex, columns, 1);
            }
        } else {
            this.add((Node)this.fieldLabel, 0, 0, 2, 1);
            if (labelDescription != null) {
                GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
                this.add(labelDescription, 0, 1, 2, 1);
            }
            this.add((Node)this.stack, 2, 0, columns - 2, 1);
            if (valueDescription != null) {
                GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
                this.add(valueDescription, 2, 1, columns - 2, 1);
            }
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.editableSpinner.visibleProperty().bind((ObservableValue)((DataField)this.field).editableProperty());
        this.readOnlyLabel.visibleProperty().bind((ObservableValue)((DataField)this.field).editableProperty().not());
        this.editableSpinner.getEditor().textProperty().bindBidirectional((Property)((DataField)this.field).userInputProperty());
        this.readOnlyLabel.textProperty().bind((ObservableValue)((DataField)this.field).userInputProperty());
        this.fieldLabel.textProperty().bind((ObservableValue)((DataField)this.field).labelProperty());
    }

    @Override
    public void setupEventHandlers() {
        this.editableSpinner.getEditor().setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case UP: {
                    this.editableSpinner.increment(1);
                    break;
                }
                case DOWN: {
                    this.editableSpinner.decrement(1);
                }
            }
        });
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        this.editableSpinner.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.editableSpinner));
    }
}

