/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.MultiSelectionField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;

public class SimpleListViewControl<V>
extends SimpleControl<MultiSelectionField<V>> {
    protected Label fieldLabel;
    protected ListView<String> listView = new ListView();
    protected boolean preventUpdate;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-listview-control");
        this.fieldLabel = new Label(((MultiSelectionField)this.field).labelProperty().getValue());
        this.listView.setItems(((MultiSelectionField)this.field).getItems());
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        for (int i = 0; i < ((MultiSelectionField)this.field).getItems().size(); ++i) {
            if (((MultiSelectionField)this.field).getSelection().contains(((MultiSelectionField)this.field).getItems().get(i))) {
                this.listView.getSelectionModel().select(i);
                continue;
            }
            this.listView.getSelectionModel().clearSelection(i);
        }
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        int columns = ((MultiSelectionField)this.field).getSpan();
        this.listView.setPrefHeight(200.0);
        Node labelDescription = ((MultiSelectionField)this.field).getLabelDescription();
        Node valueDescription = ((MultiSelectionField)this.field).getValueDescription();
        this.add((Node)this.fieldLabel, 0, 0, 2, 1);
        if (labelDescription != null) {
            GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
            this.add(labelDescription, 0, 1, 2, 1);
        }
        this.add((Node)this.listView, 2, 0, columns - 2, 1);
        if (valueDescription != null) {
            GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
            this.add(valueDescription, 2, 1, columns - 2, 1);
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.fieldLabel.textProperty().bind((ObservableValue)((MultiSelectionField)this.field).labelProperty());
        this.listView.disableProperty().bind((ObservableValue)((MultiSelectionField)this.field).editableProperty().not());
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((MultiSelectionField)this.field).itemsProperty().addListener((observable, oldValue, newValue) -> this.listView.setItems(((MultiSelectionField)this.field).getItems()));
        ((MultiSelectionField)this.field).selectionProperty().addListener((observable, oldValue, newValue) -> {
            if (this.preventUpdate) {
                return;
            }
            this.preventUpdate = true;
            for (int i = 0; i < ((MultiSelectionField)this.field).getItems().size(); ++i) {
                if (((MultiSelectionField)this.field).getSelection().contains(((MultiSelectionField)this.field).getItems().get(i))) {
                    this.listView.getSelectionModel().select(i);
                    continue;
                }
                this.listView.getSelectionModel().clearSelection(i);
            }
            this.preventUpdate = false;
        });
        ((MultiSelectionField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.listView));
        ((MultiSelectionField)this.field).tooltipProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.listView));
        this.listView.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.listView));
    }

    @Override
    public void setupEventHandlers() {
        this.listView.setOnMouseEntered(event -> this.toggleTooltip((Node)this.listView));
        this.listView.setOnMouseExited(event -> this.toggleTooltip((Node)this.listView));
        this.listView.getSelectionModel().getSelectedIndices().addListener(c -> {
            if (this.preventUpdate) {
                return;
            }
            this.preventUpdate = true;
            for (int i = 0; i < this.listView.getItems().size(); ++i) {
                if (this.listView.getSelectionModel().getSelectedIndices().contains((Object)i)) {
                    ((MultiSelectionField)this.field).select(i);
                    continue;
                }
                ((MultiSelectionField)this.field).deselect(i);
            }
            this.preventUpdate = false;
        });
    }
}

