/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.DateField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class SimpleDateControl
extends SimpleControl<DateField> {
    protected Label fieldLabel;
    protected DatePicker picker;
    protected Label readOnlyLabel;
    protected StackPane stack;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.stack = new StackPane();
        this.fieldLabel = new Label();
        this.readOnlyLabel = new Label();
        this.picker = new DatePicker();
        this.picker.setEditable(true);
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        int columns = ((DateField)this.field).getSpan();
        this.readOnlyLabel.getStyleClass().add((Object)"read-only-label");
        this.picker.setMaxWidth(Double.MAX_VALUE);
        this.stack.setAlignment(Pos.CENTER_LEFT);
        this.stack.getChildren().addAll((Object[])new Node[]{this.picker, this.readOnlyLabel});
        Node labelDescription = ((DateField)this.field).getLabelDescription();
        Node valueDescription = ((DateField)this.field).getValueDescription();
        this.add((Node)this.fieldLabel, 0, 0, 2, 1);
        if (labelDescription != null) {
            GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
            this.add(labelDescription, 0, 1, 2, 1);
        }
        this.add((Node)this.stack, 2, 0, columns - 2, 1);
        if (valueDescription != null) {
            GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
            this.add(valueDescription, 2, 1, columns - 2, 1);
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.picker.disableProperty().bind((ObservableValue)((DateField)this.field).editableProperty().not());
        this.readOnlyLabel.visibleProperty().bind((ObservableValue)((DateField)this.field).editableProperty().not());
        this.picker.getEditor().textProperty().bindBidirectional((Property)((DateField)this.field).userInputProperty());
        this.fieldLabel.textProperty().bind((ObservableValue)((DateField)this.field).labelProperty());
        this.picker.promptTextProperty().bind((ObservableValue)((DateField)this.field).placeholderProperty());
        this.picker.managedProperty().bind((ObservableValue)this.picker.visibleProperty());
    }

    @Override
    public void setupEventHandlers() {
        this.picker.getEditor().textProperty().addListener((observable, oldValue, newValue) -> ((DateField)this.field).userInputProperty().setValue(String.valueOf(newValue)));
    }
}

