/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.Element;
import com.dlsc.formsfx.model.structure.Field;
import com.dlsc.formsfx.view.util.ViewMixin;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public abstract class SimpleControl<F extends Field>
extends GridPane
implements ViewMixin {
    protected F field;
    protected Tooltip tooltip;
    protected static final PseudoClass REQUIRED_CLASS = PseudoClass.getPseudoClass((String)"required");
    protected static final PseudoClass INVALID_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    protected static final PseudoClass CHANGED_CLASS = PseudoClass.getPseudoClass((String)"changed");
    protected static final PseudoClass DISABLED_CLASS = PseudoClass.getPseudoClass((String)"disabled");

    public void setField(F field) {
        if (this.field != null) {
            throw new IllegalStateException("Cannot change a control's field once set.");
        }
        this.field = field;
        this.init();
    }

    @Override
    public void initializeParts() {
        this.getStyleClass().add((Object)"simple-control");
        this.tooltip = new Tooltip();
        this.tooltip.getStyleClass().add((Object)"simple-tooltip");
        this.getStyleClass().addAll(((Element)this.field).getStyleClass());
        this.updateStyle(INVALID_CLASS, !((Field)this.field).isValid());
        this.updateStyle(REQUIRED_CLASS, ((Field)this.field).isRequired());
        this.updateStyle(CHANGED_CLASS, ((Field)this.field).hasChanged());
        this.updateStyle(DISABLED_CLASS, !((Field)this.field).isEditable());
    }

    @Override
    public void layoutParts() {
        this.setAlignment(Pos.CENTER_LEFT);
        int columns = ((Element)this.field).getSpan();
        for (int i = 0; i < columns; ++i) {
            ColumnConstraints colConst = new ColumnConstraints();
            colConst.setPercentWidth(100.0 / (double)columns);
            this.getColumnConstraints().add((Object)colConst);
        }
    }

    @Override
    public void setupBindings() {
        this.idProperty().bind((ObservableValue)((Element)this.field).idProperty());
    }

    @Override
    public void setupValueChangedListeners() {
        ((Field)this.field).validProperty().addListener((observable, oldValue, newValue) -> this.updateStyle(INVALID_CLASS, newValue == false));
        ((Field)this.field).requiredProperty().addListener((observable, oldValue, newValue) -> this.updateStyle(REQUIRED_CLASS, (boolean)newValue));
        ((Field)this.field).changedProperty().addListener((observable, oldValue, newValue) -> this.updateStyle(CHANGED_CLASS, (boolean)newValue));
        ((Field)this.field).editableProperty().addListener((observable, oldValue, newValue) -> this.updateStyle(DISABLED_CLASS, newValue == false));
        ((Element)this.field).getStyleClass().addListener(c -> {
            while (c.next()) {
                if (c.wasRemoved()) {
                    this.getStyleClass().removeAll((Collection)c.getRemoved());
                }
                if (!c.wasAdded()) continue;
                this.getStyleClass().addAll((Collection)c.getAddedSubList());
            }
        });
    }

    protected void toggleTooltip(Node reference) {
        this.toggleTooltip(reference, (Control)reference);
    }

    protected void toggleTooltip(Node reference, Control below) {
        String fieldTooltip = ((Field)this.field).getTooltip();
        if (!(!reference.isFocused() && !reference.isHover() || fieldTooltip.equals("") && ((Field)this.field).getErrorMessages().size() <= 0)) {
            this.tooltip.setText((String)(!fieldTooltip.equals("") ? fieldTooltip + "\n" : "") + String.join((CharSequence)"\n", ((Field)this.field).getErrorMessages()));
            if (this.tooltip.isShowing()) {
                return;
            }
            Point2D p = below.localToScene(0.0, 0.0);
            this.tooltip.show(this.getScene().getWindow(), p.getX() + this.getScene().getX() + this.getScene().getWindow().getX(), p.getY() + this.getScene().getY() + this.getScene().getWindow().getY() + below.getHeight() + 5.0);
        } else {
            this.tooltip.hide();
        }
    }

    protected void updateStyle(PseudoClass pseudo, boolean newValue) {
        this.pseudoClassStateChanged(pseudo, newValue);
    }

    public void addStyleClass(String name) {
        this.getStyleClass().add((Object)name);
    }

    public void removeStyleClass(String name) {
        this.getStyleClass().remove((Object)name);
    }
}

