/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.SingleSelectionField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;

public class SimpleComboBoxControl<V>
extends SimpleControl<SingleSelectionField<V>> {
    protected Label fieldLabel;
    protected ComboBox<V> comboBox;
    protected Label readOnlyLabel;
    protected StackPane stack;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-select-control");
        this.fieldLabel = new Label(((SingleSelectionField)this.field).labelProperty().getValue());
        this.readOnlyLabel = new Label();
        this.stack = new StackPane();
        this.comboBox = new ComboBox(((SingleSelectionField)this.field).getItems());
        this.comboBox.getSelectionModel().select(((SingleSelectionField)this.field).getItems().indexOf(((SingleSelectionField)this.field).getSelection()));
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        int columns = ((SingleSelectionField)this.field).getSpan();
        this.readOnlyLabel.getStyleClass().add((Object)"read-only-label");
        this.comboBox.setMaxWidth(Double.MAX_VALUE);
        this.comboBox.setVisibleRowCount(4);
        this.stack.setAlignment(Pos.CENTER_LEFT);
        this.stack.getChildren().addAll((Object[])new Node[]{this.comboBox, this.readOnlyLabel});
        Node labelDescription = ((SingleSelectionField)this.field).getLabelDescription();
        Node valueDescription = ((SingleSelectionField)this.field).getValueDescription();
        this.add((Node)this.fieldLabel, 0, 0, 2, 1);
        if (labelDescription != null) {
            GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
            this.add(labelDescription, 0, 1, 2, 1);
        }
        this.add((Node)this.stack, 2, 0, columns - 2, 1);
        if (valueDescription != null) {
            GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
            this.add(valueDescription, 2, 1, columns - 2, 1);
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.fieldLabel.textProperty().bind((ObservableValue)((SingleSelectionField)this.field).labelProperty());
        this.comboBox.visibleProperty().bind((ObservableValue)((SingleSelectionField)this.field).editableProperty());
        this.readOnlyLabel.visibleProperty().bind((ObservableValue)((SingleSelectionField)this.field).editableProperty().not());
        this.readOnlyLabel.textProperty().bind((ObservableValue)this.comboBox.valueProperty().asString());
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((SingleSelectionField)this.field).itemsProperty().addListener((observable, oldValue, newValue) -> this.comboBox.setItems(((SingleSelectionField)this.field).getItems()));
        ((SingleSelectionField)this.field).selectionProperty().addListener((observable, oldValue, newValue) -> {
            if (((SingleSelectionField)this.field).getSelection() != null) {
                this.comboBox.getSelectionModel().select(((SingleSelectionField)this.field).getItems().indexOf(((SingleSelectionField)this.field).getSelection()));
            } else {
                this.comboBox.getSelectionModel().clearSelection();
            }
        });
        ((SingleSelectionField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.comboBox));
        ((SingleSelectionField)this.field).tooltipProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.comboBox));
        this.comboBox.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.comboBox));
    }

    @Override
    public void setupEventHandlers() {
        this.comboBox.setOnMouseEntered(event -> this.toggleTooltip((Node)this.comboBox));
        this.comboBox.setOnMouseExited(event -> this.toggleTooltip((Node)this.comboBox));
        this.comboBox.valueProperty().addListener((observable, oldValue, newValue) -> ((SingleSelectionField)this.field).select(this.comboBox.getSelectionModel().getSelectedIndex()));
    }
}

