/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.MultiSelectionField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class SimpleCheckBoxControl<V>
extends SimpleControl<MultiSelectionField<V>> {
    protected Label fieldLabel;
    protected final List<CheckBox> checkboxes = new ArrayList<CheckBox>();
    protected VBox box;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-checkbox-control");
        this.fieldLabel = new Label(((MultiSelectionField)this.field).labelProperty().getValue());
        this.box = new VBox();
        this.createCheckboxes();
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        int columns = ((MultiSelectionField)this.field).getSpan();
        this.box.setSpacing(5.0);
        Node labelDescription = ((MultiSelectionField)this.field).getLabelDescription();
        Node valueDescription = ((MultiSelectionField)this.field).getValueDescription();
        this.add((Node)this.fieldLabel, 0, 0, 2, 1);
        if (labelDescription != null) {
            GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
            this.add(labelDescription, 0, 1, 2, 1);
        }
        this.add((Node)this.box, 2, 0, columns - 2, 1);
        if (valueDescription != null) {
            GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
            this.add(valueDescription, 2, 1, columns - 2, 1);
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.fieldLabel.textProperty().bind((ObservableValue)((MultiSelectionField)this.field).labelProperty());
        this.setupCheckboxBindings();
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((MultiSelectionField)this.field).itemsProperty().addListener((observable, oldValue, newValue) -> {
            this.createCheckboxes();
            this.setupCheckboxBindings();
            this.setupCheckboxEventHandlers();
        });
        ((MultiSelectionField)this.field).selectionProperty().addListener((observable, oldValue, newValue) -> {
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                this.checkboxes.get(i).setSelected(((MultiSelectionField)this.field).getSelection().contains(((MultiSelectionField)this.field).getItems().get(i)));
            }
        });
        ((MultiSelectionField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.box, (Control)this.checkboxes.get(this.checkboxes.size() - 1)));
        ((MultiSelectionField)this.field).tooltipProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.box, (Control)this.checkboxes.get(this.checkboxes.size() - 1)));
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            this.checkboxes.get(i).focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.box, (Control)this.checkboxes.get(this.checkboxes.size() - 1)));
        }
    }

    @Override
    public void setupEventHandlers() {
        this.box.setOnMouseEntered(event -> this.toggleTooltip((Node)this.box, (Control)this.checkboxes.get(this.checkboxes.size() - 1)));
        this.box.setOnMouseExited(event -> this.toggleTooltip((Node)this.box, (Control)this.checkboxes.get(this.checkboxes.size() - 1)));
        this.setupCheckboxEventHandlers();
    }

    protected void createCheckboxes() {
        this.box.getChildren().clear();
        this.checkboxes.clear();
        for (int i = 0; i < ((MultiSelectionField)this.field).getItems().size(); ++i) {
            CheckBox cb = new CheckBox();
            cb.setText(((MultiSelectionField)this.field).getItems().get(i).toString());
            cb.setSelected(((MultiSelectionField)this.field).getSelection().contains(((MultiSelectionField)this.field).getItems().get(i)));
            this.checkboxes.add(cb);
        }
        this.box.getChildren().addAll(this.checkboxes);
    }

    protected void setupCheckboxBindings() {
        for (CheckBox checkbox : this.checkboxes) {
            checkbox.disableProperty().bind((ObservableValue)((MultiSelectionField)this.field).editableProperty().not());
        }
    }

    protected void setupCheckboxEventHandlers() {
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            int j = i;
            this.checkboxes.get(i).setOnAction(event -> {
                if (this.checkboxes.get(j).isSelected()) {
                    ((MultiSelectionField)this.field).select(j);
                } else {
                    ((MultiSelectionField)this.field).deselect(j);
                }
            });
        }
    }
}

