/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.view.controls;

import com.dlsc.formsfx.model.structure.BooleanField;
import com.dlsc.formsfx.view.controls.SimpleControl;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class SimpleBooleanControl
extends SimpleControl<BooleanField> {
    protected Label fieldLabel;
    protected CheckBox checkBox;
    protected VBox container;

    @Override
    public void initializeParts() {
        super.initializeParts();
        this.getStyleClass().add((Object)"simple-boolean-control");
        this.fieldLabel = new Label(((BooleanField)this.field).labelProperty().getValue());
        this.checkBox = new CheckBox();
        this.container = new VBox();
        this.checkBox.setSelected(((Boolean)((BooleanField)this.field).getValue()).booleanValue());
    }

    @Override
    public void layoutParts() {
        super.layoutParts();
        int columns = ((BooleanField)this.field).getSpan();
        this.container.getChildren().add((Object)this.checkBox);
        Node labelDescription = ((BooleanField)this.field).getLabelDescription();
        Node valueDescription = ((BooleanField)this.field).getValueDescription();
        this.add((Node)this.fieldLabel, 0, 0, 2, 1);
        if (labelDescription != null) {
            GridPane.setValignment((Node)labelDescription, (VPos)VPos.TOP);
            this.add(labelDescription, 0, 1, 2, 1);
        }
        this.add((Node)this.container, 2, 0, columns - 2, 1);
        if (valueDescription != null) {
            GridPane.setValignment((Node)valueDescription, (VPos)VPos.TOP);
            this.add(valueDescription, 2, 1, columns - 2, 1);
        }
    }

    @Override
    public void setupBindings() {
        super.setupBindings();
        this.checkBox.disableProperty().bind((ObservableValue)((BooleanField)this.field).editableProperty().not());
        this.fieldLabel.textProperty().bind((ObservableValue)((BooleanField)this.field).labelProperty());
    }

    @Override
    public void setupValueChangedListeners() {
        super.setupValueChangedListeners();
        ((BooleanField)this.field).userInputProperty().addListener((observable, oldValue, newValue) -> this.checkBox.setSelected(Boolean.parseBoolean(((BooleanField)this.field).getUserInput())));
        ((BooleanField)this.field).errorMessagesProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.checkBox));
        ((BooleanField)this.field).tooltipProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.checkBox));
        this.checkBox.focusedProperty().addListener((observable, oldValue, newValue) -> this.toggleTooltip((Node)this.checkBox));
    }

    @Override
    public void setupEventHandlers() {
        this.setOnMouseEntered(event -> this.toggleTooltip((Node)this.checkBox));
        this.setOnMouseExited(event -> this.toggleTooltip((Node)this.checkBox));
        this.checkBox.selectedProperty().addListener((observable, oldValue, newValue) -> ((BooleanField)this.field).userInputProperty().setValue(String.valueOf(newValue)));
    }
}

