/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.validators;

import com.dlsc.formsfx.model.validators.CustomValidator;
import javafx.collections.ObservableList;

public class SelectionLengthValidator<E>
extends CustomValidator<ObservableList<E>> {
    private SelectionLengthValidator(int min, int max, String errorMessage) {
        super(input -> input.size() >= min && input.size() <= max, errorMessage);
    }

    public static <T> SelectionLengthValidator<T> between(int min, int max, String errorMessage) {
        if (min < 0) {
            throw new IllegalArgumentException("Minimum string length cannot be negative.");
        }
        if (min > max) {
            throw new IllegalArgumentException("Minimum must not be larger than maximum.");
        }
        return new SelectionLengthValidator(min, max, errorMessage);
    }

    public static <T> SelectionLengthValidator<T> atLeast(int min, String errorMessage) {
        if (min < 0) {
            throw new IllegalArgumentException("Minimum string length cannot be negative.");
        }
        return new SelectionLengthValidator(min, Integer.MAX_VALUE, errorMessage);
    }

    public static <T> SelectionLengthValidator<T> upTo(int max, String errorMessage) {
        return new SelectionLengthValidator(0, max, errorMessage);
    }

    public static <T> SelectionLengthValidator<T> exactly(int value, String errorMessage) {
        return new SelectionLengthValidator(value, value, errorMessage);
    }
}

