/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.validators;

import com.dlsc.formsfx.model.validators.RootValidator;
import com.dlsc.formsfx.model.validators.ValidationResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexValidator
extends RootValidator<String> {
    private Pattern pattern;

    private RegexValidator(String pattern, String errorMessage) throws PatternSyntaxException {
        super(errorMessage);
        this.pattern = Pattern.compile(pattern);
    }

    public static RegexValidator forPattern(String pattern, String errorMessage) {
        return new RegexValidator(pattern, errorMessage);
    }

    public static RegexValidator forEmail(String errorMessage) {
        return new RegexValidator("^(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])$", errorMessage);
    }

    public static RegexValidator forURL(String errorMessage) {
        return new RegexValidator("(https?:\\/\\/(?:www\\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|www\\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|https?:\\/\\/(?:www\\.|(?!www))[a-zA-Z0-9]\\.[^\\s]{2,}|www\\.[a-zA-Z0-9]\\.[^\\s]{2,})", errorMessage);
    }

    public static RegexValidator forAlphaNumeric(String errorMessage) {
        return new RegexValidator("^[a-zA-Z0-9]*$", errorMessage);
    }

    @Override
    public ValidationResult validate(String input) {
        return this.createResult(this.pattern.matcher(input).matches());
    }
}

