/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.validators;

import com.dlsc.formsfx.model.validators.CustomValidator;

public class IntegerRangeValidator
extends CustomValidator<Integer> {
    private IntegerRangeValidator(int min, int max, String errorMessage) {
        super(input -> input >= min && input <= max, errorMessage);
    }

    public static IntegerRangeValidator between(int min, int max, String errorMessage) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum must not be larger than maximum.");
        }
        return new IntegerRangeValidator(min, max, errorMessage);
    }

    public static IntegerRangeValidator atLeast(int min, String errorMessage) {
        return new IntegerRangeValidator(min, Integer.MAX_VALUE, errorMessage);
    }

    public static IntegerRangeValidator upTo(int max, String errorMessage) {
        return new IntegerRangeValidator(Integer.MIN_VALUE, max, errorMessage);
    }

    public static IntegerRangeValidator exactly(int value, String errorMessage) {
        return new IntegerRangeValidator(value, value, errorMessage);
    }
}

