/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.validators;

import com.dlsc.formsfx.model.validators.CustomValidator;

public class DoubleRangeValidator
extends CustomValidator<Double> {
    private DoubleRangeValidator(double min, double max, String errorMessage) {
        super(input -> input >= min && input <= max, errorMessage);
    }

    public static DoubleRangeValidator between(double min, double max, String errorMessage) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum must not be larger than maximum.");
        }
        return new DoubleRangeValidator(min, max, errorMessage);
    }

    public static DoubleRangeValidator atLeast(double min, String errorMessage) {
        return new DoubleRangeValidator(min, Double.MAX_VALUE, errorMessage);
    }

    public static DoubleRangeValidator upTo(double max, String errorMessage) {
        return new DoubleRangeValidator(Double.MIN_VALUE, max, errorMessage);
    }

    public static DoubleRangeValidator exactly(double value, String errorMessage) {
        return new DoubleRangeValidator(value, value, errorMessage);
    }
}

