/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.event.FieldEvent;
import com.dlsc.formsfx.model.structure.SelectionField;
import com.dlsc.formsfx.model.util.BindingMode;
import com.dlsc.formsfx.model.validators.ValidationResult;
import com.dlsc.formsfx.model.validators.Validator;
import com.dlsc.formsfx.view.controls.SimpleComboBoxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class SingleSelectionField<V>
extends SelectionField<V, SingleSelectionField<V>> {
    protected final ObjectProperty<V> persistentSelection = new SimpleObjectProperty();
    protected final ObjectProperty<V> selection = new SimpleObjectProperty();
    protected final List<Validator<V>> validators = new ArrayList<Validator<V>>();

    protected SingleSelectionField(ListProperty<V> items, int selection) {
        super(items);
        if (selection < items.size() && selection >= 0) {
            this.selection.set(this.items.get(selection));
            this.persistentSelection.setValue(this.selection.getValue());
        }
        this.changed.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.persistentSelection.get() == null ? this.selection.get() != null : !this.persistentSelection.get().equals(this.selection.get()), (Observable[])new Observable[]{this.selection, this.persistentSelection}));
        this.selection.addListener((observable, oldValue, newValue) -> this.validate());
        items.addListener((observable, oldValue, newValue) -> {
            this.selection.setValue(null);
            this.persistentSelection.setValue(null);
        });
        this.rendererSupplier = () -> new SimpleComboBoxControl();
    }

    public SingleSelectionField<V> items(List<V> newValue, int newSelection) {
        this.items.setAll(newValue);
        if (newSelection != -1) {
            this.selection.setValue(this.items.get(newSelection));
            this.persistentSelection.setValue(this.selection.getValue());
        }
        return this;
    }

    public SingleSelectionField<V> items(List<V> newValue) {
        return this.items(newValue, -1);
    }

    @SafeVarargs
    public final SingleSelectionField<V> validate(Validator<V> ... newValue) {
        this.validators.clear();
        Collections.addAll(this.validators, newValue);
        this.validate();
        return this;
    }

    public SingleSelectionField<V> select(int index) {
        if (index == -1) {
            this.selection.setValue(null);
        } else if (index < this.items.size() && index > -1 && (this.selection.get() == null || this.selection.get() != null && !this.selection.get().equals(this.items.get(index)))) {
            this.selection.setValue(this.items.get(index));
        }
        return this;
    }

    public SingleSelectionField<V> deselect() {
        if (this.selection.get() != null) {
            this.selection.setValue(null);
        }
        return this;
    }

    public SingleSelectionField<V> bind(ListProperty<V> itemsBinding, ObjectProperty<V> selectionBinding) {
        this.items.bindBidirectional(itemsBinding);
        this.selection.bindBidirectional(selectionBinding);
        return this;
    }

    public SingleSelectionField<V> unbind(ListProperty<V> itemsBinding, ObjectProperty<V> selectionBinding) {
        this.items.unbindBidirectional(itemsBinding);
        this.selection.unbindBidirectional(selectionBinding);
        return this;
    }

    @Override
    public void setBindingMode(BindingMode newValue) {
        if (BindingMode.CONTINUOUS.equals((Object)newValue)) {
            this.selection.addListener(this.bindingModeListener);
        } else {
            this.selection.removeListener(this.bindingModeListener);
        }
    }

    @Override
    public void persist() {
        if (!this.isValid()) {
            return;
        }
        this.persistentSelection.setValue(this.selection.getValue());
        this.fireEvent(FieldEvent.fieldPersistedEvent(this));
    }

    @Override
    public void reset() {
        if (!this.hasChanged()) {
            return;
        }
        this.selection.setValue(this.persistentSelection.getValue());
        this.fireEvent(FieldEvent.fieldResetEvent(this));
    }

    @Override
    protected boolean validateRequired() {
        return !this.isRequired() || this.isRequired() && this.selection.get() != null;
    }

    @Override
    public boolean validate() {
        List<String> errorMessages = this.validators.stream().map(v -> v.validate(this.selection.getValue())).filter(r -> !r.getResult()).map(ValidationResult::getErrorMessage).collect(Collectors.toList());
        return super.validate(errorMessages);
    }

    public V getSelection() {
        return (V)this.selection.get();
    }

    public ObjectProperty<V> selectionProperty() {
        return this.selection;
    }
}

