/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.structure.Element;
import com.dlsc.formsfx.model.structure.Field;
import com.dlsc.formsfx.model.structure.Group;
import com.dlsc.formsfx.model.util.TranslationService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Section
extends Group {
    protected final StringProperty titleKey = new SimpleStringProperty("");
    protected final StringProperty title = new SimpleStringProperty("");
    protected final BooleanProperty collapsed = new SimpleBooleanProperty(false);
    protected final BooleanProperty collapsible = new SimpleBooleanProperty(true);

    private Section(Element ... elements) {
        super(elements);
        this.titleKey.addListener((observable, oldValue, newValue) -> this.title.setValue(this.translationService.translate((String)newValue)));
    }

    public static Section of(Element ... elements) {
        return new Section(elements);
    }

    public Section title(String newValue) {
        if (this.isI18N()) {
            this.titleKey.set((Object)newValue);
        } else {
            this.title.set((Object)newValue);
        }
        return this;
    }

    @Override
    protected void translate(TranslationService newValue) {
        this.translationService = newValue;
        if (!this.isI18N()) {
            return;
        }
        if (this.titleKey.get() == null || ((String)this.titleKey.get()).isEmpty()) {
            this.titleKey.setValue((String)this.title.get());
        } else {
            this.title.setValue(this.translationService.translate((String)this.titleKey.get()));
        }
        this.elements.stream().filter(e -> e instanceof Field).map(e -> (Field)e).forEach(f -> f.translate(this.translationService));
    }

    public Section collapse(boolean newValue) {
        this.collapsed.setValue(Boolean.valueOf(newValue));
        return this;
    }

    public BooleanProperty collapsedProperty() {
        return this.collapsed;
    }

    public boolean isCollapsed() {
        return this.collapsed.get();
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public Section collapsible(boolean newValue) {
        this.collapsible.set(newValue);
        return this;
    }

    public boolean isCollapsible() {
        return this.collapsible.get();
    }

    public BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }
}

