/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.event.FieldEvent;
import com.dlsc.formsfx.model.structure.SelectionField;
import com.dlsc.formsfx.model.util.BindingMode;
import com.dlsc.formsfx.model.validators.ValidationResult;
import com.dlsc.formsfx.model.validators.Validator;
import com.dlsc.formsfx.view.controls.SimpleListViewControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MultiSelectionField<V>
extends SelectionField<V, MultiSelectionField<V>> {
    protected final ListProperty<V> persistentSelection = new SimpleListProperty(FXCollections.observableArrayList());
    protected final ListProperty<V> selection = new SimpleListProperty(FXCollections.observableArrayList());
    protected final List<Validator<ObservableList<V>>> validators = new ArrayList<Validator<ObservableList<V>>>();

    protected MultiSelectionField(ListProperty<V> items, List<Integer> selection) {
        super(items);
        selection.forEach(i -> {
            if (i < this.items.size() && i >= 0) {
                this.selection.add(this.items.get(i.intValue()));
            }
        });
        this.persistentSelection.addAll((Collection)this.selection.getValue());
        this.changed.bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.persistentSelection.equals(this.selection), (Observable[])new Observable[]{this.selection, this.persistentSelection}));
        this.selection.addListener((observable, oldValue, newValue) -> this.validate());
        items.addListener((observable, oldValue, newValue) -> {
            this.selection.clear();
            this.persistentSelection.clear();
        });
        this.rendererSupplier = () -> new SimpleListViewControl();
    }

    public MultiSelectionField<V> items(List<V> newValue, List<Integer> newSelection) {
        this.items.setAll(newValue);
        newSelection.forEach(i -> this.selection.add(this.items.get(i.intValue())));
        this.persistentSelection.setAll((Collection)this.selection.getValue());
        return this;
    }

    public MultiSelectionField<V> items(List<V> newValue) {
        return this.items(newValue, new ArrayList<Integer>());
    }

    @SafeVarargs
    public final MultiSelectionField<V> validate(Validator<ObservableList<V>> ... newValue) {
        this.validators.clear();
        Collections.addAll(this.validators, newValue);
        this.validate();
        return this;
    }

    public MultiSelectionField<V> select(int index) {
        if (index < this.items.size() && index > -1 && !this.selection.contains(this.items.get(index))) {
            this.selection.add(this.items.get(index));
        }
        return this;
    }

    public MultiSelectionField<V> deselect(int index) {
        if (index < this.items.size() && this.selection.contains(this.items.get(index))) {
            this.selection.remove(this.items.get(index));
        }
        return this;
    }

    public MultiSelectionField<V> bind(ListProperty<V> itemsBinding, ListProperty<V> selectionBinding) {
        this.items.bindBidirectional(itemsBinding);
        this.selection.bindBidirectional(selectionBinding);
        return this;
    }

    public MultiSelectionField<V> unbind(ListProperty<V> itemsBinding, ListProperty<V> selectionBinding) {
        this.items.unbindBidirectional(itemsBinding);
        this.selection.unbindBidirectional(selectionBinding);
        return this;
    }

    @Override
    public void setBindingMode(BindingMode newValue) {
        if (BindingMode.CONTINUOUS.equals((Object)newValue)) {
            this.selection.addListener(this.bindingModeListener);
        } else {
            this.selection.removeListener(this.bindingModeListener);
        }
    }

    @Override
    public void persist() {
        if (!this.isValid()) {
            return;
        }
        this.persistentSelection.setAll((Collection)this.selection.getValue());
        this.fireEvent(FieldEvent.fieldPersistedEvent(this));
    }

    @Override
    public void reset() {
        if (!this.hasChanged()) {
            return;
        }
        this.selection.setAll((Collection)this.persistentSelection.getValue());
        this.fireEvent(FieldEvent.fieldResetEvent(this));
    }

    @Override
    protected boolean validateRequired() {
        return !this.isRequired() || this.isRequired() && this.selection.size() > 0;
    }

    @Override
    public boolean validate() {
        List<String> errorMessages = this.validators.stream().map(v -> v.validate(this.selection.getValue())).filter(r -> !r.getResult()).map(ValidationResult::getErrorMessage).collect(Collectors.toList());
        return super.validate(errorMessages);
    }

    public ObservableList<V> getSelection() {
        return (ObservableList)this.selection.get();
    }

    public ListProperty<V> selectionProperty() {
        return this.selection;
    }
}

