/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.event.GroupEvent;
import com.dlsc.formsfx.model.structure.Element;
import com.dlsc.formsfx.model.structure.Field;
import com.dlsc.formsfx.model.structure.FormElement;
import com.dlsc.formsfx.model.util.TranslationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;

public class Group {
    protected final List<Element> elements = new ArrayList<Element>();
    protected final BooleanProperty valid = new SimpleBooleanProperty(true);
    protected final BooleanProperty changed = new SimpleBooleanProperty(false);
    protected TranslationService translationService;
    private final Map<EventType<GroupEvent>, List<EventHandler<? super GroupEvent>>> eventHandlers = new ConcurrentHashMap<EventType<GroupEvent>, List<EventHandler<? super GroupEvent>>>();

    protected Group(Element ... elements) {
        Collections.addAll(this.elements, elements);
        this.elements.stream().filter(e -> e instanceof Field).map(e -> (Field)e).forEach(f -> f.changedProperty().addListener((observable, oldValue, newValue) -> this.setChangedProperty()));
        this.elements.stream().filter(e -> e instanceof Field).map(e -> (Field)e).forEach(f -> f.validProperty().addListener((observable, oldValue, newValue) -> this.setValidProperty()));
        this.setValidProperty();
        this.setChangedProperty();
    }

    public static Group of(Element ... elements) {
        return new Group(elements);
    }

    protected void translate(TranslationService newValue) {
        this.translationService = newValue;
        if (!this.isI18N()) {
            return;
        }
        this.elements.stream().filter(e -> e instanceof Field).map(e -> (Field)e).forEach(f -> f.translate(this.translationService));
    }

    public void persist() {
        if (!this.isValid()) {
            return;
        }
        this.elements.stream().filter(e -> e instanceof FormElement).map(e -> (FormElement)((Object)e)).forEach(FormElement::persist);
        this.fireEvent(GroupEvent.groupPersistedEvent(this));
    }

    public void reset() {
        if (!this.hasChanged()) {
            return;
        }
        this.elements.stream().filter(e -> e instanceof FormElement).map(e -> (FormElement)((Object)e)).forEach(FormElement::reset);
    }

    private void setChangedProperty() {
        this.changed.setValue(Boolean.valueOf(this.elements.stream().filter(e -> e instanceof Field).map(e -> (Field)e).anyMatch(Field::hasChanged)));
    }

    private void setValidProperty() {
        this.valid.setValue(Boolean.valueOf(this.elements.stream().filter(e -> e instanceof Field).map(e -> (Field)e).allMatch(Field::isValid)));
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public boolean hasChanged() {
        return this.changed.get();
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }

    public boolean isI18N() {
        return this.translationService != null;
    }

    public Group addEventHandler(EventType<GroupEvent> eventType, EventHandler<? super GroupEvent> eventHandler) {
        if (eventType == null) {
            throw new NullPointerException("Argument eventType must not be null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("Argument eventHandler must not be null");
        }
        this.eventHandlers.computeIfAbsent(eventType, k -> new CopyOnWriteArrayList()).add(eventHandler);
        return this;
    }

    public Group removeEventHandler(EventType<GroupEvent> eventType, EventHandler<? super GroupEvent> eventHandler) {
        if (eventType == null) {
            throw new NullPointerException("Argument eventType must not be null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("Argument eventHandler must not be null");
        }
        List<EventHandler<? super GroupEvent>> list = this.eventHandlers.get(eventType);
        if (list != null) {
            list.remove(eventHandler);
        }
        return this;
    }

    protected void fireEvent(GroupEvent event) {
        List<EventHandler<? super GroupEvent>> list = this.eventHandlers.get(event.getEventType());
        if (list == null) {
            return;
        }
        for (EventHandler<? super GroupEvent> eventHandler : list) {
            if (event.isConsumed()) continue;
            eventHandler.handle((Event)event);
        }
    }
}

