/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.event.FormEvent;
import com.dlsc.formsfx.model.structure.Element;
import com.dlsc.formsfx.model.structure.Field;
import com.dlsc.formsfx.model.structure.Group;
import com.dlsc.formsfx.model.util.BindingMode;
import com.dlsc.formsfx.model.util.TranslationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;

public class Form {
    protected final List<Group> groups = new ArrayList<Group>();
    protected final StringProperty title = new SimpleStringProperty("");
    protected final StringProperty titleKey = new SimpleStringProperty("");
    protected final BooleanProperty valid = new SimpleBooleanProperty(true);
    protected final BooleanProperty changed = new SimpleBooleanProperty(false);
    protected final BooleanProperty persistable = new SimpleBooleanProperty(false);
    protected final ObjectProperty<TranslationService> translationService = new SimpleObjectProperty();
    protected final Runnable localeChangeListener = this::translate;
    private final Map<EventType<FormEvent>, List<EventHandler<? super FormEvent>>> eventHandlers = new ConcurrentHashMap<EventType<FormEvent>, List<EventHandler<? super FormEvent>>>();

    private Form(Group ... groups) {
        Collections.addAll(this.groups, groups);
        this.groups.forEach(s -> s.changedProperty().addListener((observable, oldValue, newValue) -> this.setChangedProperty()));
        this.groups.forEach(s -> s.validProperty().addListener((observable, oldValue, newValue) -> this.setValidProperty()));
        this.setValidProperty();
        this.setChangedProperty();
        this.setPersistableProperty();
        this.titleKey.addListener((observable, oldValue, newValue) -> this.title.setValue(((TranslationService)this.translationService.get()).translate((String)newValue)));
        this.translationService.addListener((observable, oldValue, newValue) -> this.translate());
    }

    public static Form of(Group ... sections) {
        return new Form(sections);
    }

    public Form title(String newValue) {
        if (this.isI18N()) {
            this.titleKey.set((Object)newValue);
        } else {
            this.title.set((Object)newValue);
        }
        return this;
    }

    public Form i18n(TranslationService newValue) {
        if (this.translationService.get() != null) {
            ((TranslationService)this.translationService.get()).removeListener(this.localeChangeListener);
        }
        this.translationService.setValue((Object)newValue);
        ((TranslationService)this.translationService.get()).addListener(this.localeChangeListener);
        return this;
    }

    public Form binding(BindingMode newValue) {
        this.getFields().forEach(f -> f.setBindingMode(newValue));
        return this;
    }

    protected void translate() {
        TranslationService tr = (TranslationService)this.translationService.get();
        if (!this.isI18N()) {
            return;
        }
        if (this.titleKey.get() == null || ((String)this.titleKey.get()).isEmpty()) {
            this.titleKey.setValue((String)this.title.get());
        } else {
            this.title.setValue(tr.translate((String)this.titleKey.get()));
        }
        this.groups.forEach(s -> s.translate(tr));
    }

    public void persist() {
        if (!this.isPersistable()) {
            return;
        }
        this.groups.forEach(Group::persist);
        this.fireEvent(FormEvent.formPersistedEvent(this));
    }

    public void reset() {
        if (!this.hasChanged()) {
            return;
        }
        this.groups.forEach(Group::reset);
        this.fireEvent(FormEvent.formResetEvent(this));
    }

    protected void setChangedProperty() {
        this.changed.setValue(Boolean.valueOf(this.groups.stream().anyMatch(Group::hasChanged)));
        this.setPersistableProperty();
    }

    protected void setValidProperty() {
        this.valid.setValue(Boolean.valueOf(this.groups.stream().allMatch(Group::isValid)));
        this.setPersistableProperty();
    }

    protected void setPersistableProperty() {
        this.persistable.setValue(Boolean.valueOf(this.groups.stream().anyMatch(Group::hasChanged) && this.groups.stream().allMatch(Group::isValid)));
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Element> getElements() {
        return this.groups.stream().map(Group::getElements).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Field> getFields() {
        return this.groups.stream().map(Group::getElements).flatMap(Collection::stream).filter(e -> e instanceof Field).map(e -> (Field)e).collect(Collectors.toList());
    }

    public boolean hasChanged() {
        return this.changed.get();
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }

    public boolean isPersistable() {
        return this.persistable.get();
    }

    public BooleanProperty persistableProperty() {
        return this.persistable;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public boolean isI18N() {
        return this.translationService.get() != null;
    }

    public Form addEventHandler(EventType<FormEvent> eventType, EventHandler<? super FormEvent> eventHandler) {
        if (eventType == null) {
            throw new NullPointerException("Argument eventType must not be null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("Argument eventHandler must not be null");
        }
        this.eventHandlers.computeIfAbsent(eventType, k -> new CopyOnWriteArrayList()).add(eventHandler);
        return this;
    }

    public Form removeEventHandler(EventType<FormEvent> eventType, EventHandler<? super FormEvent> eventHandler) {
        if (eventType == null) {
            throw new NullPointerException("Argument eventType must not be null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("Argument eventHandler must not be null");
        }
        List<EventHandler<? super FormEvent>> list = this.eventHandlers.get(eventType);
        if (list != null) {
            list.remove(eventHandler);
        }
        return this;
    }

    protected void fireEvent(FormEvent event) {
        List<EventHandler<? super FormEvent>> list = this.eventHandlers.get(event.getEventType());
        if (list == null) {
            return;
        }
        for (EventHandler<? super FormEvent> eventHandler : list) {
            if (event.isConsumed()) continue;
            eventHandler.handle((Event)event);
        }
    }
}

