/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.event.FieldEvent;
import com.dlsc.formsfx.model.structure.BooleanField;
import com.dlsc.formsfx.model.structure.DateField;
import com.dlsc.formsfx.model.structure.DoubleField;
import com.dlsc.formsfx.model.structure.Element;
import com.dlsc.formsfx.model.structure.FormElement;
import com.dlsc.formsfx.model.structure.IntegerField;
import com.dlsc.formsfx.model.structure.MultiSelectionField;
import com.dlsc.formsfx.model.structure.PasswordField;
import com.dlsc.formsfx.model.structure.SingleSelectionField;
import com.dlsc.formsfx.model.structure.StringField;
import com.dlsc.formsfx.model.util.BindingMode;
import com.dlsc.formsfx.model.util.TranslationService;
import com.dlsc.formsfx.view.controls.SimpleControl;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;

public abstract class Field<F extends Field<F>>
extends Element<F>
implements FormElement {
    protected final StringProperty label = new SimpleStringProperty("");
    protected final StringProperty labelKey = new SimpleStringProperty("");
    protected final StringProperty tooltip = new SimpleStringProperty("");
    protected final StringProperty tooltipKey = new SimpleStringProperty("");
    protected final StringProperty placeholder = new SimpleStringProperty("");
    protected final StringProperty placeholderKey = new SimpleStringProperty("");
    protected final StringProperty requiredErrorKey = new SimpleStringProperty("");
    protected final StringProperty requiredError = new SimpleStringProperty("");
    protected final BooleanProperty required = new SimpleBooleanProperty(false);
    protected final BooleanProperty editable = new SimpleBooleanProperty(true);
    protected final BooleanProperty valid = new SimpleBooleanProperty(true);
    protected final BooleanProperty changed = new SimpleBooleanProperty(false);
    protected final StringProperty id = new SimpleStringProperty(UUID.randomUUID().toString());
    protected final ListProperty<String> styleClass = new SimpleListProperty(FXCollections.observableArrayList());
    protected final IntegerProperty span = new SimpleIntegerProperty(12);
    protected final ListProperty<String> errorMessages = new SimpleListProperty(FXCollections.observableArrayList());
    protected final ListProperty<String> errorMessageKeys = new SimpleListProperty(FXCollections.observableArrayList());
    private Node labelDescription;
    private Node valueDescription;
    private final StringProperty labelDescriptionKey = new SimpleStringProperty("");
    private final StringProperty valueDescriptionKey = new SimpleStringProperty("");
    private static final String LABEL_DESCRIPTION_STYLE_CLASS = "field-label-description";
    private static final String VALUE_DESCRIPTION_STYLE_CLASS = "field-value-description";
    protected TranslationService translationService;
    protected SimpleControl<F> renderer;
    protected Supplier<SimpleControl<F>> rendererSupplier;
    protected final Map<EventType<FieldEvent>, List<EventHandler<? super FieldEvent>>> eventHandlers = new ConcurrentHashMap<EventType<FieldEvent>, List<EventHandler<? super FieldEvent>>>();
    protected final InvalidationListener bindingModeListener = observable -> {
        if (this.validate()) {
            this.persist();
        }
    };

    protected Field() {
        this.labelKey.addListener((observable, oldValue, newValue) -> this.label.setValue(this.translationService.translate((String)newValue)));
        this.tooltipKey.addListener((observable, oldValue, newValue) -> this.tooltip.setValue(this.translationService.translate((String)newValue)));
        this.placeholderKey.addListener((observable, oldValue, newValue) -> this.placeholder.setValue(this.translationService.translate((String)newValue)));
        this.labelDescriptionKey.addListener((observable, oldValue, newValue) -> {
            this.labelDescription = this.asLabel(this.translationService.translate((String)newValue), LABEL_DESCRIPTION_STYLE_CLASS);
        });
        this.valueDescriptionKey.addListener((observable, oldValue, newValue) -> {
            this.valueDescription = this.asLabel(this.translationService.translate((String)newValue), VALUE_DESCRIPTION_STYLE_CLASS);
        });
        this.requiredErrorKey.addListener((observable, oldValue, newValue) -> this.validate());
        this.errorMessageKeys.addListener((observable, oldValue, newValue) -> this.errorMessages.setAll((Collection)this.errorMessageKeys.stream().map(s -> this.translationService.translate((String)s)).collect(Collectors.toList())));
    }

    public static PasswordField ofPasswordType(String defaultValue) {
        return new PasswordField(new SimpleStringProperty(defaultValue), new SimpleStringProperty(defaultValue));
    }

    public static PasswordField ofPasswordType(StringProperty binding) {
        return (PasswordField)new PasswordField(new SimpleStringProperty(binding.getValue()), new SimpleStringProperty(binding.getValue())).bind(binding);
    }

    public static StringField ofStringType(String defaultValue) {
        return new StringField(new SimpleStringProperty(defaultValue), new SimpleStringProperty(defaultValue));
    }

    public static StringField ofStringType(StringProperty binding) {
        return (StringField)new StringField(new SimpleStringProperty(binding.getValue()), new SimpleStringProperty(binding.getValue())).bind(binding);
    }

    public static DoubleField ofDoubleType(double defaultValue) {
        return new DoubleField(new SimpleDoubleProperty(defaultValue), new SimpleDoubleProperty(defaultValue));
    }

    public static DoubleField ofDoubleType(DoubleProperty binding) {
        return (DoubleField)new DoubleField(new SimpleDoubleProperty(binding.getValue().doubleValue()), new SimpleDoubleProperty(binding.getValue().doubleValue())).bind(binding);
    }

    public static IntegerField ofIntegerType(int defaultValue) {
        return new IntegerField(new SimpleIntegerProperty(defaultValue), new SimpleIntegerProperty(defaultValue));
    }

    public static IntegerField ofIntegerType(IntegerProperty binding) {
        return (IntegerField)new IntegerField(new SimpleIntegerProperty(binding.getValue().intValue()), new SimpleIntegerProperty(binding.getValue().intValue())).bind(binding);
    }

    public static BooleanField ofBooleanType(boolean defaultValue) {
        return new BooleanField(new SimpleBooleanProperty(defaultValue), new SimpleBooleanProperty(defaultValue));
    }

    public static BooleanField ofBooleanType(BooleanProperty binding) {
        return (BooleanField)new BooleanField(new SimpleBooleanProperty(binding.getValue().booleanValue()), new SimpleBooleanProperty(binding.getValue().booleanValue())).bind(binding);
    }

    public static <T> MultiSelectionField<T> ofMultiSelectionType(List<T> items, List<Integer> selection) {
        return new MultiSelectionField(new SimpleListProperty(FXCollections.observableArrayList(items)), selection);
    }

    public static <T> MultiSelectionField<T> ofMultiSelectionType(List<T> items) {
        return new MultiSelectionField(new SimpleListProperty(FXCollections.observableArrayList(items)), (List<Integer>)new ArrayList<Integer>());
    }

    public static <T> MultiSelectionField<T> ofMultiSelectionType(ListProperty<T> itemsBinding, ListProperty<T> selectionBinding) {
        return new MultiSelectionField<T>(new SimpleListProperty(itemsBinding.getValue()), (List<Integer>)new ArrayList<Integer>(selectionBinding.getValue().stream().map(t -> itemsBinding.getValue().indexOf(t)).collect(Collectors.toList()))).bind(itemsBinding, selectionBinding);
    }

    public static <T> SingleSelectionField<T> ofSingleSelectionType(List<T> items, int selection) {
        return new SingleSelectionField(new SimpleListProperty(FXCollections.observableArrayList(items)), selection);
    }

    public static <T> SingleSelectionField<T> ofSingleSelectionType(List<T> items) {
        return new SingleSelectionField(new SimpleListProperty(FXCollections.observableArrayList(items)), -1);
    }

    public static <T> SingleSelectionField<T> ofSingleSelectionType(ListProperty<T> itemsBinding, ObjectProperty<T> selectionBinding) {
        return new SingleSelectionField<T>(new SimpleListProperty(itemsBinding.getValue()), itemsBinding.indexOf(selectionBinding.getValue())).bind(itemsBinding, selectionBinding);
    }

    public static DateField ofDate(LocalDate defaultValue) {
        return new DateField((ObjectProperty<LocalDate>)new SimpleObjectProperty((Object)defaultValue), (ObjectProperty<LocalDate>)new SimpleObjectProperty((Object)defaultValue));
    }

    public static DateField ofDate(ObjectProperty<LocalDate> binding) {
        return new DateField((ObjectProperty<LocalDate>)new SimpleObjectProperty((Object)((LocalDate)binding.getValue())), (ObjectProperty<LocalDate>)new SimpleObjectProperty((Object)((LocalDate)binding.getValue()))).bind(binding);
    }

    public F required(boolean newValue) {
        this.required.set(newValue);
        this.validate();
        return (F)this;
    }

    public F required(String errorMessage) {
        this.required.set(true);
        if (this.isI18N()) {
            this.requiredErrorKey.set((Object)errorMessage);
        } else {
            this.requiredError.set((Object)errorMessage);
        }
        this.validate();
        return (F)this;
    }

    public F editable(boolean newValue) {
        this.editable.set(newValue);
        return (F)this;
    }

    public F label(String newValue) {
        if (this.isI18N()) {
            this.labelKey.set((Object)newValue);
        } else {
            this.label.set((Object)newValue);
        }
        return (F)this;
    }

    public F labelDescription(Node newValue) {
        this.labelDescription = newValue;
        if (this.labelDescription != null) {
            this.labelDescription.getStyleClass().add((Object)LABEL_DESCRIPTION_STYLE_CLASS);
        }
        return (F)this;
    }

    public F labelDescription(String newValue) {
        if (this.isI18N()) {
            this.labelDescriptionKey.set((Object)newValue);
        } else if (newValue != null) {
            this.labelDescription = this.asLabel(newValue, LABEL_DESCRIPTION_STYLE_CLASS);
        }
        return (F)this;
    }

    public F valueDescription(Node newValue) {
        this.valueDescription = newValue;
        if (this.valueDescription != null) {
            this.valueDescription.getStyleClass().add((Object)VALUE_DESCRIPTION_STYLE_CLASS);
        }
        return (F)this;
    }

    public F valueDescription(String newValue) {
        if (this.isI18N()) {
            this.valueDescriptionKey.set((Object)newValue);
        } else if (newValue != null) {
            this.valueDescription = this.asLabel(newValue, VALUE_DESCRIPTION_STYLE_CLASS);
        }
        return (F)this;
    }

    private Label asLabel(String text, String styleClass) {
        Label label = new Label(text);
        label.setWrapText(true);
        label.getStyleClass().add((Object)styleClass);
        return label;
    }

    public F tooltip(String newValue) {
        if (this.isI18N()) {
            this.tooltipKey.set((Object)newValue);
        } else {
            this.tooltip.set((Object)newValue);
        }
        return (F)this;
    }

    public F placeholder(String newValue) {
        if (this.isI18N()) {
            this.placeholderKey.set((Object)newValue);
        } else {
            this.placeholder.set((Object)newValue);
        }
        return (F)this;
    }

    public F render(SimpleControl<F> newValue) {
        this.renderer = newValue;
        return (F)this;
    }

    public F render(Supplier<SimpleControl<F>> newValue) {
        this.rendererSupplier = newValue;
        return (F)this;
    }

    public abstract void setBindingMode(BindingMode var1);

    public void translate(TranslationService newValue) {
        this.translationService = newValue;
        if (!this.isI18N()) {
            return;
        }
        this.updateElement(this.label, this.labelKey);
        this.updateElement(this.tooltip, this.tooltipKey);
        this.updateElement(this.placeholder, this.placeholderKey);
        this.updateElement(this.requiredError, this.requiredErrorKey);
        this.updateElement(this.labelDescription, this.labelDescriptionKey);
        this.updateElement(this.valueDescription, this.valueDescriptionKey);
        this.validate();
    }

    protected void updateElement(StringProperty displayProperty, StringProperty keyProperty) {
        if ((keyProperty.get() == null || ((String)keyProperty.get()).isEmpty()) && !((String)displayProperty.get()).isEmpty()) {
            keyProperty.setValue((String)displayProperty.get());
        } else if (!((String)keyProperty.get()).isEmpty()) {
            displayProperty.setValue(this.translationService.translate((String)keyProperty.get()));
        }
    }

    void updateElement(Node node, StringProperty keyProperty) {
        if (!(node instanceof Labeled)) {
            return;
        }
        Labeled labeled = (Labeled)node;
        if ((keyProperty.get() == null || ((String)keyProperty.get()).isEmpty()) && !labeled.getText().isEmpty()) {
            keyProperty.setValue(labeled.getText());
        } else if (!((String)keyProperty.get()).isEmpty()) {
            labeled.setText(this.translationService.translate((String)keyProperty.get()));
        }
    }

    protected abstract boolean validate();

    public String getPlaceholder() {
        return (String)this.placeholder.get();
    }

    public StringProperty placeholderProperty() {
        return this.placeholder;
    }

    public String getLabel() {
        return (String)this.label.get();
    }

    public StringProperty labelProperty() {
        return this.label;
    }

    public String getTooltip() {
        return (String)this.tooltip.get();
    }

    public StringProperty tooltipProperty() {
        return this.tooltip;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }

    public boolean hasChanged() {
        return this.changed.get();
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    public boolean isRequired() {
        return this.required.get();
    }

    public BooleanProperty requiredProperty() {
        return this.required;
    }

    public boolean isEditable() {
        return this.editable.get();
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public boolean isI18N() {
        return this.translationService != null;
    }

    public SimpleControl<F> getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.rendererSupplier.get();
        }
        return this.renderer;
    }

    public List<String> getErrorMessages() {
        return (List)this.errorMessages.get();
    }

    public ListProperty<String> errorMessagesProperty() {
        return this.errorMessages;
    }

    public Field addEventHandler(EventType<FieldEvent> eventType, EventHandler<? super FieldEvent> eventHandler) {
        if (eventType == null) {
            throw new NullPointerException("Argument eventType must not be null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("Argument eventHandler must not be null");
        }
        this.eventHandlers.computeIfAbsent(eventType, k -> new CopyOnWriteArrayList()).add(eventHandler);
        return this;
    }

    public Field removeEventHandler(EventType<FieldEvent> eventType, EventHandler<? super FieldEvent> eventHandler) {
        if (eventType == null) {
            throw new NullPointerException("Argument eventType must not be null");
        }
        if (eventHandler == null) {
            throw new NullPointerException("Argument eventHandler must not be null");
        }
        List<EventHandler<? super FieldEvent>> list = this.eventHandlers.get(eventType);
        if (list != null) {
            list.remove(eventHandler);
        }
        return this;
    }

    protected void fireEvent(FieldEvent event) {
        List<EventHandler<? super FieldEvent>> list = this.eventHandlers.get(event.getEventType());
        if (list == null) {
            return;
        }
        for (EventHandler<? super FieldEvent> eventHandler : list) {
            if (event.isConsumed()) continue;
            eventHandler.handle((Event)event);
        }
    }

    public Node getLabelDescription() {
        return this.labelDescription;
    }

    public Node getValueDescription() {
        return this.valueDescription;
    }
}

