/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.formsfx.model.structure;

import com.dlsc.formsfx.model.event.FieldEvent;
import com.dlsc.formsfx.model.structure.Field;
import com.dlsc.formsfx.model.util.BindingMode;
import com.dlsc.formsfx.model.util.TranslationService;
import com.dlsc.formsfx.model.util.ValueTransformer;
import com.dlsc.formsfx.model.validators.ValidationResult;
import com.dlsc.formsfx.model.validators.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.util.StringConverter;

public abstract class DataField<P extends Property, V, F extends Field<F>>
extends Field<F> {
    protected final P value;
    protected final P persistentValue;
    protected final StringProperty userInput = new SimpleStringProperty("");
    protected final List<Validator<V>> validators = new ArrayList<Validator<V>>();
    @Deprecated
    ValueTransformer<V> valueTransformer;
    protected StringConverter<V> stringConverter = new AbstractStringConverter<V>(){

        public V fromString(String string) {
            return null;
        }
    };
    protected final StringProperty formatErrorKey = new SimpleStringProperty("");
    protected final StringProperty formatError = new SimpleStringProperty("");
    private final InvalidationListener externalBindingListener = observable -> this.userInput.setValue(this.stringConverter.toString(((Property)observable).getValue()));

    protected DataField(P valueProperty, P persistentValueProperty) {
        this.value = valueProperty;
        this.persistentValue = persistentValueProperty;
        this.changed.bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.stringConverter.toString(this.persistentValue.getValue()).equals(this.userInput.getValue()), (Observable[])new Observable[]{this.userInput, this.persistentValue}));
        this.formatErrorKey.addListener((observable, oldValue, newValue) -> this.formatError.setValue(this.translationService.translate((String)newValue)));
        this.userInput.addListener((observable, oldValue, newValue) -> {
            if (this.validate()) {
                this.value.setValue(this.stringConverter.fromString(newValue));
            }
        });
    }

    public F format(StringConverter<V> newValue) {
        this.stringConverter = newValue;
        this.validate();
        return (F)this;
    }

    public F format(StringConverter<V> newValue, String errorMessage) {
        this.stringConverter = newValue;
        if (this.isI18N()) {
            this.formatErrorKey.set((Object)errorMessage);
        } else {
            this.formatError.set((Object)errorMessage);
        }
        this.validate();
        return (F)this;
    }

    @Deprecated
    public F format(ValueTransformer<V> newValue) {
        this.stringConverter = new StringConverterAdapter<V>(newValue);
        this.validate();
        return (F)this;
    }

    @Deprecated
    public F format(ValueTransformer<V> newValue, String errorMessage) {
        this.stringConverter = new StringConverterAdapter<V>(newValue);
        if (this.isI18N()) {
            this.formatErrorKey.set((Object)errorMessage);
        } else {
            this.formatError.set((Object)errorMessage);
        }
        this.validate();
        return (F)this;
    }

    public F format(String errorMessage) {
        if (this.isI18N()) {
            this.formatErrorKey.set((Object)errorMessage);
        } else {
            this.formatError.set((Object)errorMessage);
        }
        this.validate();
        return (F)this;
    }

    @SafeVarargs
    public final F validate(Validator<V> ... newValue) {
        this.validators.clear();
        Collections.addAll(this.validators, newValue);
        this.validate();
        return (F)this;
    }

    public F bind(P binding) {
        this.persistentValue.bindBidirectional(binding);
        binding.addListener(this.externalBindingListener);
        return (F)this;
    }

    public F unbind(P binding) {
        this.persistentValue.unbindBidirectional(binding);
        binding.removeListener(this.externalBindingListener);
        return (F)this;
    }

    @Override
    public void setBindingMode(BindingMode newValue) {
        if (BindingMode.CONTINUOUS.equals((Object)newValue)) {
            this.value.addListener(this.bindingModeListener);
        } else {
            this.value.removeListener(this.bindingModeListener);
        }
    }

    @Override
    public void persist() {
        if (!this.isValid()) {
            return;
        }
        this.persistentValue.setValue(this.value.getValue());
        this.fireEvent(FieldEvent.fieldPersistedEvent(this));
    }

    @Override
    public void reset() {
        if (!this.hasChanged()) {
            return;
        }
        this.userInput.setValue(this.stringConverter.toString(this.persistentValue.getValue()));
    }

    protected boolean validateRequired(String newValue) {
        return !this.isRequired() || this.isRequired() && !newValue.isEmpty();
    }

    @Override
    public boolean validate() {
        Object transformedValue;
        String newValue = this.userInput.getValue();
        if (!this.validateRequired(newValue)) {
            if (this.isI18N() && !((String)this.requiredErrorKey.get()).isEmpty()) {
                this.errorMessageKeys.setAll((Object[])new String[]{(String)this.requiredErrorKey.get()});
            } else if (!((String)this.requiredError.get()).isEmpty()) {
                this.errorMessages.setAll((Object[])new String[]{(String)this.requiredError.get()});
            }
            this.valid.set(false);
            return false;
        }
        try {
            transformedValue = this.stringConverter.fromString(newValue);
        }
        catch (Exception e) {
            if (this.isI18N() && !((String)this.formatErrorKey.get()).isEmpty()) {
                this.errorMessageKeys.setAll((Object[])new String[]{(String)this.formatErrorKey.get()});
            } else if (!((String)this.formatError.get()).isEmpty()) {
                this.errorMessages.setAll((Object[])new String[]{(String)this.formatError.get()});
            }
            this.valid.set(false);
            return false;
        }
        List errorMessages = this.validators.stream().map(v -> v.validate(transformedValue)).filter(r -> !r.getResult()).map(ValidationResult::getErrorMessage).collect(Collectors.toList());
        if (this.isI18N()) {
            this.errorMessageKeys.setAll(errorMessages);
        } else {
            this.errorMessages.setAll(errorMessages);
        }
        if (errorMessages.size() > 0) {
            this.valid.set(false);
            return false;
        }
        this.valid.set(true);
        return true;
    }

    @Override
    public void translate(TranslationService service) {
        super.translate(service);
        this.updateElement(this.formatError, this.formatErrorKey);
        this.validate();
    }

    public String getUserInput() {
        return (String)this.userInput.get();
    }

    public StringProperty userInputProperty() {
        return this.userInput;
    }

    public V getValue() {
        return (V)this.value.getValue();
    }

    public P valueProperty() {
        return this.value;
    }

    private static class StringConverterAdapter<V>
    extends AbstractStringConverter<V> {
        private final ValueTransformer<V> valueTransformer;

        public StringConverterAdapter(ValueTransformer<V> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        public V fromString(String string) {
            return this.valueTransformer.transform(string);
        }
    }

    protected static abstract class AbstractStringConverter<V>
    extends StringConverter<V> {
        protected AbstractStringConverter() {
        }

        public String toString(V object) {
            return String.valueOf(object);
        }
    }
}

