/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class ReadTimeout
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;
    public final boolean dataPresent;

    public ReadTimeout(String message, int consistencyLevel, int received, int blockFor, boolean dataPresent) {
        super(4608, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
        this.dataPresent = dataPresent;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(4608, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            ReadTimeout readTimeout = (ReadTimeout)message;
            encoder.writeString(readTimeout.message, dest);
            encoder.writeUnsignedShort(readTimeout.consistencyLevel, dest);
            encoder.writeInt(readTimeout.received, dest);
            encoder.writeInt(readTimeout.blockFor, dest);
            encoder.writeByte((byte)(readTimeout.dataPresent ? 1 : 0), dest);
        }

        @Override
        public int encodedSize(Message message) {
            ReadTimeout readTimeout = (ReadTimeout)message;
            return PrimitiveSizes.sizeOfString(readTimeout.message) + 2 + 4 + 4 + 1;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String message = decoder.readString(source);
            int consistencyLevel = decoder.readUnsignedShort(source);
            int received = decoder.readInt(source);
            int blockFor = decoder.readInt(source);
            boolean dataPresent = decoder.readByte(source) != 0;
            return new ReadTimeout(message, consistencyLevel, received, blockFor, dataPresent);
        }
    }
}

