/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc41;

import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.interfaces.IResults;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResultType;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SForwardResultSet;
import com.databricks.client.jdbc.common.SPreparedStatement;
import com.databricks.client.jdbc.common.SResultSetMetaData;
import com.databricks.client.jdbc.jdbc41.S41ForwardResultSet;
import com.databricks.client.jdbc.jdbc41.S41ParameterMetaData;
import com.databricks.client.jdbc.jdbc41.S41ResultSetMetaData;
import com.databricks.client.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.utilities.JDBCVersion;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class S41PreparedStatement
extends SPreparedStatement {
    public S41PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S41UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S41ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults iResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = iResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(iResultSet));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet iResultSet) throws SQLException {
        try {
            List list = iResultSet.getSelectColumns();
            if (null == list) {
                return null;
            }
            return new S41ResultSetMetaData(list, this.getLogger(), this.getWarningListener());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData s41ParameterMetaData = null;
                s41ParameterMetaData = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s41ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

