/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.wallet;

import dm.jdbc.util.FileUtil;
import dm.jdbc.util.wallet.DerIndefLenConverter;
import dm.jdbc.util.wallet.DerInputBuffer;
import dm.jdbc.util.wallet.DerInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DerValue {
    public byte tag;
    protected DerInputBuffer buffer;
    public final DerInputStream data;
    private int length;
    public static final byte tag_Sequence = 48;
    public static final byte tag_Integer = 2;

    public DerValue(InputStream in, boolean allowBER) throws IOException {
        this.data = this.init(false, in, allowBER);
    }

    private DerInputStream init(boolean fullyBuffered, InputStream in, boolean allowBER) throws IOException {
        this.tag = (byte)in.read();
        byte lenByte = (byte)in.read();
        this.length = DerInputStream.getLength(lenByte, in);
        if (this.length == -1) {
            if (this.tag != (in = new ByteArrayInputStream(DerIndefLenConverter.convertStream(in, lenByte, this.tag))).read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getDefiniteLength(in);
        }
        if (fullyBuffered && in.available() != this.length) {
            throw new IOException("extra data given to DerValue constructor");
        }
        byte[] bytes = FileUtil.readExactlyNBytes(in, this.length);
        this.buffer = new DerInputBuffer(bytes, allowBER);
        return new DerInputStream(this.buffer);
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getBigInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available(), false);
    }
}

