/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.wallet;

import dm.jdbc.util.wallet.DerIndefLenConverter;
import dm.jdbc.util.wallet.DerInputBuffer;
import dm.jdbc.util.wallet.DerValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class DerInputStream {
    DerInputBuffer buffer;
    public byte tag;

    public DerInputStream(byte[] data) throws IOException {
        this.init(data, 0, data.length, true);
    }

    DerInputStream(DerInputBuffer buf) {
        this.buffer = buf;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    private void init(byte[] data, int offset, int len, boolean allowBER) throws IOException {
        if (offset + 2 > data.length || offset + len > data.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(data[offset + 1])) {
            if (!allowBER) {
                throw new IOException("Indefinite length BER encoding found");
            }
            byte[] inData = new byte[len];
            System.arraycopy(data, offset, inData, 0, len);
            DerIndefLenConverter derIn = new DerIndefLenConverter();
            byte[] result = derIn.convertBytes(inData);
            if (result == null) {
                throw new IOException("not all indef len BER resolved");
            }
            this.buffer = new DerInputBuffer(result, allowBER);
        } else {
            this.buffer = new DerInputBuffer(data, offset, len, allowBER);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerValue[] getSequence(int startLen) throws IOException {
        this.tag = (byte)this.buffer.read();
        if (this.tag != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(startLen);
    }

    protected DerValue[] readVector(int startLen) throws IOException {
        byte lenByte = (byte)this.buffer.read();
        int len = DerInputStream.getLength(lenByte, this.buffer);
        if (len == -1) {
            this.buffer = new DerInputBuffer(DerIndefLenConverter.convertStream(this.buffer, lenByte, this.tag), this.buffer.allowBER);
            if (this.tag != this.buffer.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            len = DerInputStream.getDefiniteLength(this.buffer);
        }
        if (len == 0) {
            return new DerValue[0];
        }
        DerInputStream newStr = this.buffer.available() == len ? this : this.subStream(len, true);
        Vector<DerValue> vec = new Vector<DerValue>(startLen);
        do {
            DerValue value = new DerValue(newStr.buffer, this.buffer.allowBER);
            vec.addElement(value);
        } while (newStr.available() > 0);
        if (newStr.available() != 0) {
            throw new IOException("Extra data at end of vector");
        }
        int max = vec.size();
        DerValue[] retval = new DerValue[max];
        int i2 = 0;
        while (i2 < max) {
            retval[i2] = (DerValue)vec.elementAt(i2);
            ++i2;
        }
        return retval;
    }

    /*
     * Unable to fully structure code
     */
    static int getLength(int lenByte, InputStream in) throws IOException {
        block7: {
            block6: {
                if (lenByte == -1) {
                    throw new IOException("Short read of DER length");
                }
                mdName = "DerInputStream.getLength(): ";
                tmp = lenByte;
                if ((tmp & 128) != 0) break block6;
                value = tmp;
                break block7;
            }
            if ((tmp &= 127) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException(String.valueOf(mdName) + "lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            value = 255 & in.read();
            --tmp;
            if (value != 0) ** GOTO lbl19
            throw new IOException(String.valueOf(mdName) + "Redundant length bytes found");
lbl-1000:
            // 1 sources

            {
                value <<= 8;
                value += 255 & in.read();
lbl19:
                // 2 sources

                ** while (tmp-- > 0)
            }
lbl20:
            // 1 sources

            if (value < 0) {
                throw new IOException(String.valueOf(mdName) + "Invalid length bytes");
            }
            if (value <= 127) {
                throw new IOException(String.valueOf(mdName) + "Should use short form for length");
            }
        }
        return value;
    }

    int getDefiniteLength() throws IOException {
        return DerInputStream.getDefiniteLength(this.buffer);
    }

    static int getDefiniteLength(InputStream in) throws IOException {
        int len = DerInputStream.getLength(in);
        if (len < 0) {
            throw new IOException("Indefinite length encoding not supported");
        }
        return len;
    }

    static int getLength(InputStream in) throws IOException {
        return DerInputStream.getLength(in.read(), in);
    }

    public DerInputStream subStream(int len, boolean do_skip) throws IOException {
        DerInputBuffer newbuf = this.buffer.dup();
        newbuf.truncate(len);
        if (do_skip) {
            this.buffer.skip(len);
        }
        return new DerInputStream(newbuf);
    }

    public int available() {
        return this.buffer.available();
    }
}

