/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.wallet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    boolean allowBER = true;

    DerInputBuffer(byte[] buf, boolean allowBER) {
        super(buf);
        this.allowBER = allowBER;
    }

    DerInputBuffer(byte[] buf, int offset, int len, boolean allowBER) {
        super(buf, offset, len);
        this.allowBER = allowBER;
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer retval = (DerInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalArgumentException(e2.toString());
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)other);
        }
        return false;
    }

    boolean equals(DerInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        int i2 = 0;
        while (i2 < max) {
            if (this.buf[this.pos + i2] != other.buf[other.pos + i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        int len = this.available();
        int p2 = this.pos;
        int i2 = 0;
        while (i2 < len) {
            retval += this.buf[p2 + i2] * i2;
            ++i2;
        }
        return retval;
    }

    void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    BigInteger getBigInteger(int len, boolean makePositive) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of integer");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        if (!this.allowBER && len >= 2 && bytes[0] == 0 && bytes[1] >= 0) {
            throw new IOException("Invalid encoding: redundant leading 0s");
        }
        if (makePositive) {
            return new BigInteger(1, bytes);
        }
        return new BigInteger(bytes);
    }

    public int getInteger(int len) throws IOException {
        BigInteger result = this.getBigInteger(len, false);
        if (result.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new IOException("Integer below minimum valid value");
        }
        if (result.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new IOException("Integer exceeds maximum valid value");
        }
        return result.intValue();
    }

    private static int checkPaddedBits(int numOfPadBits, byte[] data, int start, int end, boolean allowBER) throws IOException {
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        int lenInBits = (end - start << 3) - numOfPadBits;
        if (lenInBits < 0) {
            throw new IOException("Not enough bytes in BitString");
        }
        if (!allowBER && numOfPadBits != 0 && (data[end - 1] & 255 >>> 8 - numOfPadBits) != 0) {
            throw new IOException("Invalid value of padding bits");
        }
        return lenInBits;
    }

    public byte[] getBitString(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        int start = this.pos;
        int end = start + len;
        this.skip(len);
        byte numOfPadBits = this.buf[start++];
        DerInputBuffer.checkPaddedBits(numOfPadBits, this.buf, start, end, this.allowBER);
        byte[] retval = new byte[len - 1];
        System.arraycopy(this.buf, start, retval, 0, len - 1);
        if (this.allowBER && numOfPadBits != 0) {
            int n2 = retval.length - 1;
            retval[n2] = (byte)(retval[n2] & 255 << numOfPadBits);
        }
        return retval;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }
}

