/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.wallet;

import dm.jdbc.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

class DerIndefLenConverter {
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private int unresolved = 0;
    private ArrayList<Object> ndefsList = new ArrayList();
    private int numOfTotalLenBytes = 0;

    private static boolean isEOC(byte[] data, int pos) {
        return data[pos] == 0 && data[pos + 1] == 0;
    }

    static boolean isLongForm(int lengthByte) {
        return (lengthByte & 0x80) == 128;
    }

    DerIndefLenConverter() {
    }

    static boolean isIndefinite(int lengthByte) {
        return DerIndefLenConverter.isLongForm(lengthByte) && (lengthByte & 0x7F) == 0;
    }

    private void parseTag() throws IOException {
        if (DerIndefLenConverter.isEOC(this.data, this.dataPos)) {
            int numOfEncapsulatedLenBytes = 0;
            Object elem = null;
            int index = this.ndefsList.size() - 1;
            while (index >= 0) {
                elem = this.ndefsList.get(index);
                if (elem instanceof Integer) break;
                numOfEncapsulatedLenBytes += ((byte[])elem).length - 3;
                --index;
            }
            if (index < 0) {
                throw new IOException("EOC does not have matching indefinite-length tag");
            }
            int sectionLen = this.dataPos - (Integer)elem + numOfEncapsulatedLenBytes;
            byte[] sectionLenBytes = this.getLengthBytes(sectionLen);
            this.ndefsList.set(index, sectionLenBytes);
            assert (this.unresolved > 0);
            --this.unresolved;
            this.numOfTotalLenBytes += sectionLenBytes.length - 3;
        }
        ++this.dataPos;
    }

    private void writeTag() {
        while (this.dataPos < this.dataSize) {
            assert (this.dataPos + 1 < this.dataSize);
            if (DerIndefLenConverter.isEOC(this.data, this.dataPos)) {
                this.dataPos += 2;
                continue;
            }
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
            break;
        }
    }

    private int parseLength() throws IOException {
        int lenByte;
        if (this.dataPos == this.dataSize) {
            return 0;
        }
        if (DerIndefLenConverter.isIndefinite(lenByte = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(new Integer(this.dataPos));
            ++this.unresolved;
            return 0;
        }
        int curLen = 0;
        if (DerIndefLenConverter.isLongForm(lenByte)) {
            if ((lenByte &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < lenByte + 1) {
                return -1;
            }
            int i2 = 0;
            while (i2 < lenByte) {
                curLen = (curLen << 8) + (this.data[this.dataPos++] & 0xFF);
                ++i2;
            }
            if (curLen < 0) {
                throw new IOException("Invalid length bytes");
            }
        } else {
            curLen = lenByte & 0x7F;
        }
        return curLen;
    }

    private void writeLengthAndValue() throws IOException {
        int lenByte;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int curLen = 0;
        if (DerIndefLenConverter.isIndefinite(lenByte = this.data[this.dataPos++] & 0xFF)) {
            byte[] lenBytes = (byte[])this.ndefsList.get(this.index++);
            System.arraycopy(lenBytes, 0, this.newData, this.newDataPos, lenBytes.length);
            this.newDataPos += lenBytes.length;
        } else {
            if (DerIndefLenConverter.isLongForm(lenByte)) {
                lenByte &= 0x7F;
                int i2 = 0;
                while (i2 < lenByte) {
                    curLen = (curLen << 8) + (this.data[this.dataPos++] & 0xFF);
                    ++i2;
                }
                if (curLen < 0) {
                    throw new IOException("Invalid length bytes");
                }
            } else {
                curLen = lenByte & 0x7F;
            }
            this.writeLength(curLen);
            this.writeValue(curLen);
        }
    }

    private void writeLength(int curLen) {
        if (curLen < 128) {
            this.newData[this.newDataPos++] = (byte)curLen;
        } else if (curLen < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)curLen;
        } else if (curLen < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(curLen >> 8);
            this.newData[this.newDataPos++] = (byte)curLen;
        } else if (curLen < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(curLen >> 16);
            this.newData[this.newDataPos++] = (byte)(curLen >> 8);
            this.newData[this.newDataPos++] = (byte)curLen;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(curLen >> 24);
            this.newData[this.newDataPos++] = (byte)(curLen >> 16);
            this.newData[this.newDataPos++] = (byte)(curLen >> 8);
            this.newData[this.newDataPos++] = (byte)curLen;
        }
    }

    private byte[] getLengthBytes(int curLen) {
        byte[] lenBytes;
        int index = 0;
        if (curLen < 128) {
            lenBytes = new byte[1];
            lenBytes[index++] = (byte)curLen;
        } else if (curLen < 256) {
            lenBytes = new byte[2];
            lenBytes[index++] = -127;
            lenBytes[index++] = (byte)curLen;
        } else if (curLen < 65536) {
            lenBytes = new byte[3];
            lenBytes[index++] = -126;
            lenBytes[index++] = (byte)(curLen >> 8);
            lenBytes[index++] = (byte)curLen;
        } else if (curLen < 0x1000000) {
            lenBytes = new byte[4];
            lenBytes[index++] = -125;
            lenBytes[index++] = (byte)(curLen >> 16);
            lenBytes[index++] = (byte)(curLen >> 8);
            lenBytes[index++] = (byte)curLen;
        } else {
            lenBytes = new byte[5];
            lenBytes[index++] = -124;
            lenBytes[index++] = (byte)(curLen >> 24);
            lenBytes[index++] = (byte)(curLen >> 16);
            lenBytes[index++] = (byte)(curLen >> 8);
            lenBytes[index++] = (byte)curLen;
        }
        return lenBytes;
    }

    private void writeValue(int curLen) {
        System.arraycopy(this.data, this.dataPos, this.newData, this.newDataPos, curLen);
        this.dataPos += curLen;
        this.newDataPos += curLen;
    }

    byte[] convertBytes(byte[] indefData) throws IOException {
        this.data = indefData;
        this.dataPos = 0;
        this.dataSize = this.data.length;
        while (this.dataPos < this.dataSize) {
            if (this.dataPos + 2 > this.dataSize) {
                return null;
            }
            this.parseTag();
            int len = this.parseLength();
            if (len < 0) {
                return null;
            }
            this.dataPos += len;
            if (this.dataPos < 0) {
                throw new IOException("Data overflow");
            }
            if (this.unresolved != 0) continue;
            assert (!this.ndefsList.isEmpty() && this.ndefsList.get(0) instanceof byte[]);
            break;
        }
        if (this.unresolved != 0) {
            return null;
        }
        int unused = this.dataSize - this.dataPos;
        assert (unused >= 0);
        this.dataSize = this.dataPos;
        this.newData = new byte[this.dataSize + this.numOfTotalLenBytes + unused];
        this.dataPos = 0;
        this.newDataPos = 0;
        this.index = 0;
        while (this.dataPos < this.dataSize) {
            this.writeTag();
            this.writeLengthAndValue();
        }
        System.arraycopy(indefData, this.dataSize, this.newData, this.dataSize + this.numOfTotalLenBytes, unused);
        return this.newData;
    }

    public static byte[] convertStream(InputStream in, byte lenByte, byte tag) throws IOException {
        byte[] result;
        int offset = 2;
        int readLen = in.available();
        byte[] indefData = new byte[readLen + offset];
        indefData[0] = tag;
        indefData[1] = lenByte;
        while (true) {
            DerIndefLenConverter derIn;
            int bytesRead;
            if ((bytesRead = FileUtil.readNBytes(in, indefData, offset, readLen)) != readLen) {
                readLen = bytesRead;
                indefData = Arrays.copyOf(indefData, offset + bytesRead);
            }
            if ((result = (derIn = new DerIndefLenConverter()).convertBytes(indefData)) != null) break;
            int next = in.read();
            if (next == -1) {
                throw new IOException("not enough data to resolve indef len BER");
            }
            int more = in.available();
            indefData = Arrays.copyOf(indefData, offset + readLen + 1 + more);
            indefData[offset + readLen] = (byte)next;
            offset = offset + readLen + 1;
            readLen = more;
        }
        return result;
    }
}

