/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.translate;

import dm.jdbc.util.translate.CharSequenceTranslator;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;

public class LookupTranslator
extends CharSequenceTranslator {
    private final HashMap<String, String> lookupMap = new HashMap();
    private final HashSet<Character> prefixSet = new HashSet();
    private final int shortest;
    private final int longest;

    public LookupTranslator(CharSequence[] ... lookup) {
        int _shortest = Integer.MAX_VALUE;
        int _longest = 0;
        if (lookup != null) {
            CharSequence[][] var4 = lookup;
            int var5 = lookup.length;
            int var6 = 0;
            while (var6 < var5) {
                CharSequence[] seq = var4[var6];
                this.lookupMap.put(seq[0].toString(), seq[1].toString());
                this.prefixSet.add(Character.valueOf(seq[0].charAt(0)));
                int sz = seq[0].length();
                if (sz < _shortest) {
                    _shortest = sz;
                }
                if (sz > _longest) {
                    _longest = sz;
                }
                ++var6;
            }
        }
        this.shortest = _shortest;
        this.longest = _longest;
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        if (this.prefixSet.contains(Character.valueOf(input.charAt(index)))) {
            int max = this.longest;
            if (index + this.longest > input.length()) {
                max = input.length() - index;
            }
            int i2 = max;
            while (i2 >= this.shortest) {
                CharSequence subSeq = input.subSequence(index, index + i2);
                String result = this.lookupMap.get(subSeq.toString());
                if (result != null) {
                    out.write(result);
                    return i2;
                }
                --i2;
            }
        }
        return 0;
    }
}

