/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.flow;

import dm.jdbc.util.flow.EmitterPublisher;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Flow;
import java.util.function.Consumer;

public final class Flows {
    public static <T> Flow.Publisher<T> just(T item) {
        return Flows.from(item);
    }

    public static <T> Flow.Publisher<T> from(T ... items) {
        return Flows.fromArray(items);
    }

    public static <T> Flow.Publisher<Void> toVoid() {
        return Flows.just(null);
    }

    public static <T> Flow.Publisher<T> fromIterable(final Iterable<T> iterable) {
        Consumer consumer = new Consumer<EmitterPublisher.Emitter<T>>(){

            @Override
            public void accept(EmitterPublisher.Emitter<T> tEmitter) {
                try {
                    Iterator iterator = iterable.iterator();
                    while (iterator.hasNext()) {
                        tEmitter.onNext(iterator.next());
                    }
                    tEmitter.onComplete();
                }
                catch (Exception e2) {
                    tEmitter.onError(e2);
                }
            }
        };
        return new EmitterPublisher(consumer);
    }

    public static Flow.Publisher<Long> fromArray(final int[] tArray) {
        Consumer<EmitterPublisher.Emitter<Long>> consumer = new Consumer<EmitterPublisher.Emitter<Long>>(){

            @Override
            public void accept(EmitterPublisher.Emitter<Long> tEmitter) {
                try {
                    int i2 = 0;
                    while (i2 < tArray.length) {
                        tEmitter.onNext(new Long(tArray[i2]));
                        ++i2;
                    }
                    tEmitter.onComplete();
                }
                catch (Exception e2) {
                    tEmitter.onError(e2);
                }
            }
        };
        return new EmitterPublisher<Long>(consumer);
    }

    public static <T> Flow.Publisher<T> fromArray(final T[] tArray) {
        Consumer consumer = new Consumer<EmitterPublisher.Emitter<T>>(){

            @Override
            public void accept(EmitterPublisher.Emitter<T> tEmitter) {
                try {
                    int i2 = 0;
                    while (i2 < tArray.length) {
                        tEmitter.onNext(tArray[i2]);
                        ++i2;
                    }
                    tEmitter.onComplete();
                }
                catch (Exception e2) {
                    tEmitter.onError(e2);
                }
            }
        };
        return new EmitterPublisher(consumer);
    }

    public static <T> Flow.Publisher<T> fromCallable(final Callable<T> callable) {
        Consumer consumer = new Consumer<EmitterPublisher.Emitter<T>>(){

            @Override
            public void accept(EmitterPublisher.Emitter<T> tEmitter) {
                try {
                    callable.call();
                    tEmitter.onComplete();
                }
                catch (Exception e2) {
                    tEmitter.onError(e2);
                }
            }
        };
        return Flows.create(consumer);
    }

    public static <T> Flow.Publisher<Void> fromRunnable(final Runnable runnable) {
        Consumer<EmitterPublisher.Emitter<Void>> consumer = new Consumer<EmitterPublisher.Emitter<Void>>(){

            @Override
            public void accept(EmitterPublisher.Emitter<Void> tEmitter) {
                try {
                    runnable.run();
                    tEmitter.onComplete();
                }
                catch (Exception e2) {
                    tEmitter.onError(e2);
                }
            }
        };
        return Flows.create(consumer);
    }

    public static <T> Flow.Publisher<T> create(Consumer<EmitterPublisher.Emitter<T>> source) {
        return new EmitterPublisher<T>(source);
    }
}

