/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.flow;

import dm.jdbc.util.flow.EmitterPublisher;
import java.util.concurrent.Flow;

public class EmitterImpl<R>
implements EmitterPublisher.Emitter<R> {
    private volatile boolean isCanceled = false;
    private Flow.Subscriber<? super R> subscriber;

    EmitterImpl(Flow.Subscriber<? super R> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        this.subscriber = subscriber;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscriber != null) {
            this.subscriber.onSubscribe(subscription);
        }
    }

    @Override
    public void onNext(R item) {
        if (this.subscriber != null) {
            this.subscriber.onNext(item);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.subscriber != null) {
            this.subscriber.onError(throwable);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscriber != null) {
            this.subscriber.onComplete();
            this.subscriber = null;
        }
    }

    @Override
    public void request(long n2) {
    }

    @Override
    public void cancel() {
        this.isCanceled = true;
        this.subscriber = null;
    }
}

