/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {
    public static final int DATE = 1;
    public static final int DATE_TIME = 2;
    public static final int YYYY_MM_DD_HH_MM_SS = 3;
    public static final int DATE_WITH_MS = 4;
    public static final SimpleDateFormat DATE_MS_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static String formatMilliSecond(int ms, int prec) {
        String ret = null;
        ret = ms < 10 ? "00000000" + ms : (ms < 100 ? "0000000" + ms : (ms < 1000 ? "000000" + ms : (ms < 10000 ? "00000" + ms : (ms < 100000 ? "0000" + ms : (ms < 1000000 ? "000" + ms : (ms < 10000000 ? "00" + ms : (ms < 100000000 ? "0" + ms : Integer.toString(ms))))))));
        if (prec < 9) {
            ret = ret.substring(0, prec);
        }
        return ret;
    }

    public static String formatTZ(int tz) {
        int tz_hour = Math.abs(tz / 60);
        int tz_min = Math.abs(tz % 60);
        if (tz >= 0) {
            return "+" + DateUtil.format2(tz_hour) + ":" + DateUtil.format2(tz_min);
        }
        return "-" + DateUtil.format2(tz_hour) + ":" + DateUtil.format2(tz_min);
    }

    public static String formatYear(int value) {
        if (value >= 0) {
            if (value < 10) {
                return "000" + value;
            }
            if (value < 100) {
                return "00" + value;
            }
            if (value < 1000) {
                return "0" + value;
            }
            return Integer.toString(value);
        }
        if (value > -10) {
            return "-000" + -value;
        }
        if (value > -100) {
            return "-00" + -value;
        }
        if (value > -1000) {
            return "-0" + -value;
        }
        return Integer.toString(value);
    }

    public static String format2(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    public static boolean checkDate(int year, int month, int day) {
        if (year > 9999 || year < -4712 || month > 12 || month < 1) {
            return false;
        }
        int monthDays = DateUtil.getDaysOfMonth(year, month);
        return day <= monthDays && day >= 1;
    }

    public static boolean isLeapYear(int year) {
        if (year <= 1582) {
            return year % 4 == 0;
        }
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getDaysOfMonth(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return DateUtil.isLeapYear(year) ? 29 : 28;
            }
        }
        return 0;
    }

    public static String formatDate(Date date, int style) {
        String value = null;
        int year = date.getYear();
        int month = date.getMonth();
        String day = DateUtil.getStrFromInt(date.getDate());
        String hour = DateUtil.getStrFromInt(date.getHours());
        String minute = DateUtil.getStrFromInt(date.getMinutes());
        String second = DateUtil.getStrFromInt(date.getSeconds());
        switch (style) {
            case 1: {
                value = year + 1900 + "-" + DateUtil.getStrFromInt(month + 1) + "-" + day;
                break;
            }
            case 2: {
                value = year + 1900 + "-" + DateUtil.getStrFromInt(month + 1) + "-" + day + " " + hour + ":" + minute + ":" + second;
                break;
            }
            case 3: {
                value = year + 1900 + "_" + DateUtil.getStrFromInt(month + 1) + "_" + day + "_" + hour + "_" + minute + "_" + second;
                break;
            }
            case 4: {
                value = DATE_MS_FORMAT.format(date);
                break;
            }
            default: {
                value = date.toString();
            }
        }
        return value;
    }

    private static String getStrFromInt(int i2) {
        return i2 < 10 ? "0" + i2 : String.valueOf(i2);
    }

    public static void main(String[] args) throws Exception {
    }
}

