/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class Base64Decoder {
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];
    byte[] decode_buffer = new byte[4];

    static {
        int i2 = 0;
        while (i2 < 255) {
            Base64Decoder.pem_convert_array[i2] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < pem_array.length) {
            Base64Decoder.pem_convert_array[Base64Decoder.pem_array[i2]] = (byte)i2;
            ++i2;
        }
    }

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        return 72;
    }

    protected void decodeAtom(PushbackInputStream inStream, OutputStream outStream, int rem) throws IOException {
        int i2;
        int a2 = -1;
        int b2 = -1;
        int c2 = -1;
        int d2 = -1;
        if (rem < 2) {
            throw new IOException("BASE64Decoder: Not enough bytes for an atom.");
        }
        do {
            if ((i2 = inStream.read()) != -1) continue;
            throw new IOException("CEStreamExhausted");
        } while (i2 == 10 || i2 == 13);
        this.decode_buffer[0] = (byte)i2;
        i2 = this.readFully(inStream, this.decode_buffer, 1, rem - 1);
        if (i2 == -1) {
            throw new IOException("CEStreamExhausted");
        }
        if (rem > 3 && this.decode_buffer[3] == 61) {
            rem = 3;
        }
        if (rem > 2 && this.decode_buffer[2] == 61) {
            rem = 2;
        }
        switch (rem) {
            case 4: {
                d2 = pem_convert_array[this.decode_buffer[3] & 0xFF];
            }
            case 3: {
                c2 = pem_convert_array[this.decode_buffer[2] & 0xFF];
            }
            case 2: {
                b2 = pem_convert_array[this.decode_buffer[1] & 0xFF];
                a2 = pem_convert_array[this.decode_buffer[0] & 0xFF];
            }
        }
        int i1 = a2 << 2 & 0xFC | b2 >>> 4 & 3;
        int i22 = b2 << 4 & 0xF0 | c2 >>> 2 & 0xF;
        switch (rem) {
            case 2: {
                outStream.write((byte)i1);
                break;
            }
            case 3: {
                outStream.write((byte)i1);
                outStream.write((byte)i22);
                break;
            }
            case 4: {
                outStream.write((byte)i1);
                outStream.write((byte)i22);
                outStream.write((byte)(c2 << 6 & 0xC0 | d2 & 0x3F));
            }
        }
    }

    private int readFully(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        int i2 = 0;
        while (i2 < len) {
            int q2 = in.read();
            if (q2 == -1) {
                return i2 == 0 ? -1 : i2;
            }
            buffer[i2 + offset] = (byte)q2;
            ++i2;
        }
        return len;
    }

    public byte[] decodeBuffer(String inputString) throws IOException {
        byte[] inputBuffer = new byte[inputString.length()];
        inputString.getBytes(0, inputString.length(), inputBuffer, 0);
        ByteArrayInputStream inStream = new ByteArrayInputStream(inputBuffer);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.decodeBuffer(inStream, outStream);
        return outStream.toByteArray();
    }

    public void decodeBuffer(InputStream aStream, OutputStream bStream) throws IOException {
        PushbackInputStream ps = new PushbackInputStream(aStream);
        this.decodeBufferPrefix(ps, bStream);
        try {
            while (true) {
                int length = this.decodeLinePrefix(ps, bStream);
                int i2 = 0;
                while (i2 + this.bytesPerAtom() < length) {
                    this.decodeAtom(ps, bStream, this.bytesPerAtom());
                    i2 += this.bytesPerAtom();
                }
                if (i2 + this.bytesPerAtom() == length) {
                    this.decodeAtom(ps, bStream, this.bytesPerAtom());
                } else {
                    this.decodeAtom(ps, bStream, length - i2);
                }
                this.decodeLineSuffix(ps, bStream);
            }
        }
        catch (IOException iOException) {
            this.decodeBufferSuffix(ps, bStream);
            return;
        }
    }

    protected void decodeBufferPrefix(PushbackInputStream aStream, OutputStream bStream) throws IOException {
    }

    protected void decodeBufferSuffix(PushbackInputStream aStream, OutputStream bStream) throws IOException {
    }

    protected int decodeLinePrefix(PushbackInputStream aStream, OutputStream bStream) throws IOException {
        return this.bytesPerLine();
    }

    protected void decodeLineSuffix(PushbackInputStream aStream, OutputStream bStream) throws IOException {
    }
}

