/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.a.a.p;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.plugin.fldr.ColumnInfo;
import dm.jdbc.plugin.fldr.FldrClusterInfo;
import dm.jdbc.plugin.fldr.FldrHashCode;
import dm.jdbc.plugin.fldr.FldrIndexInfo;
import dm.jdbc.plugin.fldr.FldrStatement;
import dm.jdbc.plugin.fldr.HorizontalTableInfo;
import dm.jdbc.plugin.fldr.IntervalColumnInfo;
import dm.jdbc.util.StringUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class TableInfo {
    private String schemaName;
    private String tableName;
    public boolean dpcFlag = false;
    public byte hugeType = 0;
    public byte hashPartMap = 0;
    private List<ColumnInfo> columnInfos;
    private Map<String, Short> nameIdMap;
    private HorizontalTableInfo hTableHead;
    public HashMap<String, Integer> subTableNameIdMap;
    public HashMap<String, List<Object[]>> hTableNameData = new HashMap();
    public Map<Integer, HorizontalTableInfo> hTableNodeMap = Collections.emptyMap();
    public int autoIncrementColId;
    public long seed;
    public long currentValue;
    public long increment;
    public boolean containLob = false;
    public boolean containDecimal = false;
    public boolean containChar = false;
    private int dBTimeZone = 1000;
    private int localTimeZone = 480;
    private DmdbConnection conn = null;
    public static int msgVersion = 0;
    public List<FldrIndexInfo> indexInfos = Collections.emptyList();
    public IntervalColumnInfo intervalColumnInfo = null;
    public byte lanMode = 0;
    public static final int HUGE_LIST_MAIN_TABLE = 38;
    public static final int NORMAL_LIST_MAIN_TABLE = 11;
    public static final int HUGE_RANGE_MAIN_TABLE = 34;
    public static final int NORMAL_RANGE_MAIN_TABLE = 6;
    public static final int HUGE_HASH_MAIN_TABLE = 36;
    public static final int NORMAL_HASH_MAIN_TABLE = 8;
    public Map<Integer, int[]> columnIdScale;

    public TableInfo() {
    }

    public TableInfo(List<ColumnInfo> columnInfos, Map<String, Short> nameIdMap, HorizontalTableInfo hTableHead, boolean containLob) {
        this.columnInfos = columnInfos;
        this.nameIdMap = nameIdMap;
        this.hTableHead = hTableHead;
        this.containLob = containLob;
    }

    public void setColumnIdScale(Map<Integer, int[]> columnIdScale) {
        this.columnIdScale = columnIdScale;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public Map<String, Short> getNameIdMap() {
        return this.nameIdMap;
    }

    public void setNameIdMap(Map<String, Short> nameIdMap) {
        this.nameIdMap = nameIdMap;
    }

    public HorizontalTableInfo gethTableHead() {
        return this.hTableHead;
    }

    public void sethTableHead(HorizontalTableInfo hTableHead) {
        this.hTableHead = hTableHead;
    }

    public Short getColumnIdByName(String columnName) throws SQLException {
        Short columnId;
        if (columnName == null || columnName.isEmpty()) {
            DBError.ECJDBC_COLNAMES_NULL.throwz(new Object[0]);
        }
        columnName = columnName.toUpperCase();
        if (this.nameIdMap == null || this.nameIdMap.isEmpty()) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwz(new Object[0]);
        }
        if ((columnId = this.nameIdMap.get(columnName)) == null) {
            DBError.ECJDBC_COLINDEXES_NULL.throwz(new Object[0]);
        }
        return columnId;
    }

    public int getDBTimeZone() {
        return this.dBTimeZone;
    }

    public void setDBTimeZone(int timeZone) {
        this.dBTimeZone = timeZone;
    }

    public int getLocalTimeZone() {
        return this.localTimeZone;
    }

    public void setLocalTimeZone(int localTimeZone) {
        this.localTimeZone = localTimeZone;
    }

    public DmdbConnection getConn() {
        return this.conn;
    }

    public void setConn(DmdbConnection conn) {
        this.conn = conn;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Object[]>> getHTabPartition(Object[] singleRow, FldrClusterInfo clusterInfo) throws SQLException {
        if (this.hTableHead == null) {
            return this.hTableNameData;
        }
        if (this.intervalColumnInfo != null) {
            TableInfo tableInfo = this;
            synchronized (tableInfo) {
                this.hTabHelper(this.hTableHead, this.hTableNameData, singleRow, null, clusterInfo);
            }
        } else {
            this.hTabHelper(this.hTableHead, this.hTableNameData, singleRow, null, clusterInfo);
        }
        return this.hTableNameData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Object[]>> getAsyncHTabPartition(Object[][] rows, Calendar cal, FldrClusterInfo clusterInfo) throws SQLException {
        HorizontalTableInfo head = this.hTableHead;
        HashMap<String, List<Object[]>> map = new HashMap<String, List<Object[]>>();
        try {
            if (head == null) {
                ArrayList list = new ArrayList(rows.length);
                Collections.addAll(list, rows);
                map.put(this.tableName, list);
                return map;
            }
            if (this.intervalColumnInfo != null) {
                TableInfo list = this;
                synchronized (list) {
                    Object[][] objectArray = rows;
                    int n2 = rows.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Object[] singleRow = objectArray[n3];
                        this.hTabHelper(head, map, singleRow, cal, clusterInfo);
                        ++n3;
                    }
                }
            } else {
                Object[][] objectArray = rows;
                int n4 = rows.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object[] singleRow = objectArray[n5];
                    this.hTabHelper(head, map, singleRow, cal, clusterInfo);
                    ++n5;
                }
            }
            return map;
        }
        catch (Exception e2) {
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_FLDR_PARTITION_ERROR.throwz(new Object[0]);
            return map;
        }
    }

    private int hTabHelper(HorizontalTableInfo head, HashMap<String, List<Object[]>> map, Object[] singleRow, Calendar cal, FldrClusterInfo clusterInfo) throws SQLException {
        if (head == null) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz(new Object[0]);
        }
        int raftId = -1;
        if (head.getParent() == null && this.intervalColumnInfo != null) {
            head = this.processIntervalColumn(head, singleRow[head.getPartitionColIds()[0]], this.columnIdScale, cal, clusterInfo);
        }
        while (head.getChildren() != null && !head.getChildren().isEmpty()) {
            short[] partitionColIds = head.getPartitionColIds();
            short[] sqlTypes = head.getSqlType();
            int index = -1;
            int maxIndex = Integer.MIN_VALUE;
            int hashSize = 0;
            if (TableInfo.isHashPartition(head.getTableType())) {
                hashSize = FldrHashCode.tableSizeFor(head.getSubTableIds().size());
            }
            int i2 = 0;
            while (i2 < sqlTypes.length) {
                short sqlType = sqlTypes[i2];
                if (TableInfo.isHashPartition(head.getTableType())) {
                    long hashValue = FldrHashCode.hc_get_fold_fun(sqlType, hashSize, singleRow[partitionColIds[i2]], this.conn, cal);
                    index = FldrHashCode.compareNumHash(hashSize, head.getSubTableIds().size(), hashValue, this.dpcFlag, this.hashPartMap);
                } else if (TableInfo.isListPartition(head.getTableType()) || TableInfo.isRangePartition(head.getTableType())) {
                    switch (sqlType) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            index = this.compareNum(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 10: {
                            Float o2 = singleRow[partitionColIds[i2]] == null ? null : Float.valueOf(Float.parseFloat(singleRow[partitionColIds[i2]].toString()));
                            index = this.compareNum(head, i2, o2);
                            break;
                        }
                        case 11: {
                            Float o2 = singleRow[partitionColIds[i2]] == null ? (Number)null : (Number)Double.parseDouble(singleRow[partitionColIds[i2]].toString());
                            index = this.compareNum(head, i2, o2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 12: 
                        case 17: 
                        case 18: 
                        case 19: {
                            index = this.compareVarchar(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 0: {
                            index = this.compareChar(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 9: {
                            index = this.compareDecimal(head, i2, partitionColIds[i2], singleRow[partitionColIds[i2]], this.columnIdScale);
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 22: 
                        case 23: 
                        case 26: 
                        case 27: {
                            index = this.compareDate(false, head, i2, singleRow[partitionColIds[i2]], sqlType, cal);
                            break;
                        }
                        default: {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(String.format("\u8be5\u7c7b\u578b%s\u4e0d\u652f\u6301\u5206\u533a\u6bd4\u8f83", sqlType));
                            break;
                        }
                    }
                } else {
                    DBError.throwRuntimeException("unknown type of sub_partition");
                }
                maxIndex = Math.max(index, maxIndex);
                ++i2;
            }
            if (maxIndex < 0) continue;
            head = head.getChildren().get(maxIndex);
        }
        List<Object[]> data = map.get(head.getTableName());
        if (data == null) {
            data = new ArrayList<Object[]>();
            data.add(singleRow);
            map.put(head.getTableName(), data);
        } else {
            data.add(singleRow);
        }
        return raftId;
    }

    private HorizontalTableInfo processIntervalColumn(HorizontalTableInfo head, Object value, Map<Integer, int[]> columnIdScale, Calendar cal, FldrClusterInfo clusterInfo) throws SQLException {
        if (value == null) {
            if (TableInfo.isListPartition(head.getTableType())) {
                return head.getChildren().get(head.getDefaultPartition());
            }
            if (TableInfo.isRangePartition(head.getTableType())) {
                return head.getChildren().get(0);
            }
            DBError.throwRuntimeException("not list or range partition table");
        }
        switch (this.intervalColumnInfo.sqlType) {
            case 20: 
            case 21: {
                return this.compareIntervalTime(head, value, cal, clusterInfo);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.compareIntervalInt(head, value, clusterInfo);
            }
            case 8: {
                return this.compareIntervalLong(head, value, clusterInfo);
            }
            case 11: {
                return this.compareIntervalDouble(head, value, clusterInfo);
            }
            case 10: {
                return this.compareIntervalFloat(head, value, clusterInfo);
            }
            case 9: {
                return this.compareIntervalDec(head, value, columnIdScale, clusterInfo);
            }
        }
        DBError.ECJDBC_INVALID_COLUMN_TYPE.throwz(new Object[0]);
        return null;
    }

    public void clearData() {
        this.hTableNameData = new HashMap();
        this.columnIdScale = null;
    }

    private HorizontalTableInfo compareIntervalTime(HorizontalTableInfo node, Object value, Calendar cal, FldrClusterInfo clusterInfo) throws SQLException {
        long intervalTime;
        long compareVal;
        int index = 0;
        if (value == null) {
            return node.getChildren().get(index);
        }
        Object[] targets = node.getBoundaries().get(index);
        long[] bdrValues = new long[targets.length];
        int i2 = 0;
        while (i2 < targets.length) {
            bdrValues[i2] = ((Number)targets[i2]).longValue();
            ++i2;
        }
        if (node.getSqlType()[index] == 15) {
            compareVal = value instanceof String ? this.timeHelper(DmdbTimestamp.valueOf(value.toString()).toDate()) : this.timeHelper((Date)value);
        } else {
            Calendar instance = cal == null ? Calendar.getInstance() : cal;
            DmdbTimestamp timestamp = null;
            if (value instanceof Date) {
                instance.setTime((Date)value);
            } else {
                timestamp = DmdbTimestamp.valueOf(TableInfo.parseTimeTZ(value.toString()));
                instance.setTime(timestamp.toDate());
            }
            int msc = value instanceof Timestamp ? ((Timestamp)value).getNanos() / 1000 : (value instanceof String ? timestamp.toTimestamp().getNanos() / 1000 : instance.get(14));
            compareVal = p.a(instance.get(1), instance.get(2) + 1, instance.get(5), instance.get(11), instance.get(12), instance.get(13), msc);
        }
        List<Integer> includeFlag = node.getIncludeFlag();
        if (21 == this.intervalColumnInfo.sqlType) {
            DmdbIntervalDT intervalDT = (DmdbIntervalDT)this.intervalColumnInfo.intervalValue;
            intervalTime = p.a(0, 0, intervalDT.days, intervalDT.hours, intervalDT.minutes, intervalDT.seconds, intervalDT.fraction);
        } else {
            DmdbIntervalYM intervalYm = (DmdbIntervalYM)this.intervalColumnInfo.intervalValue;
            intervalTime = p.a(intervalYm.years, intervalYm.months, 0, 0, 0, 0, 0);
        }
        if (compareVal < bdrValues[this.intervalColumnInfo.firstIndex]) {
            return node.getChildren().get(this.compareDate(false, node, index, value, node.getSqlType()[index], cal));
        }
        if (compareVal == bdrValues[this.intervalColumnInfo.firstIndex] && includeFlag.get(this.intervalColumnInfo.firstIndex) == 1) {
            return node.getChildren().get(this.intervalColumnInfo.firstIndex);
        }
        compareVal = this.findNewBoundaryTime(compareVal, bdrValues[this.intervalColumnInfo.firstIndex], intervalTime);
        int bdrIndex = -1;
        try {
            bdrIndex = Arrays.binarySearch(targets, (Object)compareVal);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (bdrIndex >= 0) {
            return node.getChildren().get(bdrIndex);
        }
        bdrIndex = -1 - bdrIndex;
        return this.conn.dbAccess.a(index, bdrIndex, node.getTableId(), this.lanMode, value, compareVal, this, cal, clusterInfo);
    }

    private long findNewBoundaryTime(long compareVal, long defaultVal, long intervalTime) {
        while (compareVal >= defaultVal) {
            defaultVal += intervalTime;
        }
        return defaultVal;
    }

    private HorizontalTableInfo compareIntervalDec(HorizontalTableInfo node, Object value, Map<Integer, int[]> columnIdScale, FldrClusterInfo clusterInfo) throws SQLException {
        Object[] boundaries;
        BigDecimal startPartition;
        int[] preScale;
        BigDecimal targetValue;
        int index = 0;
        List<Integer> includeFlag = node.getIncludeFlag();
        BigDecimal intervalValue = (BigDecimal)this.intervalColumnInfo.intervalValue;
        BigDecimal bigDecimal = targetValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        if (columnIdScale != null && !columnIdScale.isEmpty() && (preScale = columnIdScale.get(index)) != null) {
            targetValue = FldrStatement.roundHalfUp(targetValue, preScale[0], preScale[1]);
        }
        if (targetValue.compareTo(startPartition = (BigDecimal)(boundaries = node.getBoundaries().get(index))[this.intervalColumnInfo.firstIndex]) < 0) {
            return node.getChildren().get(this.compareDecimal(node, index, node.getPartitionColIds()[0], value, columnIdScale));
        }
        if (targetValue.compareTo(startPartition) == 0 && includeFlag.get(this.intervalColumnInfo.firstIndex) == 1) {
            return node.getChildren().get(this.intervalColumnInfo.firstIndex);
        }
        BigDecimal newBoundary = startPartition;
        while (newBoundary.compareTo(targetValue) <= 0) {
            newBoundary = newBoundary.add(intervalValue);
        }
        int bdrIndex = Arrays.binarySearch(boundaries, newBoundary);
        if (bdrIndex >= 0) {
            return node.getChildren().get(bdrIndex);
        }
        if ((bdrIndex = -1 - bdrIndex) < boundaries.length) {
            BigDecimal boundary = (BigDecimal)boundaries[bdrIndex];
            if (targetValue.compareTo(boundary) < 0) {
                BigDecimal diff = boundary.subtract(targetValue);
                if (diff.compareTo(intervalValue) < 0) {
                    return node.getChildren().get(bdrIndex);
                }
            } else if (targetValue.compareTo(boundary) == 0) {
                newBoundary = includeFlag.get(this.intervalColumnInfo.firstIndex) == 1 ? newBoundary : newBoundary.add(intervalValue);
            }
        }
        return this.findIntervalNode(node, index, newBoundary, value, null, clusterInfo);
    }

    private HorizontalTableInfo compareIntervalDouble(HorizontalTableInfo node, Object value, FldrClusterInfo clusterInfo) throws SQLException {
        Object[] boundaries;
        double startPartition;
        int index = 0;
        List<Integer> includeFlag = node.getIncludeFlag();
        double intervalValue = ((Number)this.intervalColumnInfo.intervalValue).doubleValue();
        double targetValue = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
        if (targetValue < (startPartition = ((Number)(boundaries = node.getBoundaries().get(index))[this.intervalColumnInfo.firstIndex]).doubleValue())) {
            return node.getChildren().get(this.compareNum(node, index, value));
        }
        if (targetValue == startPartition && includeFlag.get(this.intervalColumnInfo.firstIndex) == 1) {
            return node.getChildren().get(this.intervalColumnInfo.firstIndex);
        }
        double newBoundary = startPartition;
        while (newBoundary <= targetValue) {
            newBoundary += intervalValue;
        }
        int bdrIndex = Arrays.binarySearch(boundaries, (Object)newBoundary);
        if (bdrIndex >= 0) {
            return node.getChildren().get(bdrIndex);
        }
        if ((bdrIndex = -1 - bdrIndex) < boundaries.length) {
            double boundary = ((Number)boundaries[bdrIndex]).doubleValue();
            if (targetValue < boundary) {
                double diff = boundary - targetValue;
                if (diff < intervalValue) {
                    return node.getChildren().get(bdrIndex);
                }
            } else {
                newBoundary = targetValue == boundary ? (includeFlag.get(this.intervalColumnInfo.firstIndex) == 1 ? newBoundary : newBoundary + intervalValue) : (newBoundary += intervalValue);
            }
        }
        return this.findIntervalNode(node, index, newBoundary, value, null, clusterInfo);
    }

    private HorizontalTableInfo compareIntervalFloat(HorizontalTableInfo node, Object value, FldrClusterInfo clusterInfo) throws SQLException {
        Object[] boundaries;
        float startPartition;
        int index = 0;
        List<Integer> includeFlag = node.getIncludeFlag();
        float intervalValue = ((Number)this.intervalColumnInfo.intervalValue).floatValue();
        float targetValue = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
        if (targetValue < (startPartition = ((Number)(boundaries = node.getBoundaries().get(index))[this.intervalColumnInfo.firstIndex]).floatValue())) {
            return node.getChildren().get(this.compareNum(node, index, value));
        }
        if (targetValue == startPartition && includeFlag.get(this.intervalColumnInfo.firstIndex) == 1) {
            return node.getChildren().get(this.intervalColumnInfo.firstIndex);
        }
        float newBoundary = startPartition;
        while (newBoundary <= targetValue) {
            newBoundary += intervalValue;
        }
        int bdrIndex = Arrays.binarySearch(boundaries, Float.valueOf(newBoundary));
        if (bdrIndex >= 0) {
            return node.getChildren().get(bdrIndex);
        }
        if ((bdrIndex = -1 - bdrIndex) < boundaries.length) {
            float boundary = ((Number)boundaries[bdrIndex]).floatValue();
            if (targetValue < boundary) {
                double diff = boundary - targetValue;
                if (diff < (double)intervalValue) {
                    return node.getChildren().get(bdrIndex);
                }
            } else {
                newBoundary = targetValue == boundary ? (includeFlag.get(this.intervalColumnInfo.firstIndex) == 1 ? newBoundary : newBoundary + intervalValue) : (newBoundary += intervalValue);
            }
        }
        return this.findIntervalNode(node, index, Float.valueOf(newBoundary), value, null, clusterInfo);
    }

    private HorizontalTableInfo compareIntervalLong(HorizontalTableInfo node, Object value, FldrClusterInfo clusterInfo) throws SQLException {
        Object[] boundaries;
        long startPartition;
        int index = 0;
        List<Integer> includeFlag = node.getIncludeFlag();
        long intervalValue = ((Number)this.intervalColumnInfo.intervalValue).longValue();
        long targetValue = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
        if (targetValue < (startPartition = ((Number)(boundaries = node.getBoundaries().get(index))[this.intervalColumnInfo.firstIndex]).longValue())) {
            return node.getChildren().get(this.compareNum(node, index, value));
        }
        if (targetValue == startPartition && includeFlag.get(this.intervalColumnInfo.firstIndex) == 1) {
            return node.getChildren().get(this.intervalColumnInfo.firstIndex);
        }
        long newBoundary = startPartition;
        while (newBoundary <= targetValue) {
            newBoundary += intervalValue;
        }
        int bdrIndex = Arrays.binarySearch(boundaries, (Object)newBoundary);
        if (bdrIndex >= 0) {
            return node.getChildren().get(bdrIndex);
        }
        return this.findIntervalNode(node, index, newBoundary, value, null, clusterInfo);
    }

    private HorizontalTableInfo compareIntervalInt(HorizontalTableInfo node, Object value, FldrClusterInfo clusterInfo) throws SQLException {
        Object[] boundaries;
        int startPartition;
        int index = 0;
        List<Integer> includeFlag = node.getIncludeFlag();
        int intervalValue = ((Number)this.intervalColumnInfo.intervalValue).intValue();
        int targetValue = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
        if (targetValue < (startPartition = ((Number)(boundaries = node.getBoundaries().get(index))[this.intervalColumnInfo.firstIndex]).intValue())) {
            return node.getChildren().get(this.compareNum(node, index, value));
        }
        if (targetValue == startPartition && includeFlag.get(this.intervalColumnInfo.firstIndex) == 1) {
            return node.getChildren().get(this.intervalColumnInfo.firstIndex);
        }
        int newBoundary = startPartition;
        while (newBoundary <= targetValue) {
            newBoundary += intervalValue;
        }
        int bdrIndex = Arrays.binarySearch(boundaries, (Object)newBoundary);
        if (bdrIndex >= 0) {
            return node.getChildren().get(bdrIndex);
        }
        return this.findIntervalNode(node, index, newBoundary, value, null, clusterInfo);
    }

    private HorizontalTableInfo findIntervalNode(HorizontalTableInfo node, int index, Object newBoundary, Object value, Calendar cal, FldrClusterInfo clusterInfo) throws SQLException {
        Object[] targets = node.getBoundaries().get(index);
        int result = -1;
        try {
            result = Arrays.binarySearch(targets, newBoundary);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            result = -1 - result;
            return this.conn.dbAccess.a(index, result, node.getTableId(), this.lanMode, value, newBoundary, this, cal, clusterInfo);
        }
        return node.getChildren().get(result);
    }

    private int compareNum(HorizontalTableInfo node, int index, Object value) throws SQLException {
        if (value == null) {
            if (TableInfo.isListPartition(node.getTableType())) {
                return node.getDefaultPartition();
            }
            if (TableInfo.isRangePartition(node.getTableType())) {
                return 0;
            }
            DBError.throwRuntimeException("unknown sub_partition type");
        }
        Object[] targets = node.getBoundaries().get(index);
        List<Integer> includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            if (value instanceof Byte) {
                byte val = (Byte)value;
                result = Arrays.binarySearch(targets, (Object)val);
            } else if (value instanceof Short) {
                short val = (Short)value;
                result = Arrays.binarySearch(targets, (Object)val);
            } else {
                if (targets[0] instanceof Long && value instanceof Integer) {
                    value = (long)((Integer)value).intValue();
                }
                result = Arrays.binarySearch(targets, value);
            }
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            if (TableInfo.isListPartition(node.getTableType())) {
                return node.getDefaultPartition();
            }
            result = -1 - result;
        }
        if (value.equals(targets[result]) && includeFlag.get(result) == 0 && ++result >= targets.length) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return result;
    }

    private int compareChar(HorizontalTableInfo node, int index, Object value) throws SQLException {
        try {
            String str = StringUtil.rightTrim(value.toString());
            return this.compareVarchar(node, index, str);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            return -1;
        }
    }

    private int compareVarchar(HorizontalTableInfo node, int index, Object value) throws SQLException {
        try {
            if (value == null) {
                value = "";
            }
            Object[] targets = node.getBoundaries().get(index);
            List<Integer> includeFlag = node.getIncludeFlag();
            int result = -1;
            String res = (String)value;
            if (TableInfo.isListPartition(node.getTableType())) {
                int i2 = 0;
                while (i2 < targets.length) {
                    String str = (String)targets[i2];
                    if (str.isEmpty() || res.compareTo(str) == 0) {
                        result = i2;
                        break;
                    }
                    ++i2;
                }
                if (result == -1) {
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
                }
            } else if (TableInfo.isRangePartition(node.getTableType())) {
                int i3 = 0;
                while (i3 < targets.length) {
                    String str = (String)targets[i3];
                    if (str.isEmpty() || res.compareTo(str) <= 0) {
                        result = i3;
                        break;
                    }
                    ++i3;
                }
                if (value.equals(targets[result]) && includeFlag.get(result) == 0 && ++result >= targets.length) {
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
                }
            } else {
                DBError.throwRuntimeException("not list or range partition table");
            }
            return result;
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            return -1;
        }
    }

    private int compareDecimal(HorizontalTableInfo node, int index, int columnId, Object value, Map<Integer, int[]> columnIdScale) throws SQLException {
        BigDecimal dec2;
        BigDecimal dec1;
        if (value == null) {
            if (TableInfo.isListPartition(node.getTableType())) {
                return node.getDefaultPartition();
            }
            if (TableInfo.isRangePartition(node.getTableType())) {
                return 0;
            }
            DBError.throwRuntimeException("not list or range partition table");
        }
        if (columnIdScale != null && !columnIdScale.isEmpty()) {
            int[] preScale;
            if (!(value instanceof BigDecimal)) {
                value = new BigDecimal(value.toString());
            }
            if ((preScale = columnIdScale.get(columnId)) == null || preScale.length < 2) {
                DBError.ECJDBC_ROW_SET_COL_KEY_INVALID.throwz(new Object[0]);
            }
            value = FldrStatement.roundHalfUp((BigDecimal)value, preScale[0], preScale[1]);
        }
        Object[] targets = node.getBoundaries().get(index);
        List<Integer> includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            if (!(value instanceof BigDecimal)) {
                value = new BigDecimal(value.toString());
            }
            result = Arrays.binarySearch(targets, value);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            if (TableInfo.isListPartition(node.getTableType())) {
                return node.getDefaultPartition();
            }
            result = -1 - result;
        }
        if ((dec1 = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString())).compareTo(dec2 = (BigDecimal)targets[result]) == 0 && includeFlag.get(result) == 0 && ++result >= targets.length) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return result;
    }

    private int compareDate(boolean intervalFlag, HorizontalTableInfo node, int index, Object value, int sqlType, Calendar cal) throws SQLException {
        long compareVal;
        if (value == null) {
            if (TableInfo.isListPartition(node.getTableType())) {
                return node.getDefaultPartition();
            }
            if (TableInfo.isRangePartition(node.getTableType())) {
                return 0;
            }
            DBError.throwRuntimeException("not list or range partition table");
        }
        Object[] targets = node.getBoundaries().get(index);
        long[] vals = new long[targets.length];
        int i2 = 0;
        while (i2 < targets.length) {
            vals[i2] = ((Number)targets[i2]).longValue();
            ++i2;
        }
        if (sqlType == 15) {
            compareVal = value instanceof String ? this.timeHelper(DmdbTimestamp.valueOf(value.toString()).toDate()) : this.timeHelper((Date)value);
        } else if (sqlType == 22) {
            compareVal = value instanceof String ? this.timeHelper(TableInfo.parseTimeTZ(value.toString())) : this.timeHelper((Date)value);
        } else {
            Calendar instance = cal == null ? Calendar.getInstance() : cal;
            DmdbTimestamp timestamp = null;
            if (value instanceof String) {
                timestamp = DmdbTimestamp.valueOf(TableInfo.parseTimeTZ(value.toString()));
                instance.setTime(timestamp.toDate());
            } else {
                instance.setTime((Date)value);
            }
            int msc = value instanceof Timestamp ? ((Timestamp)value).getNanos() / 1000 : (value instanceof String ? timestamp.toTimestamp().getNanos() / 1000 : instance.get(14));
            compareVal = p.a(instance.get(1), instance.get(2) + 1, instance.get(5), instance.get(11), instance.get(12), instance.get(13), msc);
        }
        List<Integer> includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            result = Arrays.binarySearch(vals, compareVal);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            if (intervalFlag) {
                return result;
            }
            if (TableInfo.isListPartition(node.getTableType())) {
                return node.getDefaultPartition();
            }
            result = -1 - result;
        }
        if (compareVal == vals[result] && includeFlag.get(result) == 0 && ++result >= targets.length) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return result;
    }

    private long timeHelper(Date date) {
        Calendar instance = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"));
        instance.setTime(date);
        return (long)instance.get(11) * 3600000L + (long)instance.get(12) * 60000L + (long)instance.get(13) * 1000L + (long)instance.get(14);
    }

    private static Date parseTimeTZ(String dateStr) throws SQLException {
        String timeZone = null;
        int offset = dateStr.indexOf(" +");
        if (offset > 0 || (offset = dateStr.indexOf(" -")) > 0) {
            timeZone = dateStr.substring(Math.min(offset + 1, dateStr.length()), Math.min(offset + 2, dateStr.length()));
            dateStr = dateStr.substring(0, offset);
        }
        try {
            SimpleDateFormat inputFormat = dateStr.contains(" ") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("HH:mm:ss");
            inputFormat.setTimeZone(TimeZone.getTimeZone("GMT" + timeZone));
            return inputFormat.parse(dateStr);
        }
        catch (ParseException e2) {
            DBError.throwRuntimeException(e2.toString());
            return null;
        }
    }

    public static boolean isHashPartition(int tableType) {
        return 36 == tableType || 8 == tableType;
    }

    public static boolean isRangePartition(int tableType) {
        return 34 == tableType || 6 == tableType;
    }

    public static boolean isListPartition(int tableType) {
        return 38 == tableType || 11 == tableType;
    }
}

