/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.driver.DBError;
import dm.jdbc.plugin.fldr.SequenceNumInfo;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;

public class SetEnvInfo
implements Cloneable {
    private int setIdentity = 0;
    private int sorted = 1;
    private int bdtaSize = 5000;
    private int indexOption = 1;
    private int noMpp = 1;
    private int charset;
    private int lobFromMsg = 0;
    private int ignoreConflict = 0;
    private short setId;
    private short bldrNumber = (short)64;
    private String schemaName;
    private String tableName;
    private byte flushFlag = 0;
    private byte parallelFlag = 0;
    private int msgVersion = 0;
    private List<SequenceNumInfo> sequenceNumInfos;

    public SetEnvInfo() {
    }

    public SetEnvInfo(int setIdentity, int sorted, int bdtaSize, int indexOption, int noMpp, int charset, int lobFromMsg, int ignoreConflict, short setId, short bldrNumber, String schemaName, String tableName, byte flushFlag, byte parallelFlag) {
        this.setIdentity = setIdentity;
        this.sorted = sorted;
        this.bdtaSize = bdtaSize;
        this.indexOption = indexOption;
        this.noMpp = noMpp;
        this.charset = charset;
        this.lobFromMsg = lobFromMsg;
        this.ignoreConflict = ignoreConflict;
        this.setId = setId;
        this.bldrNumber = bldrNumber;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.flushFlag = flushFlag;
        this.parallelFlag = parallelFlag;
    }

    public int getSetIdentity() {
        return this.setIdentity;
    }

    public void setSetIdentity(int setIdentity) {
        this.setIdentity = setIdentity;
    }

    public int getSorted() {
        return this.sorted;
    }

    public void setSorted(int sorted) {
        this.sorted = sorted;
    }

    public int getBdtaSize() {
        return this.bdtaSize;
    }

    public void setBdtaSize(int bdtaSize) throws SQLException {
        if (bdtaSize > 10000 || bdtaSize < 100) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("maxRows range is [100, 10000]");
        }
        this.bdtaSize = bdtaSize;
    }

    public int getIndexOption() {
        return this.indexOption;
    }

    public void setIndexOption(int indexOption) {
        this.indexOption = indexOption;
    }

    public int getNoMpp() {
        return this.noMpp;
    }

    public void setNoMpp(int noMpp) {
        this.noMpp = noMpp;
    }

    public int getCharset() {
        return this.charset;
    }

    public int getLobFromMsg() {
        return this.lobFromMsg;
    }

    public void setLobFromMsg(int lobFromMsg) {
        this.lobFromMsg = lobFromMsg;
    }

    public int getIgnoreConflict() {
        return this.ignoreConflict;
    }

    public void setIgnoreConflict(int ignoreConflict) {
        this.ignoreConflict = ignoreConflict;
    }

    public short getSetId() {
        return this.setId;
    }

    public void setSetId(short setId) {
        this.setId = setId;
    }

    public short getBldrNumber() {
        return this.bldrNumber;
    }

    public void setBldrNumber(short bldrNumber) throws SQLException {
        if (bldrNumber <= 0 || bldrNumber > 1024) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("bldrNumber should be [1, 1024]");
        }
        this.bldrNumber = bldrNumber;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public byte getFlushFlag() {
        return this.flushFlag;
    }

    public void setFlushFlag(byte flushFlag) {
        this.flushFlag = flushFlag;
    }

    public byte getParallelFlag() {
        return this.parallelFlag;
    }

    public void setParallelFlag(byte parallelFlag) {
        this.parallelFlag = parallelFlag;
    }

    public List<SequenceNumInfo> getSequenceNumInfos() {
        return this.sequenceNumInfos;
    }

    public void setSequenceNumInfos(List<SequenceNumInfo> sequenceNumInfos) {
        this.sequenceNumInfos = sequenceNumInfos;
    }

    public void setCharset(Charset charset) {
        this.charset = "UTF-8".equals(charset.name()) ? 1 : ("GBK".equals(charset.name()) ? 2 : ("BIG5".equals(charset.name()) ? 3 : ("ISO-8859-9".equals(charset.name()) ? 4 : ("EUC_JP".equals(charset.name()) ? 5 : ("EUC-KR".equals(charset.name()) ? 6 : ("KOI8_R".equals(charset.name()) ? 7 : ("ISO-8859-1".equals(charset.name()) ? 8 : ("US-ASCII".equals(charset.name()) ? 9 : ("GB18030".equals(charset.name()) ? 10 : ("UTF-16".equals(charset.name()) ? 12 : 0))))))))));
    }

    public int getMsgVersion() {
        return this.msgVersion;
    }

    public void setMsgVersion(int msgVersion) {
        this.msgVersion = msgVersion;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

