/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.plugin.fldr.LobStream;
import dm.jdbc.plugin.fldr.LobStreamReader;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StreamUtil;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class FldrUtil {
    public static synchronized byte[] fromDate(Date date, Calendar calendar) {
        int msec;
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        cal.setTime(date);
        byte[] dt = new byte[13];
        byte[] years = ByteUtil.fromShort((short)cal.get(1));
        dt[0] = years[0];
        dt[1] = years[1];
        dt[2] = (byte)(cal.get(2) + 1);
        cal.get(5);
        dt[3] = (byte)cal.get(5);
        dt[4] = (byte)cal.get(11);
        dt[5] = (byte)cal.get(12);
        dt[6] = (byte)cal.get(13);
        if (date instanceof Timestamp) {
            Timestamp ts = (Timestamp)date;
            msec = ts.getNanos() / 1000;
        } else {
            msec = cal.get(14) * 1000;
        }
        dt[7] = (byte)(msec & 0xFF);
        dt[8] = (byte)(msec >> 8 & 0xFF);
        dt[9] = (byte)(msec >> 16 & 0xFF);
        dt[12] = (byte)(msec >> 24 & 0xFF);
        return dt;
    }

    public static synchronized byte[] fromDate12(Date date, Calendar calendar) {
        int msec;
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        cal.setTime(date);
        byte[] dt = new byte[12];
        byte[] years = ByteUtil.fromShort((short)cal.get(1));
        dt[0] = years[0];
        dt[1] = years[1];
        dt[2] = (byte)(cal.get(2) + 1);
        cal.get(5);
        dt[3] = (byte)cal.get(5);
        dt[4] = (byte)cal.get(11);
        dt[5] = (byte)cal.get(12);
        dt[6] = (byte)cal.get(13);
        if (date instanceof Timestamp) {
            Timestamp ts = (Timestamp)date;
            msec = ts.getNanos() / 1000;
        } else {
            msec = cal.get(14) * 1000;
        }
        dt[7] = (byte)(msec & 0xFF);
        dt[8] = (byte)(msec >> 8 & 0xFF);
        dt[9] = (byte)(msec >> 16 & 0xFF);
        int timeZone = (cal == null ? TimeZone.getDefault().getRawOffset() : cal.getTimeZone().getRawOffset()) / 60000;
        byte[] tz = ByteUtil.fromShort((short)timeZone);
        dt[10] = tz[0];
        dt[11] = tz[1];
        return dt;
    }

    public static Object fromAsciiStream(InputStream x2, Column param, DmdbConnection connection, long length, int columnIndex) throws SQLException {
        try {
            String ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    if (length == -1L) {
                        length = x2.available();
                    }
                    byte[] asciiBytes = StreamUtil.readBytes(x2, (int)length);
                    char[] javaChars = ConvertUtil.ASCIIBytesToJavaChars(asciiBytes, 0, asciiBytes.length);
                    return String.valueOf(javaChars);
                }
                case 17: 
                case 18: {
                    byte[] bytes = StreamUtil.readBytes(x2, (int)length);
                    ret = DB2J.toString(bytes, param, connection);
                    break;
                }
                case 12: 
                case 19: {
                    if (length == -1L) {
                        length = x2.available();
                    }
                    if (length > Integer.MAX_VALUE) {
                        DBError.ECJDBC_SERIAL_LOB_IOEX.throwz(new Object[0]);
                    }
                    return new LobStream(columnIndex, length, x2, 2);
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromBinaryStream(InputStream x2, Column param, DmdbConnection connection, long length, int columnIndex) throws SQLException {
        try {
            String ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 17: 
                case 18: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    if (length == -1L) {
                        length = x2.available();
                    }
                    byte[] bytes = StreamUtil.readBytes(x2, (int)length);
                    ret = DB2J.toString(bytes, param, connection);
                    break;
                }
                case 12: 
                case 19: {
                    if (length == -1L) {
                        length = x2.available();
                    }
                    if (length > Integer.MAX_VALUE) {
                        DBError.ECJDBC_SERIAL_LOB_IOEX.throwz(new Object[0]);
                    }
                    return new LobStream(columnIndex, length, x2, 1);
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromUnicodeStream(InputStream x2, Column param, long length, int columnIndex) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    if (length == -1L) {
                        length = x2.available();
                    }
                    byte[] bytes = StreamUtil.readBytes(x2, (int)length);
                    ret = ConvertUtil.UnicodeBytesToString(bytes, bytes.length);
                    break;
                }
                case 12: 
                case 19: {
                    if (length == -1L) {
                        length = x2.available();
                    }
                    if (length > Integer.MAX_VALUE) {
                        DBError.ECJDBC_SERIAL_LOB_IOEX.throwz(new Object[0]);
                    }
                    return new LobStream(columnIndex, length, x2, 3);
                }
                case 17: 
                case 18: {
                    if (length == -1L) {
                        length = x2.available();
                    }
                    ret = StreamUtil.readBytes(x2, (int)length);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromReader(Reader x2, Column param, DmdbConnection connection, long length, int columnIndex) throws SQLException {
        try {
            String ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 17: 
                case 18: {
                    String str = StreamUtil.readString(x2, (int)length);
                    if (param.mask == 3 && !DmdbBFile.isValidBFileStr(str)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    ret = str;
                    break;
                }
                case 12: 
                case 19: {
                    return new LobStreamReader(columnIndex, length, x2, 3);
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }
}

