/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.a.a.j;
import dm.jdbc.a.a.r;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DMException;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.fldr.FldrTask;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.plugin.fldr.ColumnData;
import dm.jdbc.plugin.fldr.ColumnInfo;
import dm.jdbc.plugin.fldr.Fldr;
import dm.jdbc.plugin.fldr.FldrBuffer;
import dm.jdbc.plugin.fldr.FldrClusterInfo;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrErrorWriter;
import dm.jdbc.plugin.fldr.FldrIndexInfo;
import dm.jdbc.plugin.fldr.FldrUtil;
import dm.jdbc.plugin.fldr.LobData;
import dm.jdbc.plugin.fldr.SetEnvInfo;
import dm.jdbc.plugin.fldr.TableInfo;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class FldrStatement
extends DmdbPreparedStatement {
    public String schemaName;
    public String tableName;
    public String schemaTable;
    private volatile boolean firstFlag = true;
    private byte lockFlag = 0;
    private static final String SQL_SAMPLE = "SELECT 1 FROM DUAL";
    private TableInfo tableInfo;
    private Fldr primaryFldr;
    private boolean clusterFlag = false;
    private SetEnvInfo setEnvInfo;
    private int rows;
    private Map<Short, String> setIdMap = new HashMap<Short, String>();
    private FldrClusterInfo clusterInfo;
    private ExecutorService clusterExecutor = Executors.newFixedThreadPool(5);
    private ExecutorService bindExecutor = Executors.newFixedThreadPool(5);
    private ConcurrentHashMap<Fldr, Integer> usedFldr = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Map<Short, String>> lastBpIdTabName = new ConcurrentHashMap();
    public Map<Integer, int[]> columnIdScale = new HashMap<Integer, int[]>();
    private static final String DECIMAL_PRECISION_SCALE_SQL = "/*DMJDBC*/ SELECT * FROM \"%s\".\"%s\" LIMIT 1";
    private static final String INVALID_PARAM_FORMAT = "the %s column %s row data cannot match to Type {%s}";
    private static final String CAST_ERROR_FORMAT = "could not cast to target type, targetSqlType: %s, serverSqlType: %s";
    private static final String EXCEED_MAX_ROWS_FORMAT = "Binding parameter exceeds maxRows: {maxRows: %s, currentRow: %s, data: %s}";
    private final String TIMESTAMP_FORMAT = "%s-%s-%s %s:%s:%s.%s";
    private volatile boolean insertFlag = false;
    private boolean usedAsyncPrep = false;
    private AtomicBoolean usedAsyncInsert = new AtomicBoolean(false);
    private boolean stopFlag = false;
    private int realSeqNo = 1;
    private AtomicInteger currentSeqNo = new AtomicInteger(1);
    private AtomicBoolean cancelFlag = new AtomicBoolean(false);
    private Map<Integer, FldrBuffer> batchMap = new HashMap<Integer, FldrBuffer>();
    private volatile boolean asyncStopFlag = false;
    private volatile CacheQueue<FldrBuffer> batchQueue = new CacheQueue(60, false);
    private int maxSeqNo = Integer.MIN_VALUE;
    public int maxError = 1;
    private AtomicInteger committedRows = new AtomicInteger(0);
    public AtomicInteger curErrorNum = new AtomicInteger(0);
    public String logDir;
    private int reconnectTimes = 3;
    private long connInterval = 3000L;
    public AtomicInteger count = new AtomicInteger(1);
    private HashSet<Integer> defaultColumns = new HashSet();
    private boolean firstTimeWithColIndex = true;
    private FldrErrorWriter fldrErrorWriter;

    public int getCommittedRows() {
        return this.committedRows.get();
    }

    protected FldrStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    protected FldrStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, String sql, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, sql, autoGeneratedKeys, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, FldrConfig config) throws SQLException {
        super(connection, SQL_SAMPLE, 0, false);
        this.setFldrTableInfo(config.schemaName, config.tableName, config.parallelFlag ? 1 : 0, config.indexOption);
        this.setFldrProperties(config);
        this.schemaTable = "[DMFLDR]\"" + this.schemaName + "\"." + "\"" + this.tableName + "\"";
    }

    public FldrStatement(DmdbConnection connection, Map<String, String> configMap) throws SQLException {
        super(connection, SQL_SAMPLE, 0, false);
        String parallelStr = configMap.get("parallelFlag");
        int parallelFlag = 0;
        if (StringUtil.isNotEmpty(parallelStr) && parallelStr.equals("1")) {
            parallelFlag = 1;
        }
        this.setFldrTableInfo(configMap.get("schemaName"), configMap.get("tableName"), parallelFlag, 1);
        this.setFldrProperties(configMap);
        this.schemaTable = "[DMFLDR]\"" + this.schemaName + "\"." + "\"" + this.tableName + "\"";
    }

    public FldrStatement(DmdbConnection connection, String sql, int[] columnIndexes, boolean fromPool) throws SQLException {
        super(connection, sql, columnIndexes, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, String sql, String[] columnNames, boolean fromPool) throws SQLException {
        super(connection, sql, columnNames, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public DmdbResultSet do_executeQuery() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return -1;
    }

    public synchronized void setBindExecutor(int bindThreadNum) throws SQLException {
        if (bindThreadNum <= 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        while (!this.clusterExecutor.isShutdown()) {
            this.clusterExecutor.shutdownNow();
        }
        while (!this.bindExecutor.isShutdown()) {
            this.bindExecutor.shutdownNow();
        }
        this.bindExecutor = Executors.newFixedThreadPool(bindThreadNum);
        this.clusterExecutor = Executors.newFixedThreadPool(bindThreadNum);
    }

    public void setReconnectTimes(int times) {
        this.reconnectTimes = times;
    }

    public void setConnInterval(long interval) {
        if (interval <= 0L) {
            return;
        }
        this.connInterval = interval;
    }

    public int getReconnectTimes() {
        return this.reconnectTimes;
    }

    @Override
    public void do_setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.do_setObject(parameterIndex, null);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private void shutdownExecutor() {
        while (!this.clusterExecutor.isShutdown()) {
            this.clusterExecutor.shutdownNow();
        }
        while (!this.bindExecutor.isShutdown()) {
            this.bindExecutor.shutdownNow();
        }
        if (this.fldrErrorWriter.isAlive()) {
            this.fldrErrorWriter.setStopFlag(true);
        }
    }

    public boolean isBlocked(int seqNo) {
        if (this.cancelFlag.get() || seqNo == -1) {
            return false;
        }
        if (this.currentSeqNo.get() != seqNo) {
            return true;
        }
        if (this.tableInfo.containLob && this.realSeqNo >= this.count.get() + 1) {
            return true;
        }
        if (this.realSeqNo > this.count.get() + this.batchQueue.maxSize) {
            return true;
        }
        return this.batchQueue.maxSize == this.batchQueue.size();
    }

    public void setBatchQueue(int size) {
        this.batchQueue = new CacheQueue(size, false);
    }

    @Override
    public void do_setBoolean(int parameterIndex, boolean x2) throws SQLException {
        try {
            int result = x2 ? 1 : 0;
            this.do_setObject(parameterIndex, result);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setByte(int parameterIndex, byte x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 5) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setShort(int parameterIndex, short x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 6 && columnInfo.getColumnType() != 5) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (SQLException e2) {
            this.shutdownExecutor();
            throw e2;
        }
    }

    @Override
    public void do_setInt(int parameterIndex, int x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 7) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (SQLException e2) {
            this.shutdownExecutor();
            throw e2;
        }
    }

    @Override
    public void do_setINTERVALDT(int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 21) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setINTERVALYM(int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 20) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setLong(int parameterIndex, long x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 8) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setFloat(int parameterIndex, float x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 10) {
                this.do_setObject(parameterIndex, Float.valueOf(x2));
                return;
            }
            this.curRowDatas[parameterIndex - 1] = Float.valueOf(x2);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setDouble(int parameterIndex, double x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 11) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 9) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            int[] precScale = this.columnIdScale.get(parameterIndex - 1);
            if (precScale == null) {
                DBError.ECJDBC_INVALID_SCALE.throwz("Server could not provide valid precision and scale");
            }
            this.curRowDatas[parameterIndex - 1] = FldrStatement.roundHalfUp(x2, precScale[0], precScale[1]);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    public static BigDecimal roundHalfUp(BigDecimal dec, int prec, int scale) {
        if (dec == null) {
            return null;
        }
        if (dec.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        dec = new BigDecimal(dec.stripTrailingZeros().toPlainString());
        if (scale == 0 && prec == 0) {
            if (dec.precision() == 0 || dec.scale() != 0) {
                if (dec.precision() + dec.scale() < 38) {
                    return dec;
                }
                int precision = dec.precision() - dec.scale();
                precision = precision % 2 == 0 ? precision : precision + 1;
                scale = 38 - precision > 0 ? 38 - precision : scale;
                dec = dec.setScale(scale, RoundingMode.HALF_UP);
            }
        } else if (scale > 0 && dec.scale() > scale) {
            dec = dec.setScale(scale, RoundingMode.HALF_UP);
        } else if (scale == 0 && dec.scale() != 0) {
            dec = dec.setScale(scale, RoundingMode.HALF_UP);
        }
        return dec;
    }

    @Override
    public void do_setString(int parameterIndex, String x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() == 2 || columnInfo.getColumnType() == 1 || columnInfo.getColumnType() == 0) {
                this.curRowDatas[parameterIndex - 1] = x2;
            } else if (columnInfo.getColumnType() == 6 || columnInfo.getColumnType() == 5) {
                this.curRowDatas[parameterIndex - 1] = Short.parseShort(x2);
            } else if (columnInfo.getColumnType() == 11) {
                this.curRowDatas[parameterIndex - 1] = Double.parseDouble(x2);
            } else if (columnInfo.getColumnType() == 10) {
                this.curRowDatas[parameterIndex - 1] = Float.valueOf(Float.parseFloat(x2));
            } else if (columnInfo.getColumnType() == 9) {
                this.curRowDatas[parameterIndex - 1] = new BigDecimal(x2);
            } else if (columnInfo.getColumnType() == 14 || columnInfo.getColumnType() == 15 || columnInfo.getColumnType() == 22 || columnInfo.getColumnType() == 16 || columnInfo.getColumnType() == 26 || columnInfo.getColumnType() == 23 || columnInfo.getColumnType() == 27) {
                this.curRowDatas[parameterIndex - 1] = DmdbTimestamp.valueOf(x2);
            } else if (columnInfo.getColumnType() == 19) {
                this.curRowDatas[parameterIndex - 1] = DmdbClob.newInstance(x2, this.connection);
            } else if (columnInfo.getColumnType() == 12) {
                this.curRowDatas[parameterIndex - 1] = DmdbBlob.newInstanceOfLocal(x2.getBytes(), this.connection);
            } else if (columnInfo.getColumnType() == 20) {
                this.curRowDatas[parameterIndex - 1] = new DmdbIntervalYM(x2);
            } else if (columnInfo.getColumnType() == 21) {
                this.curRowDatas[parameterIndex - 1] = new DmdbIntervalDT(x2);
            } else if (columnInfo.getColumnType() == 3) {
                this.curRowDatas[parameterIndex - 1] = Integer.parseInt(x2);
            } else if (columnInfo.getColumnType() == 7 || columnInfo.getColumnType() == 8) {
                this.curRowDatas[parameterIndex - 1] = Long.parseLong(x2);
            } else if (columnInfo.getColumnType() == 18 || columnInfo.getColumnType() == 17) {
                this.curRowDatas[parameterIndex - 1] = x2;
            } else {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
        }
        catch (Exception exception) {
            this.shutdownExecutor();
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    @Override
    public void do_setBytes(int parameterIndex, byte[] x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 18 && columnInfo.getColumnType() != 17) {
                this.do_setObject(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private <T extends java.util.Date> void setFldrDate(int parameterIndex, T x2) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setDate(int parameterIndex, Date x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTime(int parameterIndex, Time x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTIMESTAMP(int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setAsciiStream(parameterIndex, x2, (long)length);
    }

    @Override
    public void do_setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (length < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("length = 0");
        }
        try {
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            boolean notNull = this.beforeStreamProcess(parameterIndex, x2, length < 0, columnInfo.getColumnType());
            if (notNull) {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromUnicodeStream(x2, parameter, length, parameterIndex - 1);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (length < 0) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("length = 0");
        }
        this.do_setBinaryStream(parameterIndex, x2, (long)length);
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        this.do_setObject(parameterIndex, x2);
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if (x2 instanceof InputStream) {
            this.do_setBinaryStream(parameterIndex, (InputStream)x2);
        } else if (x2 instanceof Reader) {
            this.do_setCharacterStream(parameterIndex, (Reader)x2);
        } else if (x2 instanceof String) {
            this.do_setString(parameterIndex, (String)x2);
        } else if (9 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType()) {
            this.ObjectToDecimal(parameterIndex, x2);
        } else if (12 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType()) {
            this.ObjectToBlob(parameterIndex, x2);
        } else if (19 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType()) {
            if (x2 instanceof CharSequence) {
                this.curRowDatas[parameterIndex - 1] = DmdbClob.newInstance(String.valueOf(x2), this.connection);
            } else if (x2 instanceof Clob) {
                this.do_setClob(parameterIndex, (Clob)x2);
            } else {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(x2);
            }
        } else {
            this.curRowDatas[parameterIndex - 1] = 20 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType() ? new DmdbIntervalYM(String.valueOf(x2)) : (21 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType() ? new DmdbIntervalDT(String.valueOf(x2)) : x2);
        }
    }

    public void setBatchData(int[] columnIndex, Object[][] dataArr, int seqNO) throws SQLException {
        if (columnIndex == null || columnIndex.length == 0) {
            this.setBatchData(dataArr, seqNO);
            return;
        }
        if (this.firstTimeWithColIndex) {
            this.checkColumnIndex(columnIndex);
            Arrays.sort(columnIndex);
            int i2 = 0;
            while (i2 < this.tableInfo.getColumnInfos().size()) {
                if (Arrays.binarySearch(columnIndex, i2) < 0) {
                    this.defaultColumns.add(i2);
                }
                ++i2;
            }
            this.firstTimeWithColIndex = false;
        }
        Object[][] newDataArr = new Object[dataArr.length][this.tableInfo.getColumnInfos().size()];
        int row = 0;
        while (row < dataArr.length) {
            Object[] oldRowData = dataArr[row];
            Object[] newRowData = newDataArr[row];
            int count = 0;
            int[] nArray = columnIndex;
            int n2 = columnIndex.length;
            int n3 = 0;
            while (n3 < n2) {
                int index = nArray[n3];
                newRowData[index] = oldRowData[count++];
                ++n3;
            }
            ++row;
        }
        this.setBatchData(newDataArr, seqNO);
    }

    private void checkColumnIndex(int[] columnIndex) throws SQLException {
        int[] nArray = columnIndex;
        int n2 = columnIndex.length;
        int n3 = 0;
        while (n3 < n2) {
            int index = nArray[n3];
            if (index < 0) {
                DBError.ECJDBC_FLDR_INVALID_COLUMN_INDEX.throwz(index);
            }
            ++n3;
        }
    }

    public void setBatchData(Object[][] dataArr, int seqNo) throws SQLException {
        while (this.isBlocked(seqNo)) {
            if (this.maxError > 0 && this.curErrorNum.get() >= this.maxError) {
                this.shutdownExecutor();
                DBError.ECJDBC_FLDR_APPROACH_MAX_ERROR.throwz(new Object[0]);
            }
            if (dataArr != null && dataArr.length != 0 || seqNo == -1) continue;
            this.stopFlag = true;
            this.do_close();
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (this.cancelFlag.get()) {
            this.asyncStopFlag = true;
            return;
        }
        this.usedAsyncPrep = true;
        Calendar cal = Calendar.getInstance();
        if (seqNo == -1) {
            this.asyncColumnDataList(dataArr, seqNo, cal);
            return;
        }
        this.currentSeqNo.addAndGet(1);
        int times = dataArr.length / this.rows + (dataArr.length % this.rows > 0 ? 1 : 0);
        if (times == 1) {
            this.setMaxSeqNo();
            this.asyncColumnDataList(dataArr, this.realSeqNo++, cal);
            return;
        }
        int i2 = 0;
        while (i2 < times) {
            Object[][] data;
            if (i2 == times - 1) {
                data = new Object[dataArr.length - i2 * this.rows][dataArr[0].length];
                System.arraycopy(dataArr, i2 * this.rows, data, 0, data.length);
            } else {
                data = new Object[this.rows][dataArr[0].length];
                System.arraycopy(dataArr, i2 * this.rows, data, 0, this.rows);
            }
            this.setMaxSeqNo();
            this.asyncColumnDataList(data, this.realSeqNo++, cal);
            ++i2;
        }
    }

    private void setMaxSeqNo() {
        this.maxSeqNo = this.realSeqNo;
    }

    private void ObjectToBlob(int parameterIndex, Object x2) throws SQLException {
        if (x2 == null) {
            this.curRowDatas[parameterIndex - 1] = null;
            return;
        }
        if (x2 instanceof byte[]) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal((byte[])x2, this.connection));
        } else if (x2 instanceof String) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromString((String)x2, this.connection.getServerEncoding()), this.connection));
        } else if (x2 instanceof Integer) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromInt((Integer)x2), this.connection));
        } else if (x2 instanceof Long) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromLong((Long)x2), this.connection));
        } else if (x2 instanceof Short) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromShort((Short)x2), this.connection));
        } else if (x2 instanceof Float) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromFloat(((Float)x2).floatValue()), this.connection));
        } else if (x2 instanceof Double) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(ByteUtil.fromDouble((Double)x2), this.connection));
        } else if (x2 instanceof BigDecimal) {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(((BigDecimal)x2).toPlainString().getBytes(this.connection.getServerEncoding()), this.connection));
        } else if (x2 instanceof Blob) {
            this.do_setBlob(parameterIndex, (Blob)x2);
        } else if (x2 instanceof Clob) {
            Clob clob = (Clob)x2;
            String str = clob.getSubString(0L, (int)clob.length());
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(str.getBytes(), this.connection));
        } else {
            this.do_setBlob(parameterIndex, DmdbBlob.newInstanceOfLocal(String.valueOf(x2).getBytes(this.connection.getServerEncoding()), this.connection));
        }
    }

    private void ObjectToDecimal(int parameterIndex, Object x2) throws SQLException {
        if (x2 instanceof BigDecimal) {
            this.do_setBigDecimal(parameterIndex, (BigDecimal)x2);
        } else if (x2 instanceof Byte) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Byte)x2).byteValue()));
        } else if (x2 instanceof Short) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Short)x2).shortValue()));
        } else if (x2 instanceof Integer) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Integer)x2).intValue()));
        } else if (x2 instanceof Long) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf((Long)x2));
        } else if (x2 instanceof Double) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf((Double)x2));
        } else if (x2 instanceof Float) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Float)x2).floatValue()));
        } else {
            this.do_setBigDecimal(parameterIndex, x2 == null ? null : new BigDecimal(x2.toString()));
        }
    }

    @Override
    public boolean do_execute() throws SQLException {
        block9: {
            try {
                if (this.curRowDatas != null && this.curRowDatas.length != 0) break block9;
                return false;
            }
            catch (Exception e2) {
                this.shutdownExecutor();
                if (e2 instanceof SQLException) {
                    throw (SQLException)e2;
                }
                DBError.throwRuntimeException("Partition mismatched: {currentRow: 1}");
                return false;
            }
        }
        ArrayList<Object[]> curRowList = new ArrayList<Object[]>();
        curRowList.add(this.curRowDatas);
        if (this.tableInfo.gethTableHead() == null) {
            this.tableInfo.hTableNameData.put(this.tableName, curRowList);
        } else {
            this.tableInfo.getHTabPartition(this.curRowDatas, this.clusterInfo);
        }
        if (this.clusterFlag) {
            this.clusterProcess();
        } else {
            this.noClusterProcess();
        }
        this.tableInfo.clearData();
        if (this.connection.autoCommit) {
            this.connection.dbAccess.commit();
        }
        return true;
    }

    @Override
    public void do_addBatch() throws SQLException {
        this.multiRowDatas.add(this.curRowDatas);
        ++this.irow;
        if (this.irow > this.rows) {
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = this.curRowDatas;
            int n2 = this.curRowDatas.length;
            int n3 = 0;
            while (n3 < n2) {
                Object data = objectArray[n3];
                sb.append(data).append(";");
                ++n3;
            }
            this.shutdownExecutor();
            DBError.ECJDBC_UNBINDED_PARAMETER.throwz(String.format(EXCEED_MAX_ROWS_FORMAT, this.rows, this.irow, sb));
        }
        Object[] tmp = new Object[this.paramCount];
        System.arraycopy(this.curRowDatas, 0, tmp, 0, tmp.length);
        this.curRowDatas = tmp;
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void do_setRef(int parameterIndex, Ref x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_setBlob(int parameterIndex, Blob blob) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = blob;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setClob(int parameterIndex, Clob clob) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = clob;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setArray(int parameterIndex, Array x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public DmdbResultSetMetaData do_getMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void do_setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        this.setFldrDate(parameterIndex, cal.getTime());
    }

    @Override
    public void do_setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        this.setFldrDate(parameterIndex, cal.getTime());
    }

    @Override
    public void do_setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        String format = String.format("%s-%s-%s %s:%s:%s.%s", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), x2.getNanos() / 1000);
        Timestamp timestamp = Timestamp.valueOf(format);
        this.setFldrDate(parameterIndex, timestamp);
    }

    @Override
    public void do_setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void do_setURL(int parameterIndex, URL x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 12);
            return;
        }
        this.do_setString(parameterIndex, x2.toString());
    }

    @Override
    public DmdbParameterMetaData do_getParameterMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void do_setRowId(int parameterIndex, RowId x2) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            if (x2 == null) {
                this.do_setNull(parameterIndex, -8);
            }
            if (8 == columnInfo.getColumnType()) {
                this.do_setLong(parameterIndex, Long.parseLong(x2.toString()));
            } else if (28 == columnInfo.getColumnType()) {
                this.curRowDatas[parameterIndex - 1] = x2;
            } else {
                this.do_setObject(parameterIndex, x2);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setNString(int parameterIndex, String value) throws SQLException {
        this.do_setString(parameterIndex, value);
    }

    @Override
    public void do_setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void do_setNClob(int parameterIndex, NClob value) throws SQLException {
        this.do_setClob(parameterIndex, value);
    }

    @Override
    public void do_setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void do_setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void do_setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void do_setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.do_setNull(parameterIndex, 2009);
        } else {
            this.do_setCharacterStream(parameterIndex, ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
        }
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.do_setObject(parameterIndex, x2, targetSqlType);
    }

    private boolean beforeStreamProcess(int parameterIndex, Object x2, boolean vaildFlag, int colType) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if (vaildFlag) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length could not less than 0");
            }
            if (x2 == null) {
                this.do_setNull(parameterIndex, colType);
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
            return false;
        }
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        ColumnInfo columnInfo;
        try {
            int available = x2.available();
            if (length > (long)available) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length exceeds the max length");
            }
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            throw new SQLException(e2);
        }
        boolean notNull = this.beforeStreamProcess(parameterIndex, x2, length < -1L, (columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType());
        if (notNull) {
            try {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromAsciiStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
            catch (Exception e3) {
                this.shutdownExecutor();
                if (e3 instanceof SQLException) {
                    throw (SQLException)e3;
                }
                DBError.ECJDBC_COMMUNITION_ERROR.throwz(e3);
            }
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        ColumnInfo columnInfo;
        try {
            int available = x2.available();
            if (length > (long)available) {
                this.shutdownExecutor();
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length exceeds the max length");
            }
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            throw new SQLException(e2);
        }
        boolean notNull = this.beforeStreamProcess(parameterIndex, x2, length < 0L, (columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType());
        if (notNull) {
            try {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromBinaryStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
            catch (Exception e3) {
                this.shutdownExecutor();
                if (e3 instanceof SQLException) {
                    throw (SQLException)e3;
                }
                DBError.ECJDBC_COMMUNITION_ERROR.throwz(e3);
            }
        }
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            boolean notNull = this.beforeStreamProcess(parameterIndex, reader, length < -1L, columnInfo.getColumnType());
            if (notNull) {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromReader(reader, parameter, this.connection, length, parameterIndex - 1);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        try {
            this.do_setAsciiStream(parameterIndex, x2, x2.available());
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            throw new SQLException(e2);
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        try {
            this.do_setBinaryStream(parameterIndex, x2, x2.available());
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            throw new SQLException(e2);
        }
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, -1L);
    }

    @Override
    public void do_setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value);
    }

    @Override
    public void do_setClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void do_setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void do_setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public DmdbResultSet do_executeQuery(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void do_close() throws SQLException {
        block32: {
            try {
                try {
                    if (this.do_closeAsync()) {
                        while (!this.asyncStopFlag && (this.maxError > 0 && this.curErrorNum.get() < this.maxError || this.maxError == -1)) {
                        }
                    }
                    this.do_clearParameters();
                    if (this.serverParameters != null) {
                        var4_1 = this.serverParameters;
                        var3_2 = this.serverParameters.length;
                        var2_4 = 0;
                        while (var2_4 < var3_2) {
                            param = var4_1[var2_4];
                            MiscUtil.close(param);
                            ++var2_4;
                        }
                    }
                    if (this.bindParameters != null) {
                        var4_1 = this.bindParameters;
                        var3_2 = this.bindParameters.length;
                        var2_4 = 0;
                        while (var2_4 < var3_2) {
                            param = var4_1[var2_4];
                            MiscUtil.close(param);
                            ++var2_4;
                        }
                    }
                    if (this.insertFlag) {
                        if (!this.clusterFlag) {
                            this.primaryFldr.clearEnvironment(1);
                        } else {
                            for (Fldr fldr : this.usedFldr.keySet()) {
                                fldrIndexInfos = fldr.clearEnvironment(1);
                                this.updateIndexInfo(fldrIndexInfos);
                            }
                            if (this.tableInfo.dpcFlag && !this.tableInfo.indexInfos.isEmpty()) {
                                this.primaryFldr.resetIndexInfo(this.tableInfo.indexInfos);
                            }
                        }
                    }
                    if (this.maxError > 0 && this.curErrorNum.get() >= this.maxError) {
                        throw new SQLException();
                    }
                    ** GOTO lbl78
                }
                catch (Exception e) {
                    if (e instanceof DMException) {
                        throw (DMException)e;
                    }
                    if (this.maxError > 0 && this.curErrorNum.get() >= this.maxError) {
                        DBError.ECJDBC_FLDR_APPROACH_MAX_ERROR.throwz(new Object[0]);
                    }
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[]{e});
                    ** while (!this.clusterExecutor.isTerminated() || !this.clusterExecutor.isShutdown())
                }
            }
            catch (Throwable var5_14) {
                ** while (!this.clusterExecutor.isTerminated() || !this.clusterExecutor.isShutdown())
            }
lbl-1000:
            // 1 sources

            {
                this.clusterExecutor.shutdownNow();
                continue;
            }
lbl49:
            // 2 sources

            while (!this.bindExecutor.isTerminated() || !this.bindExecutor.isShutdown()) {
                this.bindExecutor.shutdownNow();
            }
            if (this.fldrErrorWriter.isAlive()) {
                this.fldrErrorWriter.setStopFlag(true);
            }
            if (!this.clusterFlag) break block32;
            for (DmdbConnection connection : this.clusterInfo.connections) {
                connection.do_close();
            }
            break block32;
lbl-1000:
            // 1 sources

            {
                this.clusterExecutor.shutdownNow();
                continue;
            }
lbl65:
            // 2 sources

            while (!this.bindExecutor.isTerminated() || !this.bindExecutor.isShutdown()) {
                this.bindExecutor.shutdownNow();
            }
            if (this.fldrErrorWriter.isAlive()) {
                this.fldrErrorWriter.setStopFlag(true);
            }
            if (this.clusterFlag) {
                for (DmdbConnection connection : this.clusterInfo.connections) {
                    connection.do_close();
                }
            }
            throw var5_14;
lbl-1000:
            // 1 sources

            {
                this.clusterExecutor.shutdownNow();
lbl78:
                // 2 sources

                ** while (!this.clusterExecutor.isTerminated() || !this.clusterExecutor.isShutdown())
            }
lbl79:
            // 2 sources

            while (!this.bindExecutor.isTerminated() || !this.bindExecutor.isShutdown()) {
                this.bindExecutor.shutdownNow();
            }
            if (this.fldrErrorWriter.isAlive()) {
                this.fldrErrorWriter.setStopFlag(true);
            }
            if (this.clusterFlag) {
                for (DmdbConnection connection : this.clusterInfo.connections) {
                    connection.do_close();
                }
            }
        }
    }

    @Override
    public void do_clearParameters() {
        this.curRowDatas = null;
        if (this.multiRowDatas.isEmpty()) {
            Parameter[] parameterArray = this.bindParameters;
            int n2 = this.bindParameters.length;
            int n3 = 0;
            while (n3 < n2) {
                Parameter param = parameterArray[n3];
                param.clear();
                ++n3;
            }
        }
        this.toBeLockedConnections.clear();
    }

    private void updateIndexInfo(List<FldrIndexInfo> retIndexInfos) throws SQLException {
        if (this.tableInfo.dpcFlag && TableInfo.msgVersion > 0 && !retIndexInfos.isEmpty() && !this.tableInfo.indexInfos.isEmpty()) {
            block0: for (FldrIndexInfo oldIndexInfo : this.tableInfo.indexInfos) {
                for (FldrIndexInfo curInfo : retIndexInfos) {
                    if (curInfo.getIndexId() != oldIndexInfo.getIndexId()) continue;
                    oldIndexInfo.setValidFlag(curInfo.getValidFlag() > 0 && oldIndexInfo.getValidFlag() > 0 ? (byte)1 : 0);
                    continue block0;
                }
            }
        }
    }

    @Override
    public int do_getMaxFieldSize() {
        return this.tableInfo.getColumnInfos().size();
    }

    @Override
    public void do_setMaxFieldSize(int max) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getMaxRows() {
        return this.setEnvInfo.getBldrNumber();
    }

    @Override
    public void do_setMaxRows(int max) throws SQLException {
        if (max > 0 && max <= 10000) {
            this.setEnvInfo.setBdtaSize(max);
        }
        DBError.EC_INVALID_DB_OBJECT.throwz(new Object[0]);
    }

    @Override
    public void do_setEscapeProcessing(boolean enable) {
    }

    @Override
    public void do_setQueryTimeout(int seconds) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_cancel() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_setCursorName(String name) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public boolean do_execute(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public DmdbResultSet do_getResultSet() {
        return null;
    }

    @Override
    public int do_getUpdateCount() {
        return -1;
    }

    @Override
    public boolean do_getMoreResults() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public void do_setFetchDirection(int direction) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getFetchDirection() {
        return 0;
    }

    @Override
    public void do_setFetchSize(int rows) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getFetchSize() {
        return -1;
    }

    @Override
    public int do_getResultSetConcurrency() {
        return -1;
    }

    @Override
    public int do_getResultSetType() {
        return -1;
    }

    @Override
    public void do_addBatch(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int[] do_executeBatch() throws SQLException {
        if (this.multiRowDatas.isEmpty()) {
            return new int[1];
        }
        if (this.tableInfo.gethTableHead() == null) {
            this.tableInfo.hTableNameData.put(this.tableName, this.multiRowDatas);
        } else {
            int i2 = 0;
            while (i2 < this.multiRowDatas.size()) {
                try {
                    this.tableInfo.getHTabPartition((Object[])this.multiRowDatas.get(i2), this.clusterInfo);
                }
                catch (Exception e2) {
                    this.shutdownExecutor();
                    if (e2 instanceof SQLException) {
                        throw (SQLException)e2;
                    }
                    DBError.throwRuntimeException("Partition mismatched: {currentRow: " + (i2 + 1) + "}");
                }
                ++i2;
            }
        }
        try {
            if (this.clusterFlag) {
                this.clusterProcess();
            } else {
                this.noClusterProcess();
            }
            int[] rows = new int[]{this.irow};
            this.tableInfo.clearData();
            this.do_clearBatch();
            return rows;
        }
        catch (SQLException e3) {
            this.shutdownExecutor();
            throw e3;
        }
    }

    @Override
    public void do_clearBatch() {
        this.irow = 0;
        if (this.multiRowDatas != null) {
            this.multiRowDatas.clear();
        }
        super.do_clearBatch();
    }

    private void noClusterProcess() throws SQLException {
        for (Map.Entry<String, List<Object[]>> entry : this.tableInfo.hTableNameData.entrySet()) {
            String subTableName = entry.getKey();
            List<Object[]> rowData = entry.getValue();
            if (rowData == null || rowData.isEmpty()) continue;
            this.usedFldr.put(this.primaryFldr, 1);
            short setId = this.primaryFldr.getSetId(String.valueOf(this.schemaName) + ":" + subTableName, this.setEnvInfo.getBldrNumber());
            this.setFldrEnv(this.primaryFldr, subTableName, setId);
            List<ColumnData> columnData = this.getColumnDataList(rowData);
            this.primaryFldr.insert(columnData, this.tableInfo, rowData.size(), setId, this.maxError, this.bindExecutor);
            this.insertFlag = true;
        }
        if (this.connection.autoCommit) {
            this.connection.dbAccess.commit();
        }
    }

    private void clusterProcess() throws SQLException {
        Map<Integer, List<Map.Entry<String, List<Object[]>>>> map = this.getBpInfo(this.tableInfo.hTableNameData);
        FldrStatement.doTaskOnEverySite(this.clusterExecutor, map.entrySet(), map.entrySet().size(), new Callback<Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>>>(){

            @Override
            void run(Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>> entry) throws SQLException {
                try {
                    Integer bpId = entry.getKey();
                    Fldr fldr = FldrStatement.this.clusterInfo.fldrsMap.get(bpId);
                    Map<Short, String> tableMaps = FldrStatement.this.lastBpIdTabName.get(bpId);
                    List<Map.Entry<String, List<Object[]>>> entryList = entry.getValue();
                    FldrStatement.this.usedFldr.put(fldr, 1);
                    SetEnvInfo localSetEnv = (SetEnvInfo)FldrStatement.this.setEnvInfo.clone();
                    for (Map.Entry<String, List<Object[]>> subEntry : entryList) {
                        String subTableName = subEntry.getKey();
                        List<Object[]> rowData = subEntry.getValue();
                        short setId = fldr.getSetId(bpId + ":" + FldrStatement.this.schemaName + ":" + subTableName, FldrStatement.this.setEnvInfo.getBldrNumber());
                        String containedTab = tableMaps.get(setId);
                        if (!subTableName.equals(containedTab)) {
                            localSetEnv.setSetId(setId);
                            localSetEnv.setTableName(subTableName);
                            String result = fldr.setEnvironment(localSetEnv, FldrStatement.this.defaultColumns, FldrStatement.this.tableInfo);
                            if (!result.equals("SUCCESS")) {
                                FldrStatement.this.shutdownExecutor();
                                throw new SQLException(String.valueOf(subTableName) + ": " + result);
                            }
                            tableMaps.put(setId, subTableName);
                            FldrStatement.this.lastBpIdTabName.put(bpId, tableMaps);
                        }
                        List<ColumnData> columnData = FldrStatement.this.getColumnDataList(rowData);
                        fldr.insert(columnData, FldrStatement.this.tableInfo, rowData.size(), setId, FldrStatement.this.maxError, FldrStatement.this.bindExecutor);
                        FldrStatement.this.insertFlag = true;
                        if (!FldrStatement.this.connection.autoCommit) continue;
                        FldrStatement.this.connection.dbAccess.commit();
                    }
                }
                catch (SQLException e2) {
                    FldrStatement.this.shutdownExecutor();
                    throw e2;
                }
                catch (CloneNotSupportedException e3) {
                    FldrStatement.this.shutdownExecutor();
                    throw new RuntimeException(e3);
                }
            }
        });
    }

    private synchronized int clusterAsyncProcess(Map<Integer, List<Object[]>> map) throws SQLException {
        final AtomicInteger tmpCount = new AtomicInteger(0);
        FldrStatement.doTaskOnEverySite(this.bindExecutor, map.entrySet(), map.entrySet().size(), new Callback<Map.Entry<Integer, List<Object[]>>>(){

            @Override
            void run(Map.Entry<Integer, List<Object[]>> entry) throws SQLException {
                try {
                    if (FldrStatement.this.cancelFlag.get()) {
                        FldrStatement.this.do_close();
                        return;
                    }
                    Integer bpId = entry.getKey();
                    Fldr fldr = FldrStatement.this.clusterInfo.fldrsMap.get(bpId);
                    Map<Short, String> tableMaps = FldrStatement.this.lastBpIdTabName.get(bpId);
                    List<Object[]> list = entry.getValue();
                    SetEnvInfo localSetEnv = (SetEnvInfo)FldrStatement.this.setEnvInfo.clone();
                    for (Object[] objects : list) {
                        String subTableName = (String)objects[0];
                        Buffer buffer = (Buffer)objects[1];
                        tmpCount.addAndGet(buffer.getInt(64));
                        List lobList = (List)objects[2];
                        Map errRowMap = (Map)objects[3];
                        short setId = fldr.getSetId(bpId + ":" + FldrStatement.this.schemaName + ":" + subTableName, FldrStatement.this.setEnvInfo.getBldrNumber());
                        String containedTab = tableMaps.get(setId);
                        if (!subTableName.equals(containedTab)) {
                            localSetEnv.setSetId(setId);
                            localSetEnv.setTableName(subTableName);
                            String result = fldr.setEnvironment(localSetEnv, FldrStatement.this.defaultColumns, FldrStatement.this.tableInfo);
                            if (!result.equals("SUCCESS")) {
                                FldrStatement.this.curErrorNum.incrementAndGet();
                                FldrStatement.this.cancelFlag.set(true);
                                throw new SQLException(String.valueOf(subTableName) + ": " + result);
                            }
                            tableMaps.put(setId, subTableName);
                            FldrStatement.this.lastBpIdTabName.put(bpId, tableMaps);
                        }
                        buffer.setInt(20, setId);
                        fldr.insertBatch(FldrStatement.this.maxError, buffer, FldrStatement.this.curErrorNum, FldrStatement.this.schemaTable, FldrStatement.this.fldrErrorWriter);
                        fldr.insertLob(setId, lobList, errRowMap);
                        FldrStatement.this.usedFldr.put(fldr, 1);
                        FldrStatement.this.insertFlag = true;
                    }
                }
                catch (Exception e2) {
                    FldrStatement.this.shutdownExecutor();
                    if (e2 instanceof SQLException) {
                        throw (SQLException)e2;
                    }
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                }
            }
        });
        return tmpCount.get();
    }

    private Map<Integer, List<Map.Entry<String, List<Object[]>>>> getBpInfo(Map<String, List<Object[]>> hTabData) throws SQLException {
        HashMap<Integer, List<Map.Entry<String, List<Object[]>>>> map = new HashMap<Integer, List<Map.Entry<String, List<Object[]>>>>();
        try {
            for (Map.Entry<String, List<Object[]>> entry : hTabData.entrySet()) {
                int bpId;
                if (this.tableInfo.subTableNameIdMap != null) {
                    int tableId = this.tableInfo.subTableNameIdMap.get(entry.getKey());
                    bpId = this.clusterInfo.tabIdToBpIdMap.get(tableId);
                } else {
                    bpId = this.clusterInfo.tabIdToBpIdMap.values().iterator().next();
                }
                List<Map.Entry<String, List<Object[]>>> list = map.get(bpId);
                if (list == null) {
                    list = new ArrayList<Map.Entry<String, List<Object[]>>>();
                }
                list.add(entry);
                map.put(bpId, list);
                if (this.lastBpIdTabName.get(bpId) != null) continue;
                this.lastBpIdTabName.put(bpId, new HashMap());
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            throw new SQLException(e2);
        }
        return map;
    }

    private List<ColumnData> getColumnDataList(List<Object[]> rowDataList) throws SQLException {
        if (rowDataList == null || rowDataList.isEmpty()) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz(new Object[0]);
        }
        final List<ColumnData> columnDataList = this.createColumn(rowDataList.get(0).length, rowDataList.size());
        FldrStatement.doTaskOnEverySite(this.bindExecutor, rowDataList, columnDataList.size(), new Callback2<List<Object[]>>(){

            @Override
            void run(List<Object[]> list, int colIndex) throws SQLException {
                ColumnData columnData = (ColumnData)columnDataList.get(colIndex);
                int rowIndex = 0;
                while (rowIndex < list.size()) {
                    Object o2 = list.get(rowIndex)[colIndex];
                    FldrStatement.this.autoIncreaseProcess(colIndex, columnData, rowIndex, o2);
                    ++rowIndex;
                }
            }
        });
        return columnDataList;
    }

    private void asyncColumnDataList(final Object[][] arr, final int seqNo, Calendar calendar) {
        final FldrStatement statement = this;
        final Calendar cal = calendar;
        FldrTask task = new FldrTask(this, this.fldrErrorWriter){

            @Override
            protected void doTask() throws SQLException {
                Callback<Object[][]> callback = new Callback<Object[][]>(){

                    @Override
                    void run(Object[][] siteObject) throws SQLException {
                        Map<String, List<Object[]>> hTabMap = null;
                        if (seqNo != -1) {
                            try {
                                hTabMap = (this).FldrStatement.this.tableInfo.getAsyncHTabPartition(arr, cal, (this).FldrStatement.this.clusterInfo);
                            }
                            catch (SQLException e2) {
                                if ((this).FldrStatement.this.maxError == -1) {
                                    statement.count.addAndGet(1);
                                } else if ((this).FldrStatement.this.maxError <= (this).FldrStatement.this.curErrorNum.get() + 1 && !(this).FldrStatement.this.cancelFlag.get()) {
                                    (this).FldrStatement.this.cancelFlag.set(true);
                                    (this).FldrStatement.this.asyncStopFlag = true;
                                }
                                throw e2;
                            }
                        }
                        FldrBuffer fldrBuffer = null;
                        if ((this).FldrStatement.this.clusterFlag) {
                            if (seqNo == -1) {
                                fldrBuffer = FldrStatement.this.createFldrBuffer(seqNo, arr, cal);
                            } else {
                                Map<Integer, List<Map.Entry<String, List<Object[]>>>> bpInfo = statement.getBpInfo(hTabMap);
                                fldrBuffer = FldrStatement.this.createFldrBuffer(seqNo, bpInfo, cal, arr);
                            }
                        } else if (hTabMap == null || hTabMap.isEmpty()) {
                            fldrBuffer = FldrStatement.this.createFldrBuffer(seqNo, arr, cal);
                        } else {
                            for (Map.Entry entry : hTabMap.entrySet()) {
                                String subTableName = (String)entry.getKey();
                                List dataList = (List)entry.getValue();
                                fldrBuffer = FldrStatement.this.createFldrBuffer(fldrBuffer, seqNo, subTableName, dataList, cal, arr);
                            }
                        }
                        while (!(this).FldrStatement.this.batchQueue.put(fldrBuffer)) {
                            if (!FldrStatement.this.checkCancel()) continue;
                            return;
                        }
                    }
                };
                callback.run(arr);
            }
        };
        this.bindExecutor.execute(task);
    }

    private boolean checkCancel() {
        return this.cancelFlag.get() || this.maxError > 0 && this.curErrorNum.get() >= this.maxError;
    }

    private FldrBuffer createFldrBuffer(int seqNo, Map<Integer, List<Map.Entry<String, List<Object[]>>>> bpInfo, Calendar cal, Object[][] arr) throws SQLException {
        if (seqNo == -1) {
            return new FldrBuffer(seqNo, null, null, new LinkedHashMap<Integer, Exception>(0));
        }
        FldrBuffer fldrBuffer = new FldrBuffer();
        fldrBuffer.setSeqNo(seqNo);
        fldrBuffer.sethTabFlag(this.tableInfo.dpcFlag);
        for (Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>> entry : bpInfo.entrySet()) {
            Integer bpId = entry.getKey();
            List<Map.Entry<String, List<Object[]>>> subTabData = entry.getValue();
            for (Map.Entry<String, List<Object[]>> tabData : subTabData) {
                String subTabName = tabData.getKey();
                List<Object[]> dataList = tabData.getValue();
                Object[] objects = this.FBHelper(subTabName, dataList, cal, arr);
                fldrBuffer.setBpData(bpId, objects);
            }
        }
        return fldrBuffer;
    }

    private FldrBuffer createFldrBuffer(FldrBuffer fldrBuffer, int seqNo, String subTableName, List<Object[]> dataList, Calendar cal, Object[][] arr) throws SQLException {
        Object[] objects = new Object[2];
        if (seqNo != -1) {
            objects = this.FBHelper(subTableName, dataList, cal, arr);
        }
        return fldrBuffer == null ? new FldrBuffer(seqNo, subTableName, (Buffer)objects[0], (List)objects[1], (Map)objects[2]) : fldrBuffer.setTabDetail(subTableName, objects);
    }

    private Object[] FBHelper(String tableName, List<Object[]> dataList, Calendar cal, Object[][] arr) throws SQLException {
        Object[] objectArray;
        List<ColumnData> columnDataList = this.createColumn(dataList.get(0).length, dataList.size());
        List<Object> lobData = Collections.emptyList();
        int columnIndex = 0;
        while (columnIndex < dataList.get(0).length) {
            ColumnData columnData = columnDataList.get(columnIndex);
            int rowIndex = 0;
            while (rowIndex < dataList.size()) {
                Object o2 = dataList.get(rowIndex)[columnIndex];
                this.autoIncreaseProcess(columnIndex, columnData, rowIndex, o2);
                ++rowIndex;
            }
            ++columnIndex;
        }
        Buffer buffer = Buffer.allocate(32640, true, this.connection.bufferType);
        Object[] objects = r.a(buffer, this, dataList.size(), (short)columnDataList.size(), columnDataList, this.tableInfo, cal, this.maxError, arr, this.fldrErrorWriter);
        Map errRowMap = (Map)objects[1];
        int errorNum = this.curErrorNum.addAndGet((Integer)objects[0]);
        if (this.maxError == -1 || this.maxError > 0 && errorNum < this.maxError) {
            lobData = j.b(columnDataList, this.tableInfo);
        }
        if (this.tableInfo.dpcFlag) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = tableName;
            objectArray2[1] = buffer;
            objectArray2[2] = lobData;
            objectArray = objectArray2;
            objectArray2[3] = errRowMap;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = buffer;
            objectArray3[1] = lobData;
            objectArray = objectArray3;
            objectArray3[2] = errRowMap;
        }
        return objectArray;
    }

    private FldrBuffer createFldrBuffer(int seqNo, Object[][] arr, Calendar cal) throws SQLException {
        Buffer buffer = null;
        List<LobData> lobData = null;
        Map errRowMap = null;
        if (seqNo != -1) {
            List<ColumnData> columnDataList = this.createColumn(arr[0].length, arr.length);
            int columnIndex = 0;
            while (columnIndex < arr[0].length) {
                ColumnData columnData = columnDataList.get(columnIndex);
                int rowIndex = 0;
                while (rowIndex < arr.length) {
                    Object o2 = arr[rowIndex][columnIndex];
                    this.autoIncreaseProcess(columnIndex, columnData, rowIndex, o2);
                    ++rowIndex;
                }
                ++columnIndex;
            }
            buffer = Buffer.allocate(32640, true, this.connection.bufferType);
            Object[] o3 = r.a(buffer, this, arr.length, (short)columnDataList.size(), columnDataList, this.tableInfo, cal, this.maxError, arr, this.fldrErrorWriter);
            errRowMap = (Map)o3[1];
            int errorNum = this.curErrorNum.addAndGet((Integer)o3[0]);
            if (this.maxError > 0 && errorNum >= this.maxError) {
                this.asyncCancel();
                DBError.ECJDBC_FLDR_APPROACH_MAX_ERROR.throwz(new Object[0]);
            } else {
                lobData = j.b(columnDataList, this.tableInfo);
            }
        }
        return new FldrBuffer(seqNo, buffer, lobData, errRowMap);
    }

    private boolean autoIncreaseProcess(int columnIndex, ColumnData columnData, int rowIndex, Object o2) throws SQLException {
        if (columnIndex == this.tableInfo.autoIncrementColId) {
            this.processAutoIncrementColumn(rowIndex, columnData, o2);
            return true;
        }
        if (o2 == null) {
            if (columnData.getSqlType() == 12 || columnData.getSqlType() == 19) {
                columnData.getData().add(null);
            }
            columnData.setIsAllNotNull(0);
            return true;
        }
        columnData.getData().add(o2);
        columnData.getNullArr()[rowIndex] = 1;
        return false;
    }

    public synchronized void asyncCancel() throws SQLException {
        if (!this.cancelFlag.get()) {
            this.cancelFlag.set(true);
            this.asyncStopFlag = true;
            this.do_close();
        }
    }

    public void asyncExecuteBatch() {
        if (this.usedAsyncInsert.get() || this.checkCancel()) {
            return;
        }
        final FldrStatement stmt = this;
        this.usedAsyncInsert.set(true);
        FldrTask task2 = new FldrTask(this, this.fldrErrorWriter){

            @Override
            protected void doTask() throws SQLException {
                if (FldrStatement.this.cancelFlag.get()) {
                    FldrStatement.this.asyncStopFlag = true;
                    FldrStatement.this.do_close();
                    return;
                }
                int sentRows = 0;
                while (true) {
                    FldrBuffer fldrBuffer;
                    int tmpRows = 0;
                    if (FldrStatement.this.checkCancel()) {
                        FldrStatement.this.asyncStopFlag = true;
                        return;
                    }
                    do {
                        if ((fldrBuffer = FldrStatement.this.batchMap.get(FldrStatement.this.count.get())) == null) {
                            if (FldrStatement.this.batchQueue.size() == 0 && FldrStatement.this.stopFlag && FldrStatement.this.maxSeqNo < FldrStatement.this.count.get() || FldrStatement.this.checkCancel()) {
                                FldrStatement.this.asyncStopFlag = true;
                                FldrStatement.this.committedRows.addAndGet(sentRows);
                                return;
                            }
                            fldrBuffer = FldrStatement.this.batchQueue.get();
                            if (fldrBuffer == null) continue;
                            if (fldrBuffer.getSeqNo() == FldrStatement.this.count.get()) break;
                            if (fldrBuffer.getSeqNo() == -1) {
                                FldrStatement.this.stopFlag = true;
                                continue;
                            }
                            FldrStatement.this.batchMap.put(fldrBuffer.getSeqNo(), fldrBuffer);
                            continue;
                        }
                        FldrStatement.this.batchMap.remove(FldrStatement.this.count.get());
                        break;
                    } while (fldrBuffer == null || fldrBuffer.getSeqNo() != FldrStatement.this.count.get());
                    if (fldrBuffer.gethTabFlag()) {
                        if (FldrStatement.this.tableInfo.dpcFlag) {
                            HashMap<Integer, List<Object[]>> bpData = fldrBuffer.getBpData();
                            tmpRows += stmt.clusterAsyncProcess(bpData);
                        } else {
                            HashMap<String, Object[]> htabInfo = fldrBuffer.getHtabInfo();
                            for (Map.Entry<String, Object[]> entry : htabInfo.entrySet()) {
                                String subTableName = entry.getKey();
                                Object[] value = entry.getValue();
                                int curRows = ((Buffer)value[0]).getInt(64);
                                if (curRows == 0) {
                                    FldrStatement.this.count.addAndGet(1);
                                    continue;
                                }
                                if (stmt.insertBatchHelper((Buffer)value[0], (List)value[1], (Map)value[2], FldrStatement.this.primaryFldr, subTableName)) continue;
                                tmpRows += curRows;
                            }
                        }
                    } else {
                        Buffer buffer = fldrBuffer.getBuffer();
                        List<LobData> lobList = fldrBuffer.getLobList();
                        Map<Integer, Exception> errRowMap = fldrBuffer.getErrRowMap();
                        int curRows = fldrBuffer.getRowNum();
                        if (curRows == 0) {
                            FldrStatement.this.count.addAndGet(1);
                            continue;
                        }
                        if (!stmt.insertBatchHelper(buffer, lobList, errRowMap, FldrStatement.this.primaryFldr, FldrStatement.this.tableName)) {
                            tmpRows += curRows;
                        }
                    }
                    for (Fldr fldr : FldrStatement.this.usedFldr.keySet()) {
                        fldr.dbAccess.commit();
                    }
                    FldrStatement.this.committedRows.addAndGet(tmpRows);
                    if (fldrBuffer.getSeqNo() == -1) continue;
                    FldrStatement.this.count.addAndGet(1);
                }
            }
        };
        this.clusterExecutor.execute(task2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean insertBatchHelper(Buffer buffer, List<LobData> lobList, Map<Integer, Exception> errRowMap, Fldr fldr, String curTabName) throws SQLException {
        firstTime = true;
        i = 0;
        while (i < 3) {
            block10: {
                block12: {
                    block11: {
                        setId = fldr.getSetId(String.valueOf(this.schemaName) + ":" + curTabName, this.setEnvInfo.getBldrNumber());
                        if (!this.setFldrEnvThread(fldr, curTabName, setId)) break block10;
                        buffer.setInt(20, setId);
                        errorFlag = fldr.insertBatch(this.maxError, buffer, this.curErrorNum, this.schemaTable, this.fldrErrorWriter);
                        if (!errorFlag) break block11;
                        return true;
                    }
                    try {
                        fldr.insertLob(setId, lobList, errRowMap);
                        this.usedFldr.put(fldr, 1);
                        this.insertFlag = true;
                        break;
                    }
                    catch (SQLException e) {
                        if (DBError.ECJDBC_COMMUNITION_ERROR.errCode != e.getErrorCode() || !fldr.dbAccess.connection.closed) break block12;
                        if (firstTime) {
                            firstTime = false;
                            this.fldrErrorWriter.writeLines(new String[]{this.schemaTable, "reconnect: " + fldr.dbAccess.connection.host + ":" + fldr.dbAccess.connection.getHostPort() + " " + curTabName, StringUtil.LINE_SEPARATOR});
                        }
                        j = 0;
                        ** while (j < this.reconnectTimes)
                    }
lbl-1000:
                    // 1 sources

                    {
                        MiscUtil.sleep(this.connInterval);
                        try {
                            fldr.dbAccess.connection.openConnection();
                        }
                        catch (Exception v0) {}
                        if (!fldr.dbAccess.connection.closed) break;
                        ++j;
                        continue;
                    }
lbl34:
                    // 2 sources

                    if (fldr.dbAccess.connection.closed) {
                        throw e;
                    }
                    fldr.clearParameters();
                    this.usedFldr.remove(fldr);
                    break block10;
                }
                this.cancelFlag.set(true);
                this.fldrErrorWriter.writeLines(new String[]{this.schemaTable, e.getMessage(), StringUtil.LINE_SEPARATOR});
                throw e;
            }
            ++i;
        }
        if (fldr.dbAccess.connection.closed) {
            this.fldrErrorWriter.writeLines(new String[]{this.schemaTable, "reconnect failed, please check the status of server!", StringUtil.LINE_SEPARATOR});
            this.cancelFlag.set(true);
        }
        return false;
    }

    private void setFldrEnv(Fldr fldr, String curTabName, short setId) throws SQLException {
        String containedTab = this.setIdMap.get(setId);
        if (!curTabName.equals(containedTab)) {
            this.setEnvInfo.setSetId(setId);
            this.setEnvInfo.setTableName(curTabName);
            String result = fldr.setEnvironment(this.setEnvInfo, this.defaultColumns, this.tableInfo);
            if (!result.equals("SUCCESS")) {
                this.fldrErrorWriter.writeLines(this.schemaTable, result, StringUtil.LINE_SEPARATOR);
                DBError.throwRuntimeException(String.valueOf(curTabName) + ": " + result);
                return;
            }
            this.setIdMap.put(setId, curTabName);
        }
    }

    private boolean setFldrEnvThread(Fldr fldr, String curTabName, short setId) throws SQLException {
        String containedTab = this.setIdMap.get(setId);
        if (!curTabName.equals(containedTab)) {
            this.setEnvInfo.setSetId(setId);
            this.setEnvInfo.setTableName(curTabName);
            String result = fldr.setEnvironment(this.setEnvInfo, this.defaultColumns, this.tableInfo);
            if (!result.equals("SUCCESS")) {
                this.cancelFlag.set(true);
                throw new SQLException(String.valueOf(curTabName) + ": " + result);
            }
            this.setIdMap.put(setId, curTabName);
        }
        return true;
    }

    private List<ColumnData> createColumn(int length, int rows) {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(length);
        int i2 = 0;
        while (i2 < length) {
            ColumnData columnData = new ColumnData();
            columnData.setColumnIndex(i2);
            columnData.setSqlType(this.tableInfo.getColumnInfos().get(i2).getColumnType());
            columnData.setIsAllNotNull(1);
            columnData.setNullArr(new byte[rows]);
            columnData.setData(new ArrayList<Object>());
            columnDataList.add(columnData);
            ++i2;
        }
        return columnDataList;
    }

    private void processAutoIncrementColumn(int index, ColumnData columnData, Object o2) throws SQLException {
        if (this.setEnvInfo.getSetIdentity() == 0) {
            columnData.setIsAllNotNull(0);
            return;
        }
        if (o2 == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("The auto-increasing number mismatched: {currentRow: %s}", index));
        }
        columnData.getNullArr()[index] = 1;
        columnData.getData().add(o2);
    }

    @Override
    public boolean do_getMoreResults(int current) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public DmdbResultSet do_getGeneratedKeys() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return -1;
    }

    @Override
    public int do_executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public int do_executeUpdate(String sql, String[] columnNames) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public boolean do_execute(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public boolean do_execute(String sql, int[] columnIndexes) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public boolean do_execute(String sql, String[] columnNames) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public int do_getResultSetHoldability() {
        return -1;
    }

    @Override
    public boolean do_isPoolable() {
        return false;
    }

    @Override
    public boolean do_isCloseOnCompletion() {
        return false;
    }

    public <T> T do_unwrap(Class<T> iface) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public boolean do_isWrapperFor(Class<?> iface) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    private String processName(String name) {
        if (name.contains("\"\"")) {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = name.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c2 = cArray[n3];
                if (c2 == '\"') {
                    stringBuilder.append(c2);
                }
                stringBuilder.append(c2);
                ++n3;
            }
            return stringBuilder.toString();
        }
        return name;
    }

    private synchronized void setFldrTableInfo(String schemaName, String tableName, int parallelFlag, int indexOption) throws SQLException {
        if (!this.firstFlag) {
            DBError.throwRuntimeException("FldrStatement could not set tableInfo again");
        }
        if (schemaName == null || schemaName.isEmpty()) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("Schema name could not be empty");
        }
        if (tableName == null || tableName.isEmpty()) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("Table name could not be empty");
        }
        this.firstFlag = false;
        assert (schemaName != null);
        assert (tableName != null);
        this.schemaName = schemaName;
        this.tableName = tableName;
        if (parallelFlag == 0) {
            this.lockFlag = 1;
        }
        this.clusterFlag = false;
        this.primaryFldr = this.connection.getFldrInstance();
        this.tableInfo = this.primaryFldr.getTableInfo(this.schemaName, this.tableName, this.lockFlag);
        if (this.tableInfo.dpcFlag && TableInfo.msgVersion > 0) {
            List<FldrIndexInfo> indexInfos = this.primaryFldr.getIndexInfo(this.schemaName, this.tableName, parallelFlag, indexOption);
            if (this.tableInfo.indexInfos.isEmpty()) {
                this.tableInfo.indexInfos = indexInfos;
            } else {
                int i2 = 0;
                while (i2 < this.tableInfo.indexInfos.size()) {
                    FldrIndexInfo indexInfo;
                    indexInfo.setValidFlag((indexInfo = this.tableInfo.indexInfos.get(i2)).getValidFlag() > 0 || indexInfos.get(i2).getValidFlag() > 0 ? (byte)1 : 0);
                    ++i2;
                }
            }
        }
        this.tableInfo.setConn(this.connection);
        if (this.tableInfo.containDecimal || this.tableInfo.containChar) {
            this.getPrecAndScale(schemaName, tableName);
        }
        if (this.tableInfo.dpcFlag) {
            this.clusterFlag = true;
            this.clusterInfo = this.primaryFldr.getMppInfo(this.schemaName, this.tableName);
            this.clusterInfo.primaryFldr = this.primaryFldr;
            this.clusterExecutor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), this.clusterInfo.ipInfoList.size()));
            FldrStatement.doTaskOnEverySite(this.clusterExecutor, this.clusterInfo.ipInfoList, this.clusterInfo.ipInfoList.size(), new Callback<Object[]>(){

                @Override
                void run(Object[] ipInfo) throws SQLException {
                    try {
                        DmProperties props = (DmProperties)FldrStatement.this.connection.props.clone();
                        props.setProperty(Configuration.user.getName(), FldrStatement.this.connection.user);
                        props.setProperty(Configuration.password.getName(), FldrStatement.this.connection.password);
                        props.setProperty(Configuration.mppLocal.getName(), "true");
                        props.setProperty(Configuration.host.getName(), String.valueOf(ipInfo[1]));
                        props.setProperty(Configuration.port.getName(), String.valueOf(ipInfo[2]));
                        props.setProperty(Configuration.epGroup.getName(), null);
                        DmdbConnection conn = DmDriver.driver.do_connect(props);
                        FldrStatement.this.clusterInfo.connections.add(conn);
                        FldrStatement.this.clusterInfo.fldrsMap.put((Integer)ipInfo[0], conn.getFldrInstance());
                    }
                    catch (Exception e2) {
                        FldrStatement.this.shutdownExecutor();
                        if (e2 instanceof SQLException) {
                            throw (SQLException)e2;
                        }
                        DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                    }
                }
            });
        }
        this.paramCount = this.tableInfo.getNameIdMap().size();
        this.curRowDatas = new Object[this.paramCount];
    }

    private void getPrecAndScale(String schemaName, String tableName) throws SQLException {
        schemaName = this.processName(schemaName);
        tableName = this.processName(tableName);
        List<ColumnInfo> columnInfos = this.tableInfo.getColumnInfos();
        DmdbResultSet resultSet = DriverUtil.executeQuery(this.connection, String.format(DECIMAL_PRECISION_SCALE_SQL, schemaName, tableName));
        DmdbResultSetMetaData resultSetMetaData = resultSet.do_getMetaData();
        for (ColumnInfo info : columnInfos) {
            if (info.getColumnId() == -1) continue;
            int precision = resultSetMetaData.do_getPrecision(info.getColumnId() + 1);
            int scale = resultSetMetaData.do_getScale(info.getColumnId() + 1);
            String typeName = resultSetMetaData.do_getColumnTypeName(info.getColumnId() + 1);
            if (9 == info.getColumnType()) {
                this.columnIdScale.put(Integer.valueOf(info.getColumnId()), new int[]{precision, scale});
                continue;
            }
            if (info.getColumnType() > 2) continue;
            if (typeName.toUpperCase().startsWith("NVARCHAR")) {
                info.setColumnLen((short)scale);
                continue;
            }
            info.setColumnLen((short)precision);
        }
        resultSet.do_close();
        this.tableInfo.setColumnIdScale(this.columnIdScale);
    }

    private boolean do_closeAsync() throws SQLException {
        if (this.usedAsyncPrep) {
            if (this.usedAsyncInsert.compareAndSet(true, false)) {
                this.setBatchData(null, -1);
                this.usedAsyncPrep = false;
                return true;
            }
            return false;
        }
        if (this.usedAsyncInsert.compareAndSet(true, false)) {
            this.setBatchData(null, -1);
            return true;
        }
        return false;
    }

    private void setFldrProperties(FldrConfig config) throws SQLException {
        if (config == null) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("FldrConfig could not be null");
        }
        this.setEnvInfo = new SetEnvInfo();
        this.setEnvInfo.setSetIdentity(config.setIdentity ? 1 : 0);
        this.setEnvInfo.setSorted(config.sorted ? 1 : 0);
        this.setEnvInfo.setBdtaSize(config.maxRows);
        if (config.indexOption == 1 || config.indexOption == 2) {
            this.setEnvInfo.setIndexOption(config.indexOption);
        } else {
            DBError.throwRuntimeException("invalid indexOption: " + config.indexOption);
        }
        this.setEnvInfo.setCharset(this.connection.getServerEncoding());
        this.setEnvInfo.setIgnoreConflict(0);
        this.setEnvInfo.setBldrNumber(config.bldrNum);
        this.setEnvInfo.setFlushFlag(config.flushFlag ? (byte)1 : 0);
        this.setEnvInfo.setSchemaName(this.schemaName);
        this.setEnvInfo.setTableName(this.tableName);
        this.setEnvInfo.setParallelFlag(config.parallelFlag ? (byte)1 : 0);
        this.rows = config.maxRows;
        this.maxError = config.maxErrorNum >= -1 && config.maxErrorNum != 0 ? config.maxErrorNum : 1;
        this.logDir = config.logFileName;
        this.fldrErrorWriter = FldrErrorWriter.getInstance(this.maxError, this.logDir);
        if (config.defaultColumns != null) {
            this.defaultColumns = config.defaultColumns;
        }
        this.setEnvInfo.setMsgVersion(TableInfo.msgVersion);
    }

    private void setFldrProperties(Map<String, String> configMap) throws SQLException {
        if (configMap == null || configMap.isEmpty()) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("FldrConfigMap could not be null");
        }
        this.setEnvInfo = new SetEnvInfo();
        String schemaName = configMap.get("schemaName");
        if (schemaName == null || schemaName.isEmpty()) {
            DBError.ECJDBC_SCHNAME_EMPTYSTRING.throwz(new Object[0]);
        } else {
            this.schemaName = schemaName;
            this.setEnvInfo.setSchemaName(this.schemaName);
        }
        String tableName = configMap.get("tableName");
        if (tableName == null || tableName.isEmpty()) {
            DBError.ECJDBC_TABNAME_NULL.throwz(new Object[0]);
        } else {
            this.tableName = tableName;
            this.setEnvInfo.setTableName(this.tableName);
        }
        String setIdentity = configMap.get("setIdentity");
        if (setIdentity == null || setIdentity.isEmpty()) {
            this.setEnvInfo.setSetIdentity(0);
        } else {
            this.setEnvInfo.setSetIdentity(setIdentity.equals("1") ? 1 : 0);
        }
        String sorted = configMap.get("sorted");
        if (sorted == null || sorted.isEmpty()) {
            this.setEnvInfo.setSorted(0);
        } else {
            this.setEnvInfo.setSorted(sorted.equals("1") ? 1 : 0);
        }
        String maxRows = configMap.get("maxRows");
        if (maxRows == null || maxRows.isEmpty()) {
            this.setEnvInfo.setBdtaSize(5000);
        } else {
            this.setEnvInfo.setBdtaSize(Integer.parseInt(maxRows));
        }
        String indexOption = configMap.get("indexOption");
        if (indexOption == null || indexOption.isEmpty()) {
            this.setEnvInfo.setIndexOption(1);
        } else {
            int idxOption = Integer.parseInt(indexOption);
            if (idxOption == 1 || idxOption == 2) {
                this.setEnvInfo.setIndexOption(idxOption);
            } else {
                DBError.throwRuntimeException("invalid indexOption: " + indexOption);
            }
        }
        this.setEnvInfo.setCharset(this.connection.getServerEncoding());
        this.setEnvInfo.setIgnoreConflict(0);
        String bldrNum = configMap.get("bldrNum");
        if (bldrNum == null || bldrNum.isEmpty()) {
            this.setEnvInfo.setBldrNumber((short)64);
        } else {
            this.setEnvInfo.setBldrNumber(Short.parseShort(bldrNum));
        }
        String flushFlag = configMap.get("flushFlag");
        if (flushFlag == null || flushFlag.isEmpty()) {
            this.setEnvInfo.setFlushFlag((byte)0);
        } else {
            this.setEnvInfo.setFlushFlag(flushFlag.equals("1") ? (byte)1 : 0);
        }
        String parallelFlag = configMap.get("parallelFlag");
        if (parallelFlag == null || parallelFlag.isEmpty()) {
            this.setEnvInfo.setParallelFlag((byte)0);
        } else {
            this.setEnvInfo.setParallelFlag(parallelFlag.equals("1") ? (byte)1 : 0);
        }
        String maxErrorNum = configMap.get("maxErrorNum");
        if (maxErrorNum == null || maxErrorNum.isEmpty()) {
            this.maxError = 1;
        } else {
            this.maxError = Integer.parseInt(maxErrorNum);
            this.maxError = this.maxError >= -1 && this.maxError != 0 ? this.maxError : 1;
        }
        this.rows = this.setEnvInfo.getBdtaSize();
        this.logDir = configMap.get("logFileName");
        this.fldrErrorWriter = FldrErrorWriter.getInstance(this.maxError, this.logDir);
        String defaultValue = configMap.get("defaultValue");
        if (StringUtil.isNotEmpty(defaultValue)) {
            String[] split;
            String[] stringArray = split = defaultValue.split(";");
            int n2 = split.length;
            int n3 = 0;
            while (n3 < n2) {
                String s2 = stringArray[n3];
                this.defaultColumns.add(Integer.parseInt(s2));
                ++n3;
            }
        }
        this.setEnvInfo.setMsgVersion(TableInfo.msgVersion);
    }

    public static <T> void doTaskOnEverySite(ExecutorService executor, Collection<T> list, int siteCount, final Callback<T> callback) throws SQLException {
        if (siteCount == 0 || executor == null) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(siteCount);
        FldrTask[] tasks = new FldrTask[siteCount];
        int i2 = 0;
        for (final T siteObj : list) {
            tasks[i2] = new FldrTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    callback.run(siteObj);
                }
            };
            executor.execute(tasks[i2]);
            ++i2;
        }
        FldrStatement.threadCountDownHelper(countDownLatch, tasks);
    }

    public static <T> void doTaskOnEverySite(ExecutorService executor, final T list, int columnSize, final Callback2<T> callback) throws SQLException {
        if (columnSize == 0 || executor == null) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(columnSize);
        FldrTask[] tasks = new FldrTask[columnSize];
        int i2 = 0;
        while (i2 < columnSize) {
            final int colIndex = i2;
            tasks[i2] = new FldrTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    callback.run(list, colIndex);
                }
            };
            executor.execute(tasks[i2]);
            ++i2;
        }
        FldrStatement.threadCountDownHelper(countDownLatch, tasks);
    }

    public static void threadCountDownHelper(CountDownLatch countDownLatch, FldrTask[] tasks) throws SQLException {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        FldrTask[] fldrTaskArray = tasks;
        int n2 = tasks.length;
        int n3 = 0;
        while (n3 < n2) {
            FldrTask task = fldrTaskArray[n3];
            if (!task.isSuccess()) {
                if (task.getError() == null) break;
                throw task.getError();
            }
            ++n3;
        }
    }

    static abstract class Callback<T> {
        Callback() {
        }

        abstract void run(T var1) throws SQLException;
    }

    static abstract class Callback2<T> {
        Callback2() {
        }

        abstract void run(T var1, int var2) throws SQLException;
    }
}

