/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.processor.BaseFlusher;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class FldrErrorWriter
extends BaseFlusher {
    protected static CacheQueue<byte[]> flushQueue = new CacheQueue(1000, false);
    private static final int ONE_MIN_MS = 60000;
    protected static int maxFileNumber = 5;
    protected static int switchMode = 2;
    protected static int switchLimit = 128;
    private static final int SWITCH_MODE_OFF = 0;
    private static final int SWITCH_MODE_BY_LINE_COUNT = 1;
    private static final int SWITCH_MODE_BY_FILE_SIZE = 2;
    private int count = 0;
    private boolean stopFlag = false;
    protected volatile AtomicInteger lineCount = new AtomicInteger(0);
    protected long lastTime = System.currentTimeMillis();
    private String realFileName;
    private boolean customFile = false;
    private final int maxErrorNum;

    private FldrErrorWriter(int maxErrorNum, String logDir) {
        super("FldrLogFlusher", DmSvcConf.GLOBAL.logDir, "dm_fldr", DmSvcConf.GLOBAL.logFlushFreq);
        if (StringUtil.isNotEmpty(logDir)) {
            this.filePath = logDir;
            this.customFile = true;
        }
        maxFileNumber = 1;
        switchMode = 0;
        this.maxErrorNum = maxErrorNum;
        this.start();
    }

    public static FldrErrorWriter getInstance(int maxErrorNum, String logDir) {
        return new FldrErrorWriter(maxErrorNum, logDir);
    }

    public void setStopFlag(boolean stopFlag) {
        this.stopFlag = stopFlag;
    }

    @Override
    protected void doRun() {
        while (this.flushFreq > 0 && !this.stopFlag) {
            byte[] bytes = flushQueue.get();
            this.flushProcess(bytes);
        }
    }

    @Override
    protected void beforeExit() {
        byte[] bytes = null;
        do {
            this.flushProcess(bytes);
        } while ((bytes = flushQueue.get()) != null);
    }

    public synchronized void write(String msg) {
        byte[] bytes = msg.getBytes();
        flushQueue.put(bytes);
    }

    public synchronized void writeLine(String msg) {
        if (this.maxErrorNum > 0 && this.count >= this.maxErrorNum) {
            this.stopFlag = true;
            return;
        }
        byte[] bytes = (String.valueOf(StringUtil.trimToEmpty(msg)) + StringUtil.LINE_SEPARATOR).getBytes();
        flushQueue.put(bytes);
    }

    public void writeLines(String ... msgList) {
        if (msgList == null || msgList.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i2 = 0;
        while (i2 < msgList.length) {
            if (i2 == 1) {
                stringBuilder.append("[REASON]");
            }
            stringBuilder.append(msgList[i2]).append(StringUtil.LINE_SEPARATOR);
            ++i2;
        }
        this.writeLine(stringBuilder.toString());
        ++this.count;
    }

    @Override
    protected FileOutputStream createNewFile() {
        if (switchMode != 0) {
            this.deleteOldFile();
        }
        try {
            Date date = new Date(System.currentTimeMillis());
            this.dateString = DateUtil.formatDate(date, 1);
            if (this.realFileName == null || switchMode != 0) {
                this.realFileName = String.valueOf(this.filePrefix) + "_" + DateUtil.formatDate(date, 3) + "_" + this.fileNum + this.fileExtension;
            }
            if (this.customFile) {
                if (StringUtil.isEmpty(this.filePath)) {
                    this.filePath = this.realFileName;
                }
                this.logFile = new File(this.filePath);
            } else if (StringUtil.isNotEmpty(this.filePath)) {
                File logPath = new File(this.filePath);
                if (!logPath.exists()) {
                    logPath.mkdirs();
                }
                this.logFile = new File(String.valueOf(this.filePath) + this.realFileName);
            }
            if (!this.logFile.exists()) {
                this.logFile.createNewFile();
                ++this.fileNum;
            }
            return new FileOutputStream(this.logFile, true);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return null;
        }
    }

    private void deleteOldFile() {
        File[] files = this.getFiles();
        if (files.length >= maxFileNumber) {
            int i2 = 0;
            while (i2 <= files.length - maxFileNumber) {
                int count = 0;
                while (!files[i2].delete()) {
                    if (count == 3) break;
                    ++count;
                }
                ++i2;
            }
            this.fileNum %= Integer.MAX_VALUE;
        }
    }

    private File[] getFiles() {
        File file = new File(this.filePath);
        Object[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    String name = pathname.getName();
                    return name.startsWith(FldrErrorWriter.this.filePrefix) && name.indexOf(FldrErrorWriter.this.fileExtension) > 0;
                }
                return false;
            }
        });
        files = files == null ? new File[]{} : files;
        Arrays.sort(files);
        return files;
    }

    private synchronized void flushProcess(byte[] bytes) {
        if (bytes != null) {
            this.buffer.putBytes(bytes, 0, bytes.length);
            if (switchMode == 1) {
                this.lineCount.incrementAndGet();
            }
        }
        if (switchMode == 1 && this.lineCount.get() == switchLimit) {
            this.doFlush(this.buffer);
            this.lineCount.set(0);
        }
        if (bytes == null && this.buffer.length() > 0 || this.buffer.length() >= DmSvcConf.GLOBAL.logBufferSize) {
            this.doFlush(this.buffer);
        }
    }

    @Override
    protected boolean needCreateNewFile() {
        boolean overTime;
        if (switchMode == 0) {
            return this.logFile == null;
        }
        if (switchMode == 1) {
            return this.logFile == null || switchLimit == this.lineCount.get();
        }
        if (switchMode == 2) {
            return this.logFile == null || this.logFile.length() >= (long)switchLimit * 1024L * 1024L;
        }
        long currentTime = System.currentTimeMillis();
        boolean bl = overTime = currentTime - this.lastTime >= 60000L * (long)switchLimit;
        if (overTime) {
            this.lastTime = currentTime;
        }
        return this.logFile == null || overTime;
    }
}

