/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.a.a;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.plugin.fldr.ColumnData;
import dm.jdbc.plugin.fldr.FldrClusterInfo;
import dm.jdbc.plugin.fldr.FldrErrorWriter;
import dm.jdbc.plugin.fldr.FldrIndexInfo;
import dm.jdbc.plugin.fldr.HorizontalTableInfo;
import dm.jdbc.plugin.fldr.LobData;
import dm.jdbc.plugin.fldr.SequenceNumInfo;
import dm.jdbc.plugin.fldr.SetEnvInfo;
import dm.jdbc.plugin.fldr.TableInfo;
import dm.jdbc.util.buffer.Buffer;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class Fldr {
    public a dbAccess;
    public short setId = 0;
    public Map<String, Short> tableNameId = new ConcurrentHashMap<String, Short>();
    public Map<Short, String> idTableName = new ConcurrentHashMap<Short, String>();

    public Fldr(a dbAccess) throws SQLException {
        if (dbAccess == null) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz(new Object[0]);
        }
        this.dbAccess = dbAccess;
    }

    public TableInfo getTableInfo(String schemaName, String tableName, byte lockFlag) throws SQLException {
        return this.dbAccess.a(schemaName, tableName, lockFlag);
    }

    public HorizontalTableInfo findIntervalColumn(int boundaryIndex, int innerIndex, int tableId, byte lanMode, Object data, Object newBoundary, TableInfo tableInfo, Calendar cal, FldrClusterInfo clusterInfo, List<DmdbConnection> connections, Map<Integer, Fldr> fldrsMap) throws SQLException {
        return this.dbAccess.a(boundaryIndex, innerIndex, tableId, lanMode, data, newBoundary, tableInfo, cal, clusterInfo);
    }

    public List<FldrIndexInfo> getIndexInfo(String schemaName, String tableName, int parallelFlag, int indexOption) throws SQLException {
        return this.dbAccess.a(schemaName, tableName, parallelFlag, indexOption);
    }

    public FldrClusterInfo getMppInfo(String schemaName, String tableName) throws SQLException {
        return this.dbAccess.a(schemaName, tableName);
    }

    public SequenceNumInfo getSequenceNumber(String schemaName, String sequenceName, short columnId) throws SQLException {
        return this.dbAccess.a(schemaName, sequenceName, columnId);
    }

    public String setEnvironment(SetEnvInfo setTableInfo, Set<Integer> defaultColumns, TableInfo tableInfo) throws SQLException {
        return this.dbAccess.a(setTableInfo, defaultColumns, tableInfo);
    }

    public void insert(List<ColumnData> columnDataList, TableInfo tableInfo, int rows, int setId, int maxError, ExecutorService service) throws SQLException {
        this.dbAccess.a(columnDataList, tableInfo, rows, setId, maxError, service);
    }

    public void insertLob(int setId, List<LobData> lobList, Map<Integer, Exception> errRowMap) throws SQLException {
        if (lobList != null && !lobList.isEmpty()) {
            this.dbAccess.a(setId, lobList, 0, 0, 1, null, errRowMap);
        }
    }

    public boolean insertBatch(int maxError, Buffer buffer, AtomicInteger curErrorNum, String schemaTable, FldrErrorWriter fldrErrorWriter) throws SQLException {
        return this.dbAccess.a(maxError, buffer, curErrorNum, schemaTable, fldrErrorWriter);
    }

    public List<FldrIndexInfo> clearEnvironment(int commitFlag) throws SQLException {
        return this.dbAccess.d(commitFlag);
    }

    public void resetIndexInfo(List<FldrIndexInfo> indexInfos) throws SQLException {
        this.dbAccess.c(indexInfos);
    }

    public short getSetId(String tableName, short bldrNum) {
        Short id = this.tableNameId.get(tableName);
        if (id == null) {
            if (this.setId < bldrNum) {
                this.tableNameId.put(tableName, this.setId);
                this.idTableName.put(this.setId, tableName);
                short s2 = this.setId;
                this.setId = (short)(s2 + 1);
                return s2;
            }
            short newId = (short)(this.setId % bldrNum);
            String oldTableName = this.idTableName.get(newId);
            this.tableNameId.remove(oldTableName);
            this.tableNameId.put(tableName, newId);
            this.idTableName.put(newId, tableName);
            this.setId = (short)(this.setId + 1);
            return newId;
        }
        return id;
    }

    public synchronized void clearParameters() {
        this.tableNameId.clear();
        this.idTableName.clear();
    }
}

