/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jni;

import dm.jdbc.a.a.ac;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.jni.DmUKeyInfo;
import dm.jdbc.util.ByteUtil;
import java.sql.SQLException;

public class DmUkeyDll {
    static {
        System.loadLibrary("dmukey_java");
    }

    public static native long crypto_load_library(byte[] var0, int var1);

    public static native long crypto_login(long var0, byte[] var2, int var3);

    public static native int crypto_get_name(long var0, byte[] var2, int var3);

    public static native int crypto_read_cert(long var0, long var2, byte[] var4, int var5);

    public static native int cipher_asym_sign(long var0, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    public static native boolean crypto_logout(long var0, long var2);

    public static native int cipher_get_auth_type(DmUKeyInfo var0);

    public static native int cipher_user_auth_gen_key(DmUKeyInfo var0);

    public static native int cipher_user_auth_sign(DmUKeyInfo var0);

    public static native int cipher_user_auth_check_digest(DmUKeyInfo var0);

    public static native int cipher_user_auth_update(DmUKeyInfo var0);

    public static native int cipher_user_auth_destroy_key(DmUKeyInfo var0);

    public static synchronized DmUKeyInfo load(DmdbConnection connection) {
        try {
            int ret;
            DmUKeyInfo ukey = new DmUKeyInfo();
            ukey.authType = 1;
            byte[] path = connection.uKeyName.getBytes();
            ukey.handle = DmUkeyDll.crypto_load_library(path, path.length);
            byte[] pin = connection.uKeyPin.getBytes();
            ukey.para = DmUkeyDll.crypto_login(ukey.handle, pin, pin.length);
            ukey.name = new byte[128];
            ukey.nameLength = DmUkeyDll.crypto_get_name(ukey.handle, ukey.name, ukey.name.length);
            try {
                ret = DmUkeyDll.cipher_get_auth_type(ukey);
                if (ret != 0) {
                    DBError.throwRuntimeException("ukey init error!");
                }
            }
            catch (Throwable throwable) {
                ukey.authType = 1;
            }
            if (ukey.authType == 2) {
                ukey.userName = ByteUtil.fromString(connection.user, connection.getServerEncoding());
                ukey.userPassword = ByteUtil.fromString(connection.password, connection.getServerEncoding());
                ret = DmUkeyDll.cipher_user_auth_gen_key(ukey);
                if (ret != 0) {
                    DBError.throwRuntimeException("ukey init error!");
                }
            } else if (ukey.authType == 1) {
                ukey.cert = new byte[4096];
                ukey.certLength = DmUkeyDll.crypto_read_cert(ukey.handle, ukey.para, ukey.cert, ukey.cert.length);
            } else {
                DBError.throwRuntimeException("ukey init error! invalid auth type: " + ukey.authType);
            }
            return ukey;
        }
        catch (Throwable e2) {
            DBError.throwRuntimeException("ukey init error!", e2);
            return null;
        }
    }

    public static void auth(DmdbConnection connection) throws SQLException {
        DmUKeyInfo ukey = connection.dbAccess.f;
        if (ukey == null) {
            return;
        }
        try {
            if (ukey.authType == 2) {
                int ret = DmUkeyDll.cipher_user_auth_sign(ukey);
                if (ret != 0) {
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz("ukey login failed!");
                }
            } else if (ukey.authType == 1) {
                ukey.signdata = new byte[4096];
                ukey.signdataLength = DmUkeyDll.cipher_asym_sign(ukey.handle, 0, null, 0, ukey.random, ukey.random.length, ukey.signdata, ukey.signdata.length);
            }
        }
        catch (Throwable e2) {
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    public static void afterLogin(ac<?> msg) throws SQLException {
        DmUKeyInfo ukey = msg.dV.f;
        if (ukey == null) {
            return;
        }
        if (ukey.authType == 2) {
            int msgLen = msg.ab();
            byte[] ebytes = msg.dV.buffer.getBytes(64, msgLen);
            ukey.digest = ebytes;
            int ret = DmUkeyDll.cipher_user_auth_check_digest(ukey);
            if (ret != 0) {
                DBError.ECJDBC_COMMUNITION_ERROR.throwz("ukey login failed!");
            }
            byte[] bytes = ukey.msgDigest;
            msg.dV.buffer.clear(64);
            msg.dV.buffer.writeBytes(bytes);
            msg.j(bytes.length);
        }
    }

    public static void logout(DmdbConnection connection) throws SQLException {
        DmUKeyInfo ukey = connection.dbAccess.f;
        if (ukey == null) {
            return;
        }
        if (ukey.authType == 2) {
            DmUkeyDll.cipher_user_auth_destroy_key(ukey);
        }
        try {
            DmUkeyDll.crypto_logout(ukey.handle, ukey.para);
        }
        catch (Throwable throwable) {}
    }
}

