/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.processor;

import dm.jdbc.internal.processor.BaseThread;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

public abstract class BaseFlusher
extends BaseThread {
    protected String dateString = DateUtil.formatDate(new Date(System.currentTimeMillis()), 1);
    protected File logFile = null;
    protected FileOutputStream out;
    protected String filePrefix;
    protected int flushFreq;
    protected String filePath;
    public static final int MAX_FILE_SIZE = 0x6400000;
    public static final int FLUSH_SIZE = 32768;
    protected ByteArrayQueue buffer = new ByteArrayQueue();
    protected String fileExtension = ".log";
    protected int fileNum = 0;

    public BaseFlusher(String threadName, String filePath, String filePrefix, int flushFreq) {
        super(threadName);
        this.filePath = filePath;
        this.filePrefix = filePrefix;
        this.flushFreq = flushFreq;
    }

    protected abstract void doRun();

    @Override
    protected abstract void beforeExit() throws Exception;

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable throwable) {
            try {
                this.beforeExit();
            }
            catch (Throwable throwable2) {}
            this.closeCurrentFile();
            throw throwable;
        }
        try {
            this.beforeExit();
        }
        catch (Throwable throwable) {}
        this.closeCurrentFile();
    }

    protected void doFlush(ByteArrayQueue buffer) {
        if (this.out == null || this.needCreateNewFile()) {
            this.closeCurrentFile();
            this.out = this.createNewFile();
        }
        try {
            try {
                buffer.writeBytes(this.out, buffer.length());
                this.out.flush();
            }
            catch (IOException iOException) {
                MiscUtil.close(this.out);
                this.out = null;
                buffer.clear();
            }
        }
        finally {
            buffer.clear();
        }
    }

    protected FileOutputStream createNewFile() {
        try {
            Date date = new Date(System.currentTimeMillis());
            String value = DateUtil.formatDate(date, 1);
            if (!StringUtil.equals(value, this.dateString)) {
                this.fileNum = 0;
            }
            this.dateString = value;
            String fileName = String.valueOf(this.filePrefix) + "_" + DateUtil.formatDate(date, 3) + "_" + this.fileNum + this.fileExtension;
            if (StringUtil.isNotEmpty(this.filePath) && StringUtil.isNotEmpty(fileName)) {
                File logPath = new File(this.filePath);
                if (!logPath.exists()) {
                    logPath.mkdirs();
                }
                this.logFile = new File(String.valueOf(this.filePath) + fileName);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                ++this.fileNum;
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return null;
    }

    protected void closeCurrentFile() {
        if (this.out != null) {
            try {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
            finally {
                this.out = null;
            }
        }
    }

    protected boolean needCreateNewFile() {
        String value = DateUtil.formatDate(new Date(System.currentTimeMillis()), 1);
        return !value.equals(this.dateString) || this.logFile == null || this.logFile.length() > 0x6400000L;
    }
}

