/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.parser;

import dm.jdbc.driver.DBError;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.parser.DmLexer;
import dm.jdbc.internal.parser.FeSQLParameter;
import dm.jdbc.internal.parser.LVal;
import dm.jdbc.internal.parser.MysqlLexer;
import dm.jdbc.internal.parser.SQLParameter;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class SQLProcessor {
    private static final HashSet<String> keywordSet = new HashSet();

    static {
        String[] keywords = new String[]{"INSERT", "ON", "IN", "INTO", "JOIN", "FROM", "SELECT", "UPDATE", "CALL", "DELETE", "TRUNCATE", "WHERE", "AS", "COUNT", "DUAL", "(", ")", ",", "BY", "TABLE"};
        keywordSet.addAll(Arrays.asList(keywords));
    }

    public static List<LVal> lex(String sql) throws IOException {
        LVal lval;
        DmLexer lexer = new DmLexer(new StringReader(sql), false);
        int position = 0;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            lvalList.add(lval);
        }
        return lvalList;
    }

    public static int getParameterCount(String sql) throws IOException {
        LVal lval;
        DmLexer lexer = new DmLexer(new StringReader(sql), false);
        int paramNum = 0;
        while ((lval = lexer.yylex()) != null) {
            if (lval.type != LVal.Type.NORMAL || !StringUtil.equals("?", lval.value) && !StringUtil.equals(":", lval.value)) continue;
            ++paramNum;
        }
        return paramNum;
    }

    public static List<LVal> lexSkipWhitespace(String sql, int n2) throws IOException {
        LVal lval;
        int count = n2;
        DmLexer lexer = new DmLexer(new StringReader(sql), false);
        int position = 0;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            if (lval.type == LVal.Type.WHITESPACE_OR_COMMENT) continue;
            lvalList.add(lval);
            if (n2 > 0 && --count == 0) break;
        }
        return lvalList;
    }

    public static String escape(String sql, String[] keywords) throws IOException {
        if (!(keywords != null && keywords.length != 0 || sql.contains("{") && sql.indexOf("}") > sql.indexOf("{"))) {
            return sql;
        }
        HashMap keywordMap = null;
        if (keywords != null && keywords.length > 0) {
            keywordMap = new HashMap();
            String[] stringArray = keywords;
            int n2 = keywords.length;
            int n3 = 0;
            while (n3 < n2) {
                String keyword = stringArray[n3];
                keywordMap.put(keyword.toUpperCase(), null);
                ++n3;
            }
        }
        StringBuilder nsql = new StringBuilder();
        Stack<Boolean> stack = new Stack<Boolean>();
        List<LVal> lvalList = SQLProcessor.lex(sql);
        int i2 = 0;
        while (i2 < lvalList.size()) {
            LVal lval0 = lvalList.get(i2);
            if (lval0.type == LVal.Type.NORMAL) {
                if (StringUtil.equals(lval0.value, "{")) {
                    LVal lval2;
                    LVal lval1 = SQLProcessor.next(lvalList, i2 + 1);
                    if (lval1 == null || lval1.type != LVal.Type.NORMAL) {
                        stack.push(false);
                        nsql.append(lval0.value);
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "escape") || StringUtil.equalsIgnoreCase(lval1.value, "call")) {
                        stack.push(true);
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "oj")) {
                        stack.push(true);
                        lval1.value = "";
                        lval1.type = LVal.Type.WHITESPACE_OR_COMMENT;
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "d")) {
                        stack.push(true);
                        lval1.value = "date";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "t")) {
                        stack.push(true);
                        lval1.value = "time";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "ts")) {
                        stack.push(true);
                        lval1.value = "datetime";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "fn")) {
                        stack.push(true);
                        lval1.value = "";
                        lval1.type = LVal.Type.WHITESPACE_OR_COMMENT;
                        lval2 = SQLProcessor.next(lvalList, lval1.position + 1);
                        if (lval2 != null && lval2.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval2.value, "database")) {
                            lval2.value = "cur_database";
                        }
                    } else if (StringUtil.equals(lval1.value, "?")) {
                        lval2 = SQLProcessor.next(lvalList, lval1.position + 1);
                        if (lval2 != null && lval2.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval2.value, "=")) {
                            LVal lval3 = SQLProcessor.next(lvalList, lval2.position + 1);
                            if (lval3 != null && lval3.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval3.value, "call")) {
                                stack.push(true);
                                lval3.value = "";
                                lval3.type = LVal.Type.WHITESPACE_OR_COMMENT;
                            } else {
                                stack.push(false);
                                nsql.append(lval0.value);
                            }
                        } else {
                            stack.push(false);
                            nsql.append(lval0.value);
                        }
                    } else {
                        stack.push(false);
                        nsql.append(lval0.value);
                    }
                } else if (StringUtil.equals(lval0.value, "}")) {
                    if (stack.isEmpty() || !((Boolean)stack.pop()).booleanValue()) {
                        nsql.append(lval0.value);
                    }
                } else if (keywordMap != null && keywordMap.containsKey(lval0.value.toUpperCase())) {
                    nsql.append("\"" + StringUtil.processDoubleQuoteOfName(lval0.value.toUpperCase()) + "\"");
                } else {
                    nsql.append(lval0.value);
                }
            } else if (lval0.type == LVal.Type.STRING) {
                nsql.append("'" + StringUtil.processSingleQuoteOfName(lval0.value) + '\'');
            } else {
                nsql.append(lval0.value);
            }
            ++i2;
        }
        return nsql.toString();
    }

    private static LVal next(List<LVal> lvalList, int start) {
        LVal lval = null;
        int size = lvalList.size();
        int i2 = start;
        while (i2 < size) {
            lval = lvalList.get(i2);
            if (lval.type != LVal.Type.WHITESPACE_OR_COMMENT) break;
            ++i2;
        }
        return lval;
    }

    public static String execOpt(String sql, List<SQLParameter> paramList, Charset serverEncoding, boolean notAllowOrgParam, boolean backSlashFlag, Map<Integer, Integer> indexMap) throws Exception {
        try {
            StringBuilder nsql = new StringBuilder();
            List<LVal> lvalList = SQLProcessor.lex(sql);
            if (lvalList.isEmpty()) {
                return sql;
            }
            for (LVal lVal : lvalList) {
                String firstWord;
                if (lVal.type == LVal.Type.WHITESPACE_OR_COMMENT || (firstWord = lVal.value).equalsIgnoreCase("EXPLAIN")) continue;
                if (firstWord.equalsIgnoreCase("INSERT") || firstWord.equalsIgnoreCase("SELECT") || firstWord.equalsIgnoreCase("UPDATE") || firstWord.equalsIgnoreCase("DELETE") || firstWord.equalsIgnoreCase("CALL")) break;
                return sql;
            }
            int breakIndex = 0;
            int index = 1;
            int realIndex = 1;
            for (LVal lval : lvalList) {
                if (paramList.size() > 65536) {
                    paramList.clear();
                    return sql;
                }
                switch (lval.type) {
                    case INT: {
                        nsql.append("?");
                        Number value = new Long(lval.value);
                        if ((Long)value <= Integer.MAX_VALUE && (Long)value >= Integer.MIN_VALUE) {
                            paramList.add(new SQLParameter(index++, J2DB.toInt((Long)value), 7, 4));
                            break;
                        }
                        paramList.add(new SQLParameter(index++, J2DB.toBigint((Long)value), 8, 8));
                        break;
                    }
                    case DOUBLE: {
                        nsql.append("?");
                        Number value = new Double(lval.value);
                        paramList.add(new SQLParameter(index++, J2DB.toDouble((Double)value), 11, 8));
                        break;
                    }
                    case DECIMAL: {
                        nsql.append("?");
                        paramList.add(new SQLParameter(index++, J2DB.toDecimal(lval.value, 0, 0, false), 9, 0));
                        break;
                    }
                    case STRING: {
                        if (lval.value.length() > Short.MAX_VALUE) {
                            nsql.append("'" + StringUtil.processSingleQuoteOfName(lval.value) + "'");
                            break;
                        }
                        nsql.append("?");
                        if (backSlashFlag) {
                            lval.value = StringUtil.unescapeJava(lval.value);
                        }
                        paramList.add(new SQLParameter(index++, ByteUtil.fromString(lval.value, serverEncoding), 2, Short.MAX_VALUE));
                        break;
                    }
                    case HEX_INT: {
                        nsql.append(lval.value);
                        break;
                    }
                    default: {
                        if (lval.type == LVal.Type.NORMAL && (lval.value.equalsIgnoreCase("group") || lval.value.equalsIgnoreCase("order"))) {
                            breakIndex = lval.position;
                            nsql.append(lval.value);
                            break;
                        }
                        if (notAllowOrgParam && StringUtil.isNotEmpty(lval.value) && (lval.value.contains("?") || lval.value.contains(":"))) {
                            indexMap.put(realIndex++, index++);
                        }
                        nsql.append(lval.value);
                    }
                }
                if (breakIndex > 0) break;
            }
            if (breakIndex > 0) {
                int i2 = breakIndex + 1;
                while (i2 < lvalList.size()) {
                    nsql.append(lvalList.get((int)i2).value);
                    ++i2;
                }
            }
            return nsql.toString();
        }
        catch (Exception e2) {
            paramList.clear();
            throw e2;
        }
    }

    public static String execOptFe(String sql, List<FeSQLParameter> paramList, Charset serverEncoding, Map<Integer, Integer> indexMap) throws Exception {
        try {
            StringBuilder nsql = new StringBuilder();
            List<LVal> lvalList = SQLProcessor.lex(sql.trim());
            if (lvalList.isEmpty()) {
                return sql;
            }
            String firstWord = "";
            for (LVal lVal : lvalList) {
                if (lVal.type == LVal.Type.WHITESPACE_OR_COMMENT) continue;
                firstWord = lVal.value;
                break;
            }
            if (!firstWord.equalsIgnoreCase("INSERT") && !firstWord.equalsIgnoreCase("SELECT") && !firstWord.equalsIgnoreCase("UPDATE") && !firstWord.equalsIgnoreCase("DELETE") || firstWord.equalsIgnoreCase("EXPLAIN")) {
                return sql;
            }
            int breakIndex = 0;
            int index = 1;
            int realIndex = 1;
            boolean negative = false;
            boolean beforeNum = false;
            for (LVal lval : lvalList) {
                if (paramList.size() > 65536) {
                    paramList.clear();
                    return sql;
                }
                switch (lval.type) {
                    case INT: {
                        beforeNum = true;
                        nsql.append("?");
                        Number value = null;
                        try {
                            value = new Long(lval.value);
                        }
                        catch (Exception exception) {
                            if (negative) {
                                negative = false;
                                lval.value = "-" + lval.value;
                            }
                            paramList.add(new FeSQLParameter(index++, lval.value, J2DB.toVarchar(lval.value, serverEncoding), 2, Short.MAX_VALUE));
                            break;
                        }
                        if (negative) {
                            negative = false;
                            value = -((Long)value).longValue();
                        }
                        if ((Long)value <= Integer.MAX_VALUE && (Long)value >= Integer.MIN_VALUE) {
                            paramList.add(new FeSQLParameter(index++, value, J2DB.toInt((Long)value), 7, 4));
                            break;
                        }
                        paramList.add(new FeSQLParameter(index++, value, J2DB.toBigint((Long)value), 8, 8));
                        break;
                    }
                    case DOUBLE: {
                        beforeNum = true;
                        nsql.append("?");
                        Number value = new Double(lval.value);
                        if (negative) {
                            negative = false;
                            value = -((Double)value).doubleValue();
                        }
                        paramList.add(new FeSQLParameter(index++, value, J2DB.toDouble((Double)value), 11, 8));
                        break;
                    }
                    case DECIMAL: {
                        beforeNum = true;
                        nsql.append("?");
                        if (negative) {
                            negative = false;
                            lval.value = "-" + lval.value;
                        }
                        paramList.add(new FeSQLParameter(index++, lval.value, J2DB.toDecimal(lval.value, 0, 0, true), 9, 0));
                        break;
                    }
                    case STRING: {
                        beforeNum = false;
                        nsql.append("?");
                        paramList.add(new FeSQLParameter(index++, lval.value, ByteUtil.fromString(lval.value, serverEncoding), 2, Short.MAX_VALUE));
                        break;
                    }
                    case HEX_INT: {
                        beforeNum = false;
                        if (lval.value != null && !lval.value.toUpperCase().startsWith("0X")) {
                            DBError.EC_PARSE_ERROR.throwz(new Object[0]);
                        }
                        nsql.append("?");
                        byte[] bytes = StringUtil.hexStringToBytes(lval.value);
                        FeSQLParameter feSQLParameter = new FeSQLParameter(index++, lval.value, bytes, 18, Short.MAX_VALUE);
                        feSQLParameter.hexFlag = true;
                        paramList.add(feSQLParameter);
                        break;
                    }
                    default: {
                        if (StringUtil.equals(lval.value, "?")) {
                            indexMap.put(realIndex++, index++);
                            if (negative) {
                                negative = false;
                                beforeNum = false;
                                nsql.append("-");
                            }
                            nsql.append(lval.value);
                            break;
                        }
                        if (StringUtil.equals(lval.value, ":")) {
                            indexMap.put(realIndex++, index++);
                            break;
                        }
                        if (StringUtil.equals(lval.value, "-")) {
                            if (!beforeNum) {
                                negative = true;
                                break;
                            }
                            negative = false;
                            beforeNum = false;
                            nsql.append(lval.value);
                            break;
                        }
                        if (lval.value != null && !keywordSet.contains(lval.value.toUpperCase())) {
                            beforeNum = true;
                            if (negative) {
                                negative = false;
                                nsql.append("-");
                            }
                        } else if (lval.value != null && !lval.value.equals(" ")) {
                            beforeNum = false;
                        }
                        nsql.append(lval.value);
                    }
                }
                if (breakIndex > 0) break;
            }
            if (breakIndex > 0) {
                int i2 = breakIndex + 1;
                while (i2 < lvalList.size()) {
                    nsql.append(lvalList.get((int)i2).value);
                    ++i2;
                }
            }
            return nsql.toString();
        }
        catch (Exception e2) {
            paramList.clear();
            throw e2;
        }
    }

    public static boolean hasConst(String sql) throws IOException {
        List<LVal> lvalList = SQLProcessor.lex(sql);
        if (lvalList.isEmpty()) {
            return false;
        }
        for (LVal lval : lvalList) {
            switch (lval.type) {
                case INT: 
                case DOUBLE: 
                case DECIMAL: 
                case STRING: 
                case HEX_INT: 
                case NULL: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String toMysql(String sql) throws IOException {
        StringBuilder nsql = new StringBuilder(sql.length());
        List<LVal> wordList = SQLProcessor.mysqlLex(sql);
        for (LVal lval : wordList) {
            if (lval.type == LVal.Type.DOUBLE_QUOTE_STRING) {
                String temp = lval.value;
                temp = "'" + StringUtil.processSingleQuoteOfName(temp) + "'";
                nsql.append(temp);
                continue;
            }
            if (lval.type == LVal.Type.STRING) {
                nsql.append(lval.value);
                continue;
            }
            nsql.append(lval.value);
        }
        return nsql.toString();
    }

    public static List<LVal> mysqlLex(String sql) throws IOException {
        LVal lval;
        MysqlLexer lexer = new MysqlLexer(new StringReader(sql), false);
        int position = 0;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            lvalList.add(lval);
        }
        return lvalList;
    }

    public static void main(String[] args) throws Exception {
        ArrayList paramList = new ArrayList();
        String sql = "create table test2(c1 int, c2 varchar, c3 blob)";
        System.out.println(sql);
        System.out.println("--------------");
        System.out.println("--------------");
        System.out.println(paramList);
    }
}

