/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.enums.ENCODING;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.TimeZone;

public class Const {
    public static final String VERSION_SERVER_LOWEST = "7.0.0.9";
    public static final String VERSION_SERVER_MALINI2 = "8.0.0.73";
    public static final String VERSION_SERVER_EXECUTE2 = "7.1.2.128";
    public static final String VERSION_SERVER_LOB_EMPTY_COMP_ORCL = "7.1.5.144";
    public static final String VERSION_SERVER_LOB_OPTIMIZED = "7.1.3.44";
    public static final String VERSION_SERVER_LOB_GET_DATA_ARR = "7.1.6.123";
    public static final int SERVER_SERIES_UNDEFINED = 0;
    public static final int SERVER_SERIES_PERSONAL = 1;
    public static final int SERVER_SERIES_STANDARD = 2;
    public static final int SERVER_SERIES_ENTERPRISE = 3;
    public static final int SERVER_SERIES_CLOUD = 4;
    public static final int SERVER_SERIES_SECURITY = 5;
    public static final int SERVER_SERIES_TRUSTED = 6;
    public static final int SERVER_SERIES_DEVELOP = 7;
    public static final int SERVER_SERIES_CUSTOM = 8;
    public static final int SERVER_SERIES_GATEWAY = Integer.MAX_VALUE;
    public static final int SESS3_CLT_JDBC = 2;
    public static final String HOST_NAME = DriverUtil.getHostMchName();
    public static final int PORT_DEFAULT = 5236;
    public static final short TIME_ZONE_DEFAULT = (short)(TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 60000);
    public static final int LANGUAGE_CN = 0;
    public static final int LANGUAGE_EN = 1;
    public static final int LANGUAGE_CN_HK = 2;
    public static final int LANGUAGE_CN_TW = 3;
    public static final int ENCRYPT_MODE_SSL = 1;
    public static final int ENCRYPT_MODE_SSL_AUTH_ONLY = 2;
    public static final int ENCRYPT_MODE_GMSSL = 3;
    public static final int ENCRYPT_MODE_WITHOUT_AUTH = 4;
    public static final int MSG_COMPRESS_THRESHOLD = 8192;
    public static final int MSG_COMPRESS_SIMPLE = 1;
    public static final int MSG_COMPRESS_AUTO = 2;
    public static final int MSG_COMPRESS_NO = 0;
    public static final byte MSG_CPR_FUN_ID_ZIP = 0;
    public static final byte MSG_CPR_FUN_ID_SNAPPY = 1;
    public static final byte MSG_CPR_FUN_ID_NONE = -1;
    public static final int MAX_NAME_LEN = 128;
    public static final int MAX_PATH_LEN = 256;
    public static final int MAX_DEC_LEN = 38;
    public static final int MAX_PARAM_DATA_LEN = 65280;
    public static final int DATA_LOB_CTL_LEN = 65531;
    public static final int DATA_LOB_EMPTY_LEN = 65530;
    public static final int DATA_NULL_LEN = 65534;
    public static final int DATA_NULL_LEN2 = 65533;
    public static final int DATA_FULL_LEN = 65535;
    public static final long DATA_LEN_4BYTE = 0xFFFFFFFFL;
    public static final int BYTE_SIZE = 1;
    public static final int USINT_SIZE = 2;
    public static final int ULINT_SIZE = 4;
    public static final int DDWORD_SIZE = 8;
    public static final int LINT64_SIZE = 8;
    public static final int ROWID_SIZE = 12;
    public static final int ULINT_UNDEFINED = -1;
    public static final int REC4_DELETE_MASK = 128;
    public static final byte REC4_ROWID_MASK = 96;
    public static final int REC4_SQL_NULL = 65534;
    public static final int REC4_SQL_NULL2 = 65533;
    public static final int REC4_SQL_FULL = 65535;
    public static final short REC4_FLD_FULL = 0;
    public static final short REC4_FLD_NULL = 3;
    public static final int REC4_1BYTE_LEN_MASK = 128;
    public static final int IGNORE_TARGET_LENGTH = -1;
    public static final int IGNORE_TARGET_SCALE = -1;
    public static final int IGNORE_TARGET_TYPE = Integer.MIN_VALUE;
    public static final int SERVER_MODE_NORMAL = 0;
    public static final int SERVER_MODE_PRIMARY = 1;
    public static final int SERVER_MODE_STANDBY = 2;
    public static final int SERVER_STATUS_MOUNT = 3;
    public static final int SERVER_STATUS_OPEN = 4;
    public static final int SERVER_STATUS_SUSPEND = 5;
    public static final byte TRX_ACCESS_MODE_READ_WRITE = 0;
    public static final byte TRX_ACCESS_MODE_READ_ONLY = 1;
    public static final int TRX_STATUS_NOT_START = 0;
    public static final int TRX_STATUS_COMMITTED = 32;
    public static final int TRX_STATUS_ROLLBACKED = 64;
    public static final int TRX_STATUS_STATE_MASK = 4095;
    public static final int ISO_LEVEL_READ_UNCOMMITTED = 0;
    public static final int ISO_LEVEL_READ_COMMITTED = 1;
    public static final int ISO_LEVEL_REPEATABLE_READ = 2;
    public static final int ISO_LEVEL_SERIALIZABLE = 3;
    public static final short EXECUTE_TYPE_ANY = 0;
    public static final short EXECUTE_TYPE_QUERY = 1;
    public static final short EXECUTE_TYPE_UPDATE = 2;
    public static final short EXECUTE_TYPE_CALL = 3;
    public static final short EXECUTE_TYPE_SET_DB = 4;
    public static final int SQL_TYPE_BASE = 127;
    public static final int SQL_TYPE_DDL_CDB = 128;
    public static final int SQL_TYPE_DDL_CTAB = 129;
    public static final int SQL_TYPE_DDL_DTAB = 130;
    public static final int SQL_TYPE_DDL_CVIEW = 131;
    public static final int SQL_TYPE_DDL_DVIEW = 132;
    public static final int SQL_TYPE_DDL_CIND = 133;
    public static final int SQL_TYPE_DDL_DIND = 134;
    public static final int SQL_TYPE_DDL_CUSR = 135;
    public static final int SQL_TYPE_DDL_DUSR = 136;
    public static final int SQL_TYPE_DDL_CROL = 137;
    public static final int SQL_TYPE_DDL_DROL = 138;
    public static final int SQL_TYPE_DDL_DROP = 139;
    public static final int SQL_TYPE_DDL_ALTDB = 140;
    public static final int SQL_TYPE_DDL_ALTUSR = 141;
    public static final int SQL_TYPE_DDL_CFUNC = 142;
    public static final int SQL_TYPE_DDL_CPROC = 143;
    public static final int SQL_TYPE_DDL_GRANT = 144;
    public static final int SQL_TYPE_DDL_REVOKE = 145;
    public static final int SQL_TYPE_DDL_ALTTAB = 146;
    public static final int SQL_TYPE_COMMIT = 147;
    public static final int SQL_TYPE_ROLLBACK = 148;
    public static final int SQL_TYPE_EXPLAIN = 149;
    public static final int SQL_TYPE_SET_TRAN = 150;
    public static final int SQL_TYPE_SAVEPNT = 151;
    public static final int SQL_TYPE_SET_CURDB = 152;
    public static final int SQL_TYPE_SET_CURSCH = 153;
    public static final int SQL_TYPE_LOCK_TAB = 154;
    public static final int SQL_TYPE_DDL_AUDIT = 155;
    public static final int SQL_TYPE_DML_INSERT = 157;
    public static final int SQL_TYPE_DML_DELETE = 158;
    public static final int SQL_TYPE_DML_UPDATE = 159;
    public static final int SQL_TYPE_DML_SELECT = 160;
    public static final int SQL_TYPE_DML_SELECT_INTO = 161;
    public static final int SQL_TYPE_DML_CALL = 162;
    public static final int SQL_TYPE_LOGIN = 163;
    public static final int SQL_TYPE_DML_MERGE = 164;
    public static final int SQL_TYPE_SET_TIME_ZONE = 165;
    public static final int SQL_TYPE_SET_SESS_TRAN = 166;
    public static final int SQL_TYPE_FETCH_NOT_OVER = 167;
    public static final int SQL_TYPE_EXEC_PROC = 178;
    public static final int SQL_TYPE_SIMPLE = 187;
    public static final int SQL_TYPE_DDL_CSCHEMA = 188;
    public static final int SQL_TYPE_PLAN_ERRCODE = 189;
    public static final int SQL_TYPE_DDL_ALTTRIG = 190;
    public static final int SQL_TYPE_DDL_DROP_TABLE = 191;
    public static final int SQL_TYPE_DDL_DROP_INDEX = 192;
    public static final int SQL_TYPE_DDL_DROP_VIEW = 193;
    public static final int SQL_TYPE_DML_TRCT = 194;
    public static final int SQL_TYPE_SET_IDENTINS = 195;
    public static final int SQL_TYPE_DDL_CSEQ = 196;
    public static final int SQL_TYPE_DML_CURSOR_DECLARE = 197;
    public static final int SQL_TYPE_DML_CURSOR_OPEN = 198;
    public static final int SQL_TYPE_DML_CURSOR_CLOSE = 199;
    public static final int SQL_TYPE_DML_CURSOR_UPDATE = 200;
    public static final int SQL_TYPE_DML_CURSOR_DELETE = 201;
    public static final int SQL_TYPE_DML_CURSOR_FETCH = 202;
    public static final int SQL_TYPE_DML_CURSOR_SEEK = 203;
    public static final int SQL_TYPE_DDL_CLGN = 204;
    public static final int SQL_TYPE_DDL_ALTLGN = 205;
    public static final int SQL_TYPE_DDL_CCONIND = 206;
    public static final int SQL_TYPE_DDL_DCONIND = 207;
    public static final int SQL_TYPE_DDL_ALTCONIND = 208;
    public static final int SQL_TYPE_STARTUP = 228;
    public static final int SQL_TYPE_DDL_ALTSESS_DATEFMT = 251;
    public static final int SQL_TYPE_DDL_ALTSESS_TIMEFMT = 252;
    public static final int SQL_TYPE_DDL_ALTSESS_DTFMT = 253;
    public static final int SQL_TYPE_DDL_ALTSESS_DTTZFMT = 254;
    public static final int SQL_TYPE_DDL_ALTSESS_TIMETZFMT = 255;
    public static final int SQL_TYPE_DDL_ALTSESS_DATE_LANGUAGE = 256;
    public static final int SQL_TYPE_NLS_NUMERIC_CHARACTERS = 271;
    public static final byte RS_ROW = 0;
    public static final byte RS_BDTA = 2;
    public static final int XA_TYPE_COMMIT = 1;
    public static final int XA_TYPE_END = 2;
    public static final int XA_TYPE_FORGET = 3;
    public static final int XA_TYPE_PREPARE = 4;
    public static final int XA_TYPE_RECOVERY = 5;
    public static final int XA_TYPE_ROLLBACK = 6;
    public static final int XA_TYPE_START = 7;
    public static final int XA_TYPE_HEURCOM = 8;
    public static final int XA_TYPE_HEURRB = 9;
    public static final int BLDR_DIS_TYPE_NORMAL = 0;
    public static final int BLDR_DIS_TYPE_RAND_DIS = 1;
    public static final int BLDR_DIS_TYPE_HASH_DIS = 2;
    public static final int BLDR_DIS_TYPE_RANGE_DIS = 3;
    public static final int BLDR_DIS_TYPE_LIST_DIS = 4;
    public static final int BLDR_DIS_TYPE_FULL_DIS = 5;
    public static final int GET_DATA_ARR_MAX_SIZE = 129000000;

    public static int j2dbLanguage(Locale locale) {
        if (StringUtil.equals(locale.getLanguage(), "zh")) {
            if (StringUtil.equalsIgnoreCase(locale.getCountry(), "hk") || StringUtil.equalsIgnoreCase(locale.getCountry(), "tw")) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    public static Locale db2jLanguage(int language) {
        switch (language) {
            case 0: {
                return Locale.CHINA;
            }
            case 2: {
                return new Locale("zh", "HK");
            }
            case 3: {
                return Locale.TAIWAN;
            }
            case 1: {
                return new Locale("", "");
            }
        }
        return Locale.CHINA;
    }

    public static Charset checkTraditionalChinese(Charset serverEncoding) {
        if (DmSvcConf.GLOBAL.getLanguage() == 2) {
            serverEncoding = serverEncoding.equals(ENCODING.UTF8.charset()) ? serverEncoding : ENCODING.BIG5.charset();
        }
        return serverEncoding;
    }

    public static boolean hasUpdateCount(int sqlType) {
        return sqlType == 158 || sqlType == 157 || sqlType == 159;
    }

    public static final int db2jIsoLevel(int isoLevel) {
        switch (isoLevel) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    public static final int j2dbIsoLevel(int isoLevel) {
        switch (isoLevel) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return -1;
    }

    public static int j2dbParameterMode(int jmode) {
        int dbmode = 0;
        switch (jmode) {
            case 1: {
                dbmode = 0;
                break;
            }
            case 4: {
                dbmode = 1;
                break;
            }
            case 2: {
                dbmode = 2;
            }
        }
        return dbmode;
    }

    public static int j2dbParameterNullable(int jnullable) {
        int dbnullable = 0;
        switch (jnullable) {
            case 1: {
                dbnullable = 1;
                break;
            }
        }
        return dbnullable;
    }

    public static boolean isTrxFinish(int trxStatus) {
        switch (trxStatus & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                return true;
            }
        }
        return false;
    }
}

