/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.SQLName;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.buffer.Buffer;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ComplexTypeDesc
implements Serializable {
    public static final int OBJ_BLOB_MAGIC = 78111999;
    public static final int CLTN_TYPE_IND_TABLE = 3;
    public static final int CLTN_TYPE_NST_TABLE = 2;
    public static final int CLTN_TYPE_VARRAY = 1;
    private static final long serialVersionUID = 1L;
    public Column column = new Column();
    public SQLName m_sqlName = null;
    int m_objId = -1;
    int m_objVersion = -1;
    int m_outerId = 0;
    int m_outerVer = 0;
    int m_subId = 0;
    int m_cltnType = 0;
    int m_maxCnt = 0;
    public ComplexTypeDesc m_arrObj = null;
    public ComplexTypeDesc[] m_fieldsObj = null;
    int m_size = 0;
    public DmdbConnection m_conn = null;
    private Charset m_serverEncoding = null;
    byte[] m_descBuf = null;
    public ComplexTypeDesc m_keyDesc = null;
    public ComplexTypeDesc m_valueDesc = null;
    public DmdbResultSetMetaData metaData = null;

    public ComplexTypeDesc(String fulName, Connection conn) throws SQLException {
        if (!(conn instanceof DmdbConnection)) {
            DBError.ECJDBC_INVALID_DM_CONNECT.throwz(new Object[0]);
        }
        if (StringUtil.isEmpty(fulName)) {
            DBError.ECJDBC_INVALID_COMPLEX_TYPE_NAME.throwz(new Object[0]);
        }
        this.m_sqlName = new SQLName(fulName);
        this.m_conn = (DmdbConnection)conn;
        this.parseDescByName();
    }

    public ComplexTypeDesc(DmdbConnection conn) {
        this.m_sqlName = new SQLName(conn);
        this.m_conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        DmdbConnection dmdbConnection = this.m_conn;
        synchronized (dmdbConnection) {
            if (this.metaData != null) {
                return this.metaData;
            }
            Column[] columns = null;
            switch (this.column.type) {
                case 119: 
                case 121: {
                    columns = new Column[this.m_fieldsObj.length];
                    int i2 = 0;
                    while (i2 < this.m_fieldsObj.length) {
                        columns[i2] = this.m_fieldsObj[i2].column;
                        ++i2;
                    }
                    this.metaData = new DmdbResultSetMetaData(this.m_conn, columns);
                    break;
                }
                default: {
                    this.metaData = new DmdbResultSetMetaData(this.m_conn, new Column[]{this.column});
                    return this.metaData;
                }
            }
            try {
                DmdbResultSet rs = DriverUtil.executeQuery(this.m_conn, "/*DMJDBC*/SELECT ATTR_NAME, (ATTR_NO - 1), ATTR_TYPE_NAME FROM SYSTYPEATTRINFO WHERE OID = ?;", new Object[]{this.m_objId});
                while (rs.do_next()) {
                    Column col = columns[rs.do_getInt(2)];
                    col.name = rs.do_getString(1);
                    String typeName = rs.do_getString(3);
                    if (!StringUtil.isNotEmpty(typeName)) continue;
                    col.typeName = typeName;
                }
                rs.do_close();
            }
            catch (Exception exception) {}
            return this.metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDescByName() throws SQLException {
        DmdbConnection dmdbConnection = this.m_conn;
        synchronized (dmdbConnection) {
            String sql = "/*DMJDBC*/ BEGIN ? = SF_DESCRIBE_TYPE(?); END;";
            Object[] inParams = new Object[2];
            inParams[1] = this.m_sqlName.m_fulName;
            Integer[] outParamTypes = new Integer[2];
            outParamTypes[0] = 2004;
            Object[] outParams = DriverUtil.executePrepareCall(this.m_conn, sql, inParams, outParamTypes);
            DmdbBlob blob = (DmdbBlob)outParams[0];
            byte[] buf = blob.do_getBytes(1L, (int)blob.do_length());
            this.m_serverEncoding = this.m_conn.getServerEncoding();
            this.unpack(Buffer.wrap(buf, false, this.m_conn.bufferType));
        }
    }

    public String getFulName() throws SQLException {
        return this.m_sqlName.getFulName();
    }

    public int getDType() {
        return this.column.type;
    }

    public int getPrec() {
        return this.column.prec;
    }

    public int getScale() {
        return this.column.scale;
    }

    public Charset getServerEncoding() {
        return this.m_serverEncoding == null ? this.m_conn.getServerEncoding() : this.m_serverEncoding;
    }

    public int getObjId() {
        return this.m_objId;
    }

    public int getOuterId() {
        return this.m_outerId;
    }

    public int getCltnType() {
        return this.m_cltnType;
    }

    public int getMaxCnt() {
        return this.m_maxCnt;
    }

    private static int getPackSize(ComplexTypeDesc typeDesc) {
        int len = 0;
        switch (typeDesc.column.type) {
            case 117: 
            case 122: {
                return ComplexTypeDesc.getPackArraySize(typeDesc);
            }
            case 119: {
                return ComplexTypeDesc.getPackClassSize(typeDesc);
            }
            case 121: {
                return ComplexTypeDesc.getPackRecordSize(typeDesc);
            }
        }
        len += 4;
        len += 4;
        return len += 4;
    }

    private static void pack(ComplexTypeDesc typeDesc, Buffer msg) {
        switch (typeDesc.column.type) {
            case 117: 
            case 122: {
                ComplexTypeDesc.packArray(typeDesc, msg);
                return;
            }
            case 119: {
                ComplexTypeDesc.packClass(typeDesc, msg);
                return;
            }
            case 121: {
                ComplexTypeDesc.packRecord(typeDesc, msg);
                return;
            }
        }
        msg.writeInt(typeDesc.column.type);
        msg.writeInt(typeDesc.column.prec);
        msg.writeInt(typeDesc.column.scale);
    }

    public static int getPackArraySize(ComplexTypeDesc arrDesc) {
        int len = 0;
        len += 4;
        String name = arrDesc.m_sqlName.m_name;
        len += 2;
        byte[] ret = ByteUtil.fromString(name, arrDesc.getServerEncoding());
        len += ret.length;
        len += 4;
        len += 4;
        len += 4;
        return len += ComplexTypeDesc.getPackSize(arrDesc.m_arrObj);
    }

    public static void packArray(ComplexTypeDesc arrDesc, Buffer msg) {
        msg.writeInt(arrDesc.column.type);
        msg.writeStringWithLength2(arrDesc.m_sqlName.m_name, arrDesc.getServerEncoding());
        msg.writeInt(arrDesc.m_objId);
        msg.writeInt(arrDesc.m_objVersion);
        msg.writeInt(arrDesc.getSize());
        ComplexTypeDesc.pack(arrDesc.m_arrObj, msg);
    }

    public static void packRecord(ComplexTypeDesc strctDesc, Buffer msg) {
        msg.writeInt(strctDesc.column.type);
        msg.writeStringWithLength2(strctDesc.m_sqlName.m_name, strctDesc.getServerEncoding());
        msg.writeInt(strctDesc.m_objId);
        msg.writeInt(strctDesc.m_objVersion);
        msg.writeShort((short)strctDesc.m_size);
        int i2 = 0;
        while (i2 < strctDesc.m_size) {
            ComplexTypeDesc.pack(strctDesc.m_fieldsObj[i2], msg);
            ++i2;
        }
    }

    public static int getPackRecordSize(ComplexTypeDesc strctDesc) {
        int len = 0;
        len += 4;
        String name = strctDesc.m_sqlName.m_name;
        len += 2;
        byte[] ret = ByteUtil.fromString(name, strctDesc.getServerEncoding());
        len += ret.length;
        len += 4;
        len += 4;
        len += 2;
        int i2 = 0;
        while (i2 < strctDesc.m_size) {
            len += ComplexTypeDesc.getPackSize(strctDesc.m_fieldsObj[i2]);
            ++i2;
        }
        return len;
    }

    public static int getPackClassSize(ComplexTypeDesc strctDesc) {
        int len = 0;
        len += 4;
        String name = strctDesc.m_sqlName.m_name;
        len += 2;
        byte[] ret = ByteUtil.fromString(name, strctDesc.getServerEncoding());
        len += ret.length;
        len += 4;
        len += 4;
        if (strctDesc.m_objId == 4) {
            len += 4;
            len += 4;
            len += 2;
        }
        return len;
    }

    public static void packClass(ComplexTypeDesc strctDesc, Buffer msg) {
        msg.writeInt(strctDesc.column.type);
        msg.writeStringWithLength2(strctDesc.m_sqlName.m_name, strctDesc.getServerEncoding());
        msg.writeInt(strctDesc.m_objId);
        msg.writeInt(strctDesc.m_objVersion);
        if (strctDesc.m_objId == 4) {
            msg.writeInt(strctDesc.m_outerId);
            msg.writeInt(strctDesc.m_outerVer);
            msg.writeUB2(strctDesc.m_subId);
        }
    }

    public void unpack(Buffer buffer) throws SQLException {
        this.column.type = buffer.readInt();
        switch (this.column.type) {
            case 117: 
            case 122: {
                this.unpackArray(buffer);
                return;
            }
            case 119: {
                this.unpackClass(buffer);
                return;
            }
            case 121: {
                this.unpackRecord(buffer);
                return;
            }
        }
        this.column.prec = buffer.readInt();
        this.column.scale = buffer.readInt();
    }

    private void unpackArray(Buffer buffer) throws SQLException {
        this.m_sqlName.m_name = buffer.readStringWithLength2(this.getServerEncoding());
        this.m_sqlName.m_schId = buffer.readInt();
        this.m_sqlName.m_packId = buffer.readInt();
        this.m_objId = buffer.readInt();
        this.m_objVersion = buffer.readInt();
        this.m_size = buffer.readInt();
        if (this.column.type == 117) {
            this.m_size = 0;
        }
        this.m_arrObj = new ComplexTypeDesc(this.m_conn);
        this.m_arrObj.unpack(buffer);
    }

    private void unpackRecord(Buffer buffer) throws SQLException {
        this.m_sqlName.m_name = buffer.readStringWithLength2(this.getServerEncoding());
        this.m_sqlName.m_schId = buffer.readInt();
        this.m_sqlName.m_packId = buffer.readInt();
        this.m_objId = buffer.readInt();
        this.m_objVersion = buffer.readInt();
        this.m_size = buffer.readUB2();
        this.m_fieldsObj = new ComplexTypeDesc[this.m_size];
        int i2 = 0;
        while (i2 < this.m_size) {
            this.m_fieldsObj[i2] = new ComplexTypeDesc(this.m_conn);
            this.m_fieldsObj[i2].unpack(buffer);
            ++i2;
        }
    }

    private void unpackCltn_nestTab(Buffer buffer) throws SQLException {
        this.m_maxCnt = buffer.readInt();
        this.m_arrObj = new ComplexTypeDesc(this.m_conn);
        this.m_arrObj.unpack(buffer);
    }

    private void unpackCltn_indexTab(Buffer buffer) throws SQLException {
        this.m_maxCnt = buffer.readInt();
        this.m_keyDesc = new ComplexTypeDesc(this.m_conn);
        this.m_keyDesc.unpack(buffer);
        this.m_valueDesc = new ComplexTypeDesc(this.m_conn);
        this.m_valueDesc.unpack(buffer);
    }

    private void unpackCltn(Buffer buffer) throws SQLException {
        this.m_outerId = buffer.readInt();
        this.m_outerVer = buffer.readInt();
        this.m_subId = buffer.readUB2();
        this.m_cltnType = buffer.readUB2();
        switch (this.m_cltnType) {
            case 3: {
                this.unpackCltn_indexTab(buffer);
                break;
            }
            case 1: 
            case 2: {
                this.unpackCltn_nestTab(buffer);
            }
        }
    }

    private void unpackClass(Buffer buffer) throws SQLException {
        this.m_sqlName.m_name = buffer.readStringWithLength2(this.getServerEncoding());
        this.m_sqlName.m_schId = buffer.readInt();
        this.m_sqlName.m_packId = buffer.readInt();
        this.m_objId = buffer.readInt();
        this.m_objVersion = buffer.readInt();
        if (this.m_objId == 4) {
            this.unpackCltn(buffer);
        } else {
            this.m_size = buffer.readUB2();
            this.m_fieldsObj = new ComplexTypeDesc[this.m_size];
            int i2 = 0;
            while (i2 < this.m_size) {
                this.m_fieldsObj[i2] = new ComplexTypeDesc(this.m_conn);
                this.m_fieldsObj[i2].unpack(buffer);
                ++i2;
            }
        }
    }

    private int calcChkDescLen_array(ComplexTypeDesc desc) throws SQLException {
        int offset = 0;
        offset += 2;
        offset += 4;
        return offset += this.calcChkDescLen(desc.m_arrObj);
    }

    private int calcChkDescLen_record(ComplexTypeDesc desc) throws SQLException {
        int offset = 0;
        offset += 2;
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset += this.calcChkDescLen(desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int calcChkDescLen_class_normal(ComplexTypeDesc desc) throws SQLException {
        int offset = 0;
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset += this.calcChkDescLen(desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int calcChkDescLen_class_cnlt(ComplexTypeDesc desc) throws SQLException {
        int offset = 0;
        offset += 2;
        offset += 4;
        switch (desc.getCltnType()) {
            case 3: {
                offset += this.calcChkDescLen(desc.m_keyDesc);
                offset += this.calcChkDescLen(desc.m_valueDesc);
                break;
            }
            case 1: 
            case 2: {
                offset += this.calcChkDescLen(desc.m_arrObj);
            }
        }
        return offset;
    }

    private int calcChkDescLen_class(ComplexTypeDesc desc) throws SQLException {
        int offset = 0;
        offset += 2;
        ++offset;
        offset = desc.m_objId == 4 ? (offset += this.calcChkDescLen_class_cnlt(desc)) : (offset += this.calcChkDescLen_class_normal(desc));
        return offset;
    }

    private int calcChkDescLen_buildin() {
        int offset = 0;
        offset += 2;
        offset += 2;
        return offset += 2;
    }

    private int calcChkDescLen(ComplexTypeDesc desc) throws SQLException {
        int offset;
        switch (desc.getDType()) {
            case 117: 
            case 122: {
                offset = this.calcChkDescLen_array(desc);
                break;
            }
            case 121: {
                offset = this.calcChkDescLen_record(desc);
                break;
            }
            case 119: {
                offset = this.calcChkDescLen_class(desc);
                break;
            }
            default: {
                offset = this.calcChkDescLen_buildin();
            }
        }
        return offset;
    }

    private int makeChkDesc_array(int offset, ComplexTypeDesc desc) throws SQLException {
        ByteUtil.setShort(this.m_descBuf, offset, (short)117);
        ByteUtil.setInt(this.m_descBuf, offset += 2, desc.getSize());
        offset += 4;
        offset = this.makeChkDesc(offset, desc.m_arrObj);
        return offset;
    }

    private int makeChkDesc_record(int offset, ComplexTypeDesc desc) throws SQLException {
        ByteUtil.setShort(this.m_descBuf, offset, (short)121);
        ByteUtil.setShort(this.m_descBuf, offset += 2, (short)desc.m_size);
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset = this.makeChkDesc(offset, desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int makeChkDesc_buildin(int offset, ComplexTypeDesc desc) {
        short dtype = (short)desc.getDType();
        short prec = 0;
        short scale = 0;
        if (dtype != 12) {
            prec = (short)desc.getPrec();
            scale = (short)desc.getScale();
        }
        ByteUtil.setShort(this.m_descBuf, offset, dtype);
        ByteUtil.setShort(this.m_descBuf, offset += 2, prec);
        ByteUtil.setShort(this.m_descBuf, offset += 2, scale);
        return offset += 2;
    }

    private int makeChkDesc_class_normal(int offset, ComplexTypeDesc desc) throws SQLException {
        ByteUtil.setShort(this.m_descBuf, offset, (short)desc.m_size);
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset = this.makeChkDesc(offset, desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int makeChkDesc_class_cltn(int offset, ComplexTypeDesc desc) throws SQLException {
        ByteUtil.setUB2(this.m_descBuf, offset, (short)desc.m_cltnType);
        ByteUtil.setInt(this.m_descBuf, offset += 2, desc.getMaxCnt());
        offset += 4;
        switch (desc.m_cltnType) {
            case 3: {
                offset = this.makeChkDesc(offset, desc.m_keyDesc);
                offset = this.makeChkDesc(offset, desc.m_valueDesc);
                break;
            }
            case 1: 
            case 2: {
                offset = this.makeChkDesc(offset, desc.m_arrObj);
            }
        }
        return offset;
    }

    private int makeChkDesc_class(int offset, ComplexTypeDesc desc) throws SQLException {
        ByteUtil.setShort(this.m_descBuf, offset, (short)119);
        offset += 2;
        boolean isCltn = false;
        if (desc.m_objId == 4) {
            isCltn = true;
        }
        if (isCltn) {
            ByteUtil.setByte(this.m_descBuf, offset, (byte)1);
        } else {
            ByteUtil.setByte(this.m_descBuf, offset, (byte)0);
        }
        ++offset;
        offset = isCltn ? this.makeChkDesc_class_cltn(offset, desc) : this.makeChkDesc_class_normal(offset, desc);
        return offset;
    }

    private int makeChkDesc(int offset, ComplexTypeDesc subDesc) throws SQLException {
        switch (subDesc.getDType()) {
            case 117: 
            case 122: {
                offset = this.makeChkDesc_array(offset, subDesc);
                break;
            }
            case 121: {
                offset = this.makeChkDesc_record(offset, subDesc);
                break;
            }
            case 119: {
                offset = this.makeChkDesc_class(offset, subDesc);
                break;
            }
            default: {
                offset = this.makeChkDesc_buildin(offset, subDesc);
            }
        }
        return offset;
    }

    public byte[] getClassDescChkInfo() throws SQLException {
        if (this.m_descBuf != null) {
            return this.m_descBuf;
        }
        int len = this.calcChkDescLen(this);
        this.m_descBuf = new byte[len];
        this.makeChkDesc(0, this);
        return this.m_descBuf;
    }

    public int getSize() {
        return this.m_size;
    }
}

