/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.desc.ComplexTypeDesc;
import dm.jdbc.internal.desc.FullEncryptColumn;

public class Column {
    public String typeName = "";
    public int type = 0;
    public int prec = 0;
    public int scale = 0;
    public static final int MASK_ORACLE_DATE = 1;
    public static final int MASK_ORACLE_FLOAT = 2;
    public static final int MASK_BFILE = 3;
    public static final int MASK_LOCAL_DATETIME = 4;
    public int mask = 0;
    public int originalPrec;
    public String name = "";
    public String tableName = "";
    public String schemaName = "";
    public boolean nullable = false;
    public boolean identity = false;
    public boolean readonly = false;
    public String baseName = "";
    public boolean lob = false;
    public int lobTabId;
    public int lobColId;
    public ComplexTypeDesc typeDescriptor = null;
    public boolean isBdta = false;
    public boolean fullEncryptFlag = false;
    public FullEncryptColumn feColumn;

    public static int getMaxTupleLen(Column[] cols, int maxRowSize) {
        int tmp_tuple_len = 0;
        int i2 = 0;
        while (i2 < cols.length) {
            int dType = cols[i2].type;
            if (dType == 12 || dType == 19 || DmdbType.isComplexType(dType, cols[i2].scale)) {
                tmp_tuple_len = maxRowSize;
                break;
            }
            tmp_tuple_len += cols[i2].prec;
            i2 = (short)(i2 + 1);
        }
        if (tmp_tuple_len > maxRowSize) {
            tmp_tuple_len = maxRowSize;
        }
        return tmp_tuple_len += 10 + 2 * cols.length + 8;
    }

    public void reset(Column newColumn) {
        this.baseName = newColumn.baseName;
        this.identity = newColumn.identity;
        this.isBdta = newColumn.isBdta;
        this.lob = newColumn.lob;
        this.lobColId = newColumn.lobColId;
        this.lobTabId = newColumn.lobTabId;
        this.name = newColumn.name;
        this.nullable = newColumn.nullable;
        this.prec = newColumn.prec;
        this.readonly = newColumn.readonly;
        this.scale = newColumn.scale;
        this.schemaName = newColumn.schemaName;
        this.tableName = newColumn.tableName;
        this.type = newColumn.type;
        this.typeDescriptor = newColumn.typeDescriptor;
        this.typeName = newColumn.typeName;
        this.mask = newColumn.mask;
    }

    public String toString() {
        return "[type: " + this.type + ", prec: " + this.prec + ", scale: " + this.scale + "]";
    }

    protected Object clone() {
        Column param = new Column();
        param.reset(this);
        return param;
    }
}

