/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.convert;

import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.util.ByteArrayQueue;
import java.sql.SQLException;

public class OffRowBytesData
extends OffRowData {
    public OffRowBytesData(byte[] obj, IDmdbConnection conn) throws SQLException {
        super(obj, conn, -1L);
        this.init();
    }

    @Override
    public void read(ByteArrayQueue readBytes) throws SQLException {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(readBytes);
        } else if (!this.readOver) {
            byte[] bytes = (byte[])this.obj;
            readBytes.putBytes(bytes, 0, bytes.length);
            this.readOver = true;
        }
    }

    @Override
    public byte[] readAll() throws SQLException {
        return (byte[])this.obj;
    }

    public void reset() {
        if (this.obj != null) {
            this.readOver = false;
            this.buffer.clear();
            byte[] bytes = (byte[])this.obj;
            this.buffer.putBytes(bytes, 0, bytes.length);
            this.readOver = true;
            this.offRow = this.buffer.length() > this.OFF_ROW_LEN;
        }
    }
}

