/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.convert;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbSQLInput;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.ComplexTypeData;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DB2J {
    public static String toString(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        String val = null;
        switch (column.type) {
            case 0: 
            case 1: 
            case 2: {
                val = DB2J.charToString(bytes, column, connection);
                break;
            }
            case 3: 
            case 5: 
            case 13: {
                val = String.valueOf(bytes[0]);
                break;
            }
            case 6: {
                val = String.valueOf(ByteUtil.getShort(bytes, 0));
                break;
            }
            case 7: {
                val = String.valueOf(ByteUtil.getInt(bytes, 0));
                break;
            }
            case 8: {
                val = String.valueOf(ByteUtil.getLong(bytes, 0));
                break;
            }
            case 10: {
                val = String.valueOf(ByteUtil.getFloat(bytes, 0));
                val = DB2J.replaceDecimalPoint(connection, val);
                break;
            }
            case 11: {
                val = String.valueOf(ByteUtil.getDouble(bytes, 0));
                val = DB2J.replaceDecimalPoint(connection, val);
                break;
            }
            case 9: {
                val = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle()).toPlainString();
                val = DB2J.replaceDecimalPoint(connection, val);
                break;
            }
            case 17: 
            case 18: {
                val = StringUtil.bytesToHexString(bytes, false);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(column.type, column.scale)) {
                    val = bytes != null ? DB2J.toComplexType(bytes, column, connection, null).toString() : null;
                    break;
                }
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, true);
                val = StringUtil.bytesToHexString(blob.do_getBytes(1L, (int)blob.do_length()));
                break;
            }
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(bytes, connection, column, true);
                val = clob.do_getSubString(1L, (int)clob.do_length());
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                DmdbTimestamp ts = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
                val = ts.toString(column, connection);
                break;
            }
            case 21: {
                DmdbIntervalDT intvDt = new DmdbIntervalDT(bytes);
                val = intvDt.getDTString();
                break;
            }
            case 20: {
                DmdbIntervalYM intvYm = new DmdbIntervalYM(bytes);
                val = intvYm.toString();
                break;
            }
            case 117: {
                DmdbArray obj = ComplexTypeData.bytesToArray(bytes, null, column.typeDescriptor);
                val = obj.toString();
                break;
            }
            case 122: {
                DmdbArray obj = ComplexTypeData.bytesToSArray(bytes, null, column.typeDescriptor);
                val = obj.toString();
                break;
            }
            case 119: {
                Object obj = ComplexTypeData.bytesToObj(bytes, null, column.typeDescriptor);
                val = obj.toString();
                break;
            }
            case 121: {
                DmdbStruct obj = ComplexTypeData.bytesToRecord(bytes, null, column.typeDescriptor);
                val = ((Object)obj).toString();
                break;
            }
            case 28: {
                val = DmdbRowId.valueOf(bytes).toString();
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static String replaceDecimalPoint(DmdbConnection conn, String value) {
        if (StringUtil.isEmpty(conn.formatNumericChars)) {
            return value;
        }
        return value.replace('.', conn.formatNumericChars.charAt(0));
    }

    public static boolean toBoolean(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        boolean val = false;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes[0] != 0;
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0) != 0;
                break;
            }
            case 7: {
                val = ByteUtil.getInt(bytes, 0) != 0;
                break;
            }
            case 8: {
                val = ByteUtil.getLong(bytes, 0) != 0L;
                break;
            }
            case 10: {
                val = ByteUtil.getFloat(bytes, 0) != 0.0f;
                break;
            }
            case 11: {
                val = ByteUtil.getDouble(bytes, 0) != 0.0;
                break;
            }
            case 9: {
                val = !new DmdbNumeric(bytes, column.prec, column.scale).isZero();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String tval = DB2J.charToString(bytes, column, connection);
                val = ConvertUtil.toBoolean(tval);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static byte toByte(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        byte val = 0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes == null || bytes.length == 0 ? (byte)0 : bytes[0];
                break;
            }
            case 6: {
                short tval = ByteUtil.getShort(bytes, 0);
                val = (byte)tval;
                break;
            }
            case 7: {
                int tval = ByteUtil.getInt(bytes, 0);
                val = (byte)tval;
                break;
            }
            case 8: {
                long tval = ByteUtil.getLong(bytes, 0);
                val = (byte)tval;
                break;
            }
            case 10: {
                float tval = ByteUtil.getFloat(bytes, 0);
                val = (byte)tval;
                break;
            }
            case 11: {
                double tval = ByteUtil.getDouble(bytes, 0);
                val = (byte)tval;
                break;
            }
            case 9: {
                BigDecimal tval = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                val = tval.byteValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = Byte.parseByte(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                long tval = DB2J.binaryToLong(bytes, column, connection);
                val = (byte)tval;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static short toShort(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        short val = 0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes == null || bytes.length == 0 ? (short)0 : bytes[0];
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0);
                break;
            }
            case 7: {
                int tval = ByteUtil.getInt(bytes, 0);
                val = (short)tval;
                break;
            }
            case 8: {
                long tval = ByteUtil.getLong(bytes, 0);
                val = (short)tval;
                break;
            }
            case 10: {
                float tval = ByteUtil.getFloat(bytes, 0);
                val = (short)tval;
                break;
            }
            case 11: {
                double tval = ByteUtil.getDouble(bytes, 0);
                val = (short)tval;
                break;
            }
            case 9: {
                BigDecimal tval = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                val = tval.shortValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = Short.parseShort(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                long tval = DB2J.binaryToLong(bytes, column, connection);
                val = (short)tval;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static int toInt(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        int val = 0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes == null || bytes.length == 0 ? 0 : bytes[0];
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0);
                break;
            }
            case 7: {
                val = ByteUtil.getInt(bytes, 0);
                break;
            }
            case 8: {
                long tval = ByteUtil.getLong(bytes, 0);
                val = (int)tval;
                break;
            }
            case 10: {
                float tval = ByteUtil.getFloat(bytes, 0);
                val = (int)tval;
                break;
            }
            case 11: {
                double tval = ByteUtil.getDouble(bytes, 0);
                val = (int)tval;
                break;
            }
            case 9: {
                BigDecimal tval = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                val = tval.intValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = Integer.parseInt(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                long tval = DB2J.binaryToLong(bytes, column, connection);
                val = (int)tval;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static long toLong(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        long val = 0L;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes == null || bytes.length == 0 ? 0 : bytes[0];
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0);
                break;
            }
            case 7: {
                val = ByteUtil.getInt(bytes, 0);
                break;
            }
            case 8: {
                val = ByteUtil.getLong(bytes, 0);
                break;
            }
            case 10: {
                val = (long)ByteUtil.getFloat(bytes, 0);
                break;
            }
            case 11: {
                val = (long)ByteUtil.getDouble(bytes, 0);
                break;
            }
            case 9: {
                BigDecimal tval = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                val = tval.longValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = Long.parseLong(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                val = DB2J.binaryToLong(bytes, column, connection);
                break;
            }
            case 28: {
                return DmdbRowId.valueOf(bytes).longValue(connection);
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static float toFloat(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        float val = 0.0f;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes == null || bytes.length == 0 ? (byte)0 : bytes[0];
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0);
                break;
            }
            case 7: {
                val = ByteUtil.getInt(bytes, 0);
                break;
            }
            case 8: {
                val = ByteUtil.getLong(bytes, 0);
                break;
            }
            case 10: {
                val = ByteUtil.getFloat(bytes, 0);
                break;
            }
            case 11: {
                double dval = ByteUtil.getDouble(bytes, 0);
                val = (float)dval;
                break;
            }
            case 9: {
                BigDecimal tval = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                val = tval.floatValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = Float.parseFloat(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static double toDouble(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        double val = 0.0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = bytes == null || bytes.length == 0 ? (byte)0 : bytes[0];
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0);
                break;
            }
            case 7: {
                val = ByteUtil.getInt(bytes, 0);
                break;
            }
            case 8: {
                val = ByteUtil.getLong(bytes, 0);
                break;
            }
            case 10: {
                val = ByteUtil.getFloat(bytes, 0);
                break;
            }
            case 11: {
                val = ByteUtil.getDouble(bytes, 0);
                break;
            }
            case 9: {
                BigDecimal tval = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                val = tval.doubleValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = Double.parseDouble(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static BigDecimal toBigDecimal(byte[] bytes, Column column, DmdbConnection connection, int outScale) throws SQLException {
        BigDecimal val = DB2J.toBigDecimal(bytes, column, connection);
        if (outScale != -1) {
            val = val.setScale(outScale, 4);
        }
        return val;
    }

    public static BigDecimal toBigDecimal(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        BigDecimal val = null;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                val = new BigDecimal(bytes == null || bytes.length == 0 ? 0 : bytes[0]);
                break;
            }
            case 6: {
                val = new BigDecimal(ByteUtil.getShort(bytes, 0));
                break;
            }
            case 7: {
                val = new BigDecimal(ByteUtil.getInt(bytes, 0));
                break;
            }
            case 8: {
                val = new BigDecimal(ByteUtil.getLong(bytes, 0));
                break;
            }
            case 10: {
                val = new BigDecimal(ByteUtil.getFloat(bytes, 0));
                break;
            }
            case 11: {
                val = new BigDecimal(ByteUtil.getDouble(bytes, 0));
                break;
            }
            case 9: {
                val = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                try {
                    val = new BigDecimal(StringUtil.trimToEmpty(str));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                break;
            }
            case 28: {
                return new BigDecimal(DmdbRowId.valueOf(bytes).longValue(connection));
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static byte[] toBytes(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        byte[] retBytes = ByteUtil.getBytes(bytes, 0, bytes.length);
        switch (column.type) {
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(retBytes, connection, column, true);
                retBytes = clob.getBytes(1L, (int)clob.do_length());
                break;
            }
            case 12: {
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(retBytes, connection, column, true);
                retBytes = blob.do_getBytes(1L, (int)blob.do_length());
                break;
            }
        }
        return retBytes;
    }

    public static Date toDate(byte[] bytes, Column column, DmdbConnection connection, Calendar cal) throws SQLException {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: 
            case 26: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
                return dt.toDate(column.mask == 4 ? null : cal);
            }
            case 22: 
            case 23: 
            case 27: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
                return dt.toDate();
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                return DmdbTimestamp.valueOf(str, column, (IDmdbConnection)connection).toDate(cal);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public static Time toTime(byte[] bytes, Column column, DmdbConnection connection, Calendar cal) throws SQLException {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: 
            case 26: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
                return dt.toTime(column.mask == 4 ? null : cal);
            }
            case 22: 
            case 23: 
            case 27: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
                return dt.toTime();
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                return DmdbTimestamp.valueOf(str).toTime(cal);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public static Timestamp toTimestamp(byte[] bytes, Column column, DmdbConnection connection, Calendar cal) throws SQLException {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: 
            case 26: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
                return dt.toTimestamp(column.mask == 4 ? null : cal);
            }
            case 22: 
            case 23: 
            case 27: {
                return DB2J.getDmdbTimestamp(bytes, column, connection);
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                return DmdbTimestamp.valueOf(str).toTimestamp(cal);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public static DmdbTimestamp toDmdbTimestamp(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: 
            case 26: {
                return DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
            }
            case 22: 
            case 23: 
            case 27: {
                return DB2J.getDmdbTimestamp(bytes, column, connection);
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.charToString(bytes, column, connection);
                return DmdbTimestamp.valueOf(str);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    public static DmdbInputStream toAsciiStream(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 12: {
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, connection.lobFetchAll());
                return new DmdbInputStream(blob, 2);
            }
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(bytes, connection, column, connection.lobFetchAll());
                return clob.do_getAsciiStream();
            }
            case 1: {
                byte[] valInner = DB2J.processVarchar2(bytes, column.prec);
                return new DmdbInputStream(valInner, 2);
            }
        }
        return new DmdbInputStream(bytes, 2);
    }

    public static DmdbInputStream toUnicodeStream(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 12: {
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, connection.lobFetchAll());
                return new DmdbInputStream(blob, 3);
            }
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(bytes, connection, column, connection.lobFetchAll());
                return new DmdbInputStream(clob, 3);
            }
            case 1: {
                byte[] valInner = DB2J.processVarchar2(bytes, column.prec);
                return new DmdbInputStream(valInner, 3);
            }
        }
        return new DmdbInputStream(bytes, 3);
    }

    public static DmdbInputStream toBinaryStream(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 12: {
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, connection.lobFetchAll());
                return blob.do_getBinaryStream();
            }
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(bytes, connection, column, connection.lobFetchAll());
                return clob.do_getBinaryStream();
            }
            case 1: {
                byte[] valInner = DB2J.processVarchar2(bytes, column.prec);
                return new DmdbInputStream(valInner, 1);
            }
        }
        return new DmdbInputStream(bytes, 1);
    }

    public static DmdbReader toCharacterStream(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 17: 
            case 18: {
                return new DmdbReader(bytes);
            }
            case 12: {
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, connection.lobFetchAll());
                return new DmdbReader(blob);
            }
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(bytes, connection, column, connection.lobFetchAll());
                return clob.do_getCharacterStream();
            }
        }
        String str = DB2J.toString(bytes, column, connection);
        return new DmdbReader(str);
    }

    public static DmdbBlob toBlob(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 12: {
                return DmdbBlob.newInstanceFromDB(bytes, connection, column, connection.lobFetchAll());
            }
        }
        return DmdbBlob.newInstanceOfLocal(bytes, connection);
    }

    public static DmdbNClob toClob(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        switch (column.type) {
            case 19: {
                return DmdbNClob.newInstance(bytes, connection, column, connection.lobFetchAll());
            }
        }
        String str = DB2J.toString(bytes, column, connection);
        return DmdbNClob.newInstance(str, connection);
    }

    public static Object toObject(byte[] bytes, Column column, IDmdbConnection connection, Map<String, Class<?>> typeMap) throws SQLException {
        Object val = null;
        switch (column.type) {
            case 3: 
            case 13: {
                val = bytes[0] != 0;
                break;
            }
            case 5: {
                val = ByteUtil.getByte(bytes, 0);
                break;
            }
            case 6: {
                val = ByteUtil.getShort(bytes, 0);
                break;
            }
            case 7: {
                val = ByteUtil.getInt(bytes, 0);
                break;
            }
            case 8: {
                val = ByteUtil.getLong(bytes, 0);
                break;
            }
            case 9: {
                val = DB2J.decToBigDecimal(bytes, column.prec, column.scale, connection.compatibleOracle());
                break;
            }
            case 10: {
                val = Float.valueOf(ByteUtil.getFloat(bytes, 0));
                break;
            }
            case 11: {
                val = ByteUtil.getDouble(bytes, 0);
                break;
            }
            case 14: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, connection);
                val = dt.toDate();
                break;
            }
            case 15: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, connection);
                val = dt.toTime();
                break;
            }
            case 16: 
            case 26: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(bytes, column, connection);
                val = dt.toTimestamp();
                break;
            }
            case 22: 
            case 23: 
            case 27: {
                val = DmdbTimestamp.valueOf(bytes, column, connection);
                break;
            }
            case 17: 
            case 18: {
                val = ByteUtil.getBytes(bytes, 0, bytes.length);
                break;
            }
            case 12: {
                DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, (DmdbConnection)connection, column, connection.lobFetchAll());
                if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY")) {
                    val = blob.do_getBytes(1L, (int)blob.do_length());
                    break;
                }
                val = blob;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                val = DB2J.charToString(bytes, column, connection);
                if (column.mask != 3) break;
                val = new DmdbBFile((String)val);
                break;
            }
            case 19: {
                DmdbClob clob = DmdbClob.newInstance(bytes, (DmdbConnection)connection, column, connection.lobFetchAll());
                if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR")) {
                    val = clob.do_getSubString(1L, (int)clob.do_length());
                    break;
                }
                val = clob;
                break;
            }
            case 20: {
                val = new DmdbIntervalYM(bytes);
                break;
            }
            case 21: {
                val = new DmdbIntervalDT(bytes);
                break;
            }
            case 117: {
                val = ComplexTypeData.bytesToArray(bytes, null, column.typeDescriptor);
                break;
            }
            case 122: {
                val = ComplexTypeData.bytesToSArray(bytes, null, column.typeDescriptor);
                break;
            }
            case 119: {
                val = ComplexTypeData.bytesToObj(bytes, null, column.typeDescriptor);
                if (!(val instanceof Struct)) break;
                val = DB2J.toSQLData((Struct)val, typeMap);
                break;
            }
            case 121: {
                val = ComplexTypeData.bytesToRecord(bytes, null, column.typeDescriptor);
                val = DB2J.toSQLData((Struct)val, typeMap);
                break;
            }
            case 28: {
                val = DmdbRowId.valueOf(bytes);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static Object toSQLData(Struct struct, Map<String, Class<?>> typeMap) throws SQLException {
        if (typeMap == null || typeMap.size() == 0) {
            return struct;
        }
        String typeName = struct.getSQLTypeName();
        Class<?> cls = typeMap.get(typeName);
        if (cls != null) {
            try {
                Object obj = cls.newInstance();
                DmdbSQLInput stream = new DmdbSQLInput(typeMap, struct.getAttributes(typeMap));
                ((SQLData)obj).readSQL(stream, typeName);
                return obj;
            }
            catch (Exception exception) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return struct;
    }

    public static Object toComplexType(byte[] bytes, Column column, DmdbConnection connection, Map<String, Class<?>> typeMap) throws SQLException {
        Object val = null;
        if (column.type != 12 && column.typeDescriptor != null) {
            switch (column.typeDescriptor.getDType()) {
                case 117: {
                    val = ComplexTypeData.bytesToArray(bytes, null, column.typeDescriptor);
                    break;
                }
                case 122: {
                    val = ComplexTypeData.bytesToSArray(bytes, null, column.typeDescriptor);
                    break;
                }
                case 121: {
                    val = ComplexTypeData.bytesToRecord(bytes, null, column.typeDescriptor);
                    val = DB2J.toSQLData((Struct)val, typeMap);
                    break;
                }
                case 119: {
                    val = ComplexTypeData.bytesToObj(bytes, null, column.typeDescriptor);
                    if (!(val instanceof Struct)) break;
                    val = DB2J.toSQLData((Struct)val, typeMap);
                    break;
                }
            }
            return val;
        }
        switch (column.type) {
            case 12: {
                DmdbBlob blob;
                if (!DmdbType.isComplexType(column.type, column.scale)) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                if (!((val = ComplexTypeData.objBlobToObj(blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, true), column.typeDescriptor)) instanceof Struct)) break;
                val = DB2J.toSQLData((Struct)val, typeMap);
                break;
            }
            case 117: {
                val = ComplexTypeData.bytesToArray(bytes, null, column.typeDescriptor);
                break;
            }
            case 122: {
                val = ComplexTypeData.bytesToSArray(bytes, null, column.typeDescriptor);
                break;
            }
            case 119: {
                val = ComplexTypeData.bytesToObj(bytes, null, column.typeDescriptor);
                if (!(val instanceof Struct)) break;
                val = DB2J.toSQLData((Struct)val, typeMap);
                break;
            }
            case 121: {
                val = ComplexTypeData.bytesToRecord(bytes, null, column.typeDescriptor);
                val = DB2J.toSQLData((Struct)val, typeMap);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    public static DmdbArray toArray(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        Object retArr = DB2J.toComplexType(bytes, column, connection, null);
        if (!(retArr instanceof DmdbArray)) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        return (DmdbArray)retArr;
    }

    public static DmdbStruct toStruct(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        Object retStruct = DB2J.toComplexType(bytes, column, connection, null);
        if (!(retStruct instanceof DmdbStruct)) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        return (DmdbStruct)retStruct;
    }

    public static RowId toRowId(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        DmdbRowId val = null;
        switch (column.type) {
            case 8: {
                val = DmdbRowId.valueOf(ByteUtil.getLong(bytes, 0));
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String str = DB2J.toString(bytes, column, connection);
                val = DmdbRowId.valueOf(str);
                break;
            }
            case 12: 
            case 17: 
            case 18: 
            case 28: {
                val = DmdbRowId.valueOf(DB2J.toBytes(bytes, column, connection));
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return val;
    }

    private static byte[] processVarchar2(byte[] bytes, int prec) {
        byte[] rbytes = new byte[prec];
        System.arraycopy(bytes, 0, rbytes, 0, bytes.length);
        int i2 = bytes.length;
        while (i2 < rbytes.length) {
            rbytes[i2] = 32;
            ++i2;
        }
        return rbytes;
    }

    private static BigDecimal decToBigDecimal(byte[] bytes, int prec, int scale, boolean compatibleOracle) throws SQLException {
        BigDecimal bigDecimal = new DmdbNumeric(bytes, prec, scale).toBigDecimal(compatibleOracle);
        return bigDecimal;
    }

    private static String charToString(byte[] bytes, Column column, IDmdbConnection connection) throws SQLException {
        if (column.type == 1) {
            bytes = DB2J.processVarchar2(bytes, column.prec);
        } else if (column.type == 19) {
            DmdbClob clob = DmdbClob.newInstance(bytes, (DmdbConnection)connection, column, true);
            return clob.getSubString(1L, (int)clob.length());
        }
        return ByteUtil.getString(bytes, 0, bytes.length, connection.getServerEncoding());
    }

    public static String customEncode(String str, DmdbConnection conn) throws SQLException {
        try {
            str = new String(str.getBytes(conn.customServerEncode), conn.customClientEncode);
        }
        catch (UnsupportedEncodingException e2) {
            DBError.ECJDBC_INVALID_CUSTOM_ENCODING.throwz(e2);
        }
        return str;
    }

    private static long binaryToLong(byte[] bytes, Column column, DmdbConnection connection) throws SQLException {
        int j2;
        int len;
        if (column.type == 12) {
            DmdbBlob blob = DmdbBlob.newInstanceFromDB(bytes, connection, column, true);
            bytes = blob.do_getBytes(1L, (int)blob.do_length());
        }
        long n2 = 0L;
        long b2 = 0L;
        int startIndex = 0;
        int n3 = len = bytes.length > 8 ? 8 : bytes.length;
        if (bytes.length > 8) {
            j2 = 0;
            while (j2 < bytes.length - 8) {
                if (bytes[j2] != 0) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                ++j2;
            }
            startIndex = bytes.length - 8;
            len = 8;
        }
        j2 = startIndex;
        while (j2 < startIndex + len) {
            b2 = 0xFF & bytes[j2];
            n2 = b2 | n2 << 8;
            ++j2;
        }
        return n2;
    }

    private static DmdbTimestamp getDmdbTimestamp(byte[] bytes, Column column, DmdbConnection connection) {
        DmdbTimestamp dmdbTimestamp = DmdbTimestamp.valueOf(bytes, column, (IDmdbConnection)connection);
        int defaultSrcTz = dmdbTimestamp.getTimezone();
        if (defaultSrcTz == Integer.MIN_VALUE) {
            return dmdbTimestamp;
        }
        short destTz = connection.getLocalTimezone();
        dmdbTimestamp.dt = DmdbTimestamp.transformTZ(dmdbTimestamp.dt, defaultSrcTz, destTz);
        return dmdbTimestamp;
    }
}

