/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.conf;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class EPGroup
implements Serializable {
    private static ILogger log = LogFactory.getLog(EPGroup.class);
    public String name;
    public List<EP> epList = null;
    public DmProperties props;
    public static final int RECONNECT_OFF = 0;
    public static final int RECONNECT_CONN_ERROR = 1;
    public static final int RECONNECT_WITH_EP_SELECTOR = 2;
    public static final int RECONNECT_LOAD_BALANCE = 4;
    public static final int RECONNECT_LOAD_BALANCE_AND_CONN_ERROR = 5;
    public static final int RECONNECT_HEAD_FIRST_AND_CONN_ERROR = 3;
    public int reconnect = Configuration.reconnect.getDefault();
    public int switchTimes = Configuration.switchTimes.getDefault();
    public int switchInterval = Configuration.switchInterval.getDefault();
    public int checkFreq = Configuration.checkFreq.getDefault();
    public int allowRange = Configuration.allowRange.getDefault();
    public List<String> sessionStates = Collections.emptyList();
    public static final int LOGIN_MODE_PRIMARY_FIRST = 0;
    public static final int LOGIN_MODE_PRIMARY_ONLY = 1;
    public static final int LOGIN_MODE_STANDBY_ONLY = 2;
    public static final int LOGIN_MODE_STANDBY_FIRST = 3;
    public static final int LOGIN_MODE_NORMAL_FIRST = 4;
    public int loginMode = Configuration.loginMode.getDefault();
    public static final int LOGIN_STATUS_OFF = 0;
    public static final int LOGIN_STATUS_OPEN = 4;
    public static final int LOGIN_STATUS_MOUNT = 3;
    public static final int LOGIN_STATUS_SUSPEND = 5;
    public int loginStatus = Configuration.loginStatus.getDefault();
    public boolean loginDscCtrl = Configuration.loginDscCtrl.getDefault();
    public static final int CLUSTER_NORMAL = 0;
    public static final int CLUSTER_RW = 1;
    public static final int CLUSTER_DW = 2;
    public static final int CLUSTER_DSC = 3;
    public static final int CLUSTER_MPP = 4;
    public static final int CLUSTER_DPC = 5;
    public int cluster = Configuration.cluster.getDefault();
    public EPSelector epSelector = null;
    public boolean epSelectorDynamic;
    public boolean failOverWait;
    public String user;
    public String password;
    public AtomicLong sessions = new AtomicLong(0L);
    public long checkTime = 0L;

    public EPGroup(String name, List<EP> serverList) {
        this.name = name;
        this.epList = serverList;
    }

    public EPGroup setAttributes(DmProperties props) {
        int n2 = this.cluster = props.getInt(Configuration.rwSeparate) != 0 ? 1 : this.cluster;
        if (this.cluster == 1) {
            this.loginMode = 1;
            this.loginStatus = 4;
            this.reconnect = 1;
        }
        if (props.contains(Configuration.user)) {
            this.user = props.getProperty(Configuration.user.getName());
        }
        if (props.contains(Configuration.password)) {
            this.password = props.getProperty(Configuration.password.getName());
        }
        if (props.contains(Configuration.cluster)) {
            this.cluster = Configuration.parseCluster(props);
        }
        if (props.contains(Configuration.loginMode)) {
            this.loginMode = props.getInt(Configuration.loginMode);
        }
        if (props.contains(Configuration.loginStatus)) {
            this.loginStatus = props.getInt(Configuration.loginStatus);
        }
        if (props.contains(Configuration.loginDscCtrl)) {
            this.loginDscCtrl = props.getBoolean(Configuration.loginDscCtrl);
        }
        if (props.contains(Configuration.switchTimes)) {
            this.switchTimes = props.getInt(Configuration.switchTimes);
        }
        if (props.contains(Configuration.switchInterval)) {
            this.switchInterval = props.getMilliSecond(Configuration.switchInterval);
        }
        if (props.contains(Configuration.reconnect)) {
            this.reconnect = props.getInt(Configuration.reconnect);
        }
        if (props.contains(Configuration.checkFreq)) {
            this.checkFreq = props.getMilliSecond(Configuration.checkFreq);
        }
        if (props.contains(Configuration.allowRange)) {
            this.allowRange = props.getInt(Configuration.allowRange);
        }
        if (props.contains(Configuration.sessionState)) {
            this.sessionStates = Configuration.parseSessionState(props.getString(Configuration.sessionState));
        }
        this.epSelectorDynamic = props.getBoolean(Configuration.epSelectorDynamic);
        this.failOverWait = props.getBoolean(Configuration.failOverWait);
        int configValue = props.getInt(Configuration.epSelector);
        this.resetEpSelectorConfig(configValue);
        return this;
    }

    public synchronized void resetEpSelectorConfig(int configValue) {
        if (this.epSelector == null) {
            switch (configValue) {
                case 0: {
                    this.epSelector = new WellDistributeEpSelector(this);
                    break;
                }
                default: {
                    this.epSelector = new SingleEpSelector(this, configValue);
                    break;
                }
            }
        } else if (configValue != this.epSelector.value) {
            switch (configValue) {
                case 0: {
                    this.epSelector = new WellDistributeEpSelector(this);
                    break;
                }
                default: {
                    if (!(this.epSelector instanceof SingleEpSelector)) {
                        this.epSelector = new SingleEpSelector(this, configValue);
                        break;
                    }
                    ((SingleEpSelector)this.epSelector).reset(configValue - 1);
                }
            }
        }
    }

    public synchronized void resetEpSelectorStart(int startPos) {
        if (this.epSelectorDynamic && this.epSelector.value != 0 && startPos != this.epSelector.startPos) {
            ((SingleEpSelector)this.epSelector).reset(startPos);
        }
    }

    public String toString() {
        return String.valueOf(this.name) + "=(" + Arrays.toString(this.epList.toArray()) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(DmdbConnection conn) throws SQLException {
        try {
            int i2;
            EP[] eps;
            if (conn.radiusEps == null) {
                eps = this.epSelector.start();
                i2 = 0;
            } else {
                eps = conn.radiusEps;
                i2 = conn.radiusCycleIndex;
            }
            SQLException ex = null;
            int cycleCount = this.epList.size() == 1 ? this.switchTimes : this.switchTimes + 1;
            String info = "conn-" + conn.getID() + " try connect loop ";
            while (i2 < cycleCount) {
                String msg = String.valueOf(info) + i2;
                if (i2 != 0) {
                    MiscUtil.sleep(this.switchInterval);
                    if (!log.isDebugEnabled()) {
                        System.out.println(msg);
                    }
                }
                log.debug(msg);
                try {
                    this.epSelector.select(eps, conn, i2 == 0, i2 == cycleCount - 1);
                    if (conn.radiusAuth) {
                        conn.radiusEps = eps;
                        conn.radiusCycleIndex = i2;
                        return;
                    }
                    this.sessions.incrementAndGet();
                }
                catch (SQLException e2) {
                    ex = e2;
                    if (!DBError.isReconnectErrorCode(DBError.getRealErrCode(e2), conn)) throw ex;
                    ++i2;
                    continue;
                    throw ex;
                }
                this.clearRadiusParam(conn);
                return;
            }
        }
        finally {
            if (!conn.radiusAuth) {
                this.resetEpSelectorStart(conn.ep.epSeqno);
            }
        }
    }

    private void clearRadiusParam(DmdbConnection conn) {
        if (conn.radiusEps != null) {
            conn.radiusEps = null;
            conn.radiusCycleIndex = 0;
            conn.radiusEpIndex = 0;
        }
    }

    public void connect(DmdbConnection conn, int epSeqno) throws SQLException {
        EP dest = null;
        for (EP ep : this.epList) {
            if (ep.epSeqno != epSeqno) continue;
            dest = ep;
            break;
        }
        if (dest == null) {
            log.warn("try connect invalid epSeqno: " + epSeqno);
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[0]);
        }
        log.debug("try connect EP num: " + epSeqno + " [" + dest.host + ":" + dest.port + "]");
        dest.connect(conn);
    }

    public void connect(DmdbConnection conn, String host, int port) throws SQLException {
        EP dest = null;
        for (EP ep : this.epList) {
            if (!StringUtil.equals(ep.host, host) || ep.port != port) continue;
            dest = ep;
            break;
        }
        if (dest == null) {
            dest = new EP(host, port);
        }
        log.debug("try connect EP : [" + host + ":" + port + "]");
        dest.connect(conn);
    }

    public void incrementSession(DmdbConnection conn) {
        this.sessions.incrementAndGet();
    }

    public void decrementSession(DmdbConnection conn) {
        this.sessions.decrementAndGet();
    }

    public boolean isReconnectWhenError() {
        return this.reconnect > 0;
    }

    public boolean isAfterEpSelectorModify(long time) {
        if (this.epSelector.modifyTime > 0L) {
            return time > this.epSelector.modifyTime;
        }
        return false;
    }

    public static abstract class EPSelector {
        public static final int TYPE_WELL_DISTRIBUTE = 0;
        public EPGroup group;
        public int value = -1;
        public int startPos = -1;
        public long modifyTime = -1L;

        public EPSelector(EPGroup group, int value, int startPos) {
            this.group = group;
            this.value = value;
            this.startPos = startPos % group.epList.size();
        }

        public abstract EP[] start();

        public abstract void beforeSelect(EP[] var1, boolean var2) throws SQLException;

        public void select(EP[] eps, DmdbConnection conn, boolean firstTime, boolean lastTime) throws SQLException {
            EP ep;
            if (conn.radiusEps == null) {
                this.beforeSelect(eps, firstTime);
            }
            StringBuilder errorMsg = new StringBuilder();
            SQLException firstEx = null;
            if (lastTime && !firstTime) {
                boolean hasAlive = false;
                EP[] ePArray = eps;
                int n2 = eps.length;
                int n3 = 0;
                while (n3 < n2) {
                    ep = ePArray[n3];
                    if (ep.alive) {
                        hasAlive = true;
                        break;
                    }
                    ++n3;
                }
                if (!hasAlive) {
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[0]);
                    return;
                }
            }
            int i2 = conn.radiusEpIndex;
            while (i2 < eps.length) {
                ep = eps[i2];
                try {
                    ep.connect(conn);
                    if (conn.do_isClosed() && conn.radiusAuth) {
                        conn.radiusEpIndex = i2;
                        return;
                    }
                    if (!this.checkServerMode(lastTime, conn)) {
                        DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
                    }
                    log.debug("try connect success [" + conn.host + ":" + conn.port + "]");
                    return;
                }
                catch (SQLException e2) {
                    if (firstEx == null) {
                        firstEx = e2;
                    }
                    errorMsg.append("[").append(ep.toString()).append("]").append(e2.getMessage()).append(StringUtil.LINE_SEPARATOR);
                    log.asserts("try connect fail [" + ep.toString() + "] ", e2);
                    if (!DBError.isReconnectErrorCode(DBError.getRealErrCode(e2), conn)) break;
                    conn.free();
                    ++i2;
                }
            }
            if (firstEx != null) {
                throw firstEx;
            }
            DBError.throwException(errorMsg.toString(), DBError.ECJDBC_COMMUNITION_ERROR.errCode);
        }

        public boolean checkServerMode(boolean lastTime, DmdbConnection conn) throws SQLException {
            if (this.group.loginDscCtrl && !conn.dscControl) {
                conn.free();
                DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
            }
            if (this.group.loginStatus > 0 && conn.svrStat != this.group.loginStatus) {
                conn.free();
                DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
            }
            if (lastTime) {
                switch (this.group.loginMode) {
                    case 1: {
                        return conn.svrMode == 1;
                    }
                    case 2: {
                        return conn.svrMode == 2;
                    }
                }
                return true;
            }
            switch (this.group.loginMode) {
                case 4: {
                    return conn.svrMode == 0;
                }
                case 0: 
                case 1: {
                    return conn.svrMode == 1;
                }
                case 2: 
                case 3: {
                    return conn.svrMode == 2;
                }
            }
            return false;
        }
    }

    public static class SingleEpSelector
    extends EPSelector {
        public SingleEpSelector(EPGroup group, int value) {
            super(group, value, value - 1);
        }

        public synchronized void reset(int pos) {
            this.startPos = pos % this.group.epList.size();
            this.modifyTime = System.nanoTime();
        }

        @Override
        public EP[] start() {
            int epCount = this.group.epList.size();
            EP[] eps = new EP[epCount];
            int i2 = 0;
            while (i2 < epCount) {
                eps[i2] = this.group.epList.get((this.startPos + i2) % epCount);
                ++i2;
            }
            return eps;
        }

        @Override
        public void beforeSelect(EP[] eps, boolean firstTime) throws SQLException {
        }

        @Override
        public boolean checkServerMode(boolean lastTime, DmdbConnection conn) throws SQLException {
            if (this.group.failOverWait && !lastTime && conn.ep != this.group.epList.get(this.startPos)) {
                return false;
            }
            return super.checkServerMode(lastTime, conn);
        }
    }

    public static class WellDistributeEpSelector
    extends EPSelector {
        public ReentrantLock posLock = new ReentrantLock();
        static Comparator<EP> sortComparator = new Comparator<EP>(){

            @Override
            public int compare(EP o1, EP o2) {
                if (o1.sort > o2.sort) {
                    return -1;
                }
                if (o1.sort == o2.sort) {
                    return 0;
                }
                return 1;
            }
        };

        public WellDistributeEpSelector(EPGroup group) {
            super(group, 0, group.epList == null || group.epList.size() == 0 ? -1 : new Random().nextInt(group.epList.size()) - 1);
        }

        @Override
        public EP[] start() {
            int serverCount = this.group.epList.size();
            EP[] sortEps = new EP[serverCount];
            int pos = 0;
            try {
                this.posLock.lock();
                pos = this.startPos = (this.startPos + 1) % serverCount;
            }
            finally {
                this.posLock.unlock();
            }
            int i2 = 0;
            while (i2 < serverCount) {
                sortEps[i2] = this.group.epList.get((i2 + pos) % serverCount);
                ++i2;
            }
            return sortEps;
        }

        @Override
        public void beforeSelect(EP[] eps, boolean firstTime) throws SQLException {
            if (!firstTime) {
                Arrays.sort(eps, sortComparator);
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.group.checkTime == 0L || currentTime - this.group.checkTime >= 20000L) {
                return;
            }
            Arrays.sort(eps, sortComparator);
        }
    }
}

