/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.Filterable;
import dm.jdbc.internal.convert.Data;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.util.ByteUtil;
import java.io.Serializable;
import java.sql.SQLException;

public abstract class AbstractLob
extends Filterable
implements Serializable {
    public static final byte LOB_FLAG_BYTE = 0;
    public static final byte LOB_FLAG_CHAR = 1;
    public static final byte STORAGE_IN_ROW = 1;
    public static final byte STORAGE_OUT_ROW = 2;
    public static final byte STORAGE_LONG_ROW = 4;
    public static final int NBLOB_HEAD_SIZE_INROW = 13;
    public static final int NBLOB_HEAD_SIZE_OUTROW = 21;
    public static final int NBLOB_HEAD_SIZE_EX = 43;
    public static final int NBLOB_HEAD_SIZE_EX_ROWID_12B = 47;
    public long id;
    public int storageType = 0;
    public int groupId = -1;
    public int fileId = -1;
    public int pageNo = -1;
    public int tabId;
    public int colId;
    public byte[] rowId;
    public int curFileId;
    public int curPageNo;
    public int curOffset;
    public long totalOffset;
    public boolean readOver = false;
    public DmdbConnection connection;
    public boolean local = true;
    public boolean updateable = true;
    public byte lobFlag;
    public long bytesLength = -1L;
    public long length = -1L;
    public boolean fetchAll = false;
    public boolean optimizeFetchAll = false;
    public boolean freed = false;
    public boolean modify = false;
    public boolean empty = false;

    public AbstractLob(byte[] value, byte lobFlag, DmdbConnection conn, Column column) {
        this(lobFlag, conn);
        this.lobFlag = lobFlag;
        this.local = false;
        this.updateable = !column.readonly;
        this.tabId = column.lobTabId;
        this.colId = column.lobColId;
        int offset = 0;
        this.storageType = ByteUtil.getByte(value, offset);
        this.id = ByteUtil.getLong(value, ++offset);
        this.bytesLength = ByteUtil.getUB4(value, offset += 8);
        if ((offset += 4) == value.length) {
            return;
        }
        this.groupId = ByteUtil.getUB2(value, offset);
        this.fileId = ByteUtil.getUB2(value, offset += 2);
        this.pageNo = ByteUtil.getInt(value, offset += 2);
        this.curFileId = this.fileId;
        this.curPageNo = this.pageNo;
        this.curOffset = 0;
        this.totalOffset = 0L;
        if ((offset += 4) == value.length) {
            return;
        }
        this.tabId = ByteUtil.getInt(value, offset);
        this.colId = ByteUtil.getUB2(value, offset += 4);
        offset += 2;
        if (this.connection.msgVersion < 9) {
            this.rowId = ByteUtil.getBytes(value, offset, 8);
            offset += 8;
        } else {
            this.rowId = ByteUtil.getBytes(value, offset, 12);
            offset += 12;
        }
        if (offset == value.length) {
            return;
        }
        if (this.storageType == 4) {
            this.bytesLength = ByteUtil.getLong(value, offset);
            offset += 8;
        }
    }

    public AbstractLob(byte lobFlag, DmdbConnection connection) {
        super(connection, null);
        this.connection = connection;
        this.lobFlag = lobFlag;
    }

    protected abstract void loadAllData() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long do_length() throws SQLException {
        this.checkFreed();
        if (this.length == -1L) {
            this.checkConnection();
            DmdbConnection dmdbConnection = this.connection;
            synchronized (dmdbConnection) {
                this.length = this.connection.dbAccess.a(this);
            }
        }
        return this.length;
    }

    public void do_free() throws SQLException {
        this.connection = null;
        this.freed = true;
    }

    public void checkFreed() throws SQLException {
        if (this.freed) {
            DBError.ECJDBC_LOB_FREED.throwz(new Object[0]);
        }
        if (this.empty) {
            DBError.ECJDBC_INVALID_OPT_ON_EMPTY_LOB.throwz(new Object[0]);
        }
    }

    protected void checkConnection() throws SQLException {
        if (this.connection == null) {
            DBError.ECJDBC_LOB_FREED.throwz(new Object[0]);
        }
        this.connection.checkClosed();
    }

    public boolean canOptimized(DmdbConnection connection) {
        return connection.lobOptimized && connection == this.connection && this.storageType != 1 && !this.fetchAll && !this.local && !this.modify;
    }

    public LobCtl buildCtlData() {
        return new LobCtl(this);
    }

    public int getHeadSize() {
        if (!this.connection.newLobFlag) {
            return this.storageType == 1 ? 13 : 21;
        }
        if (this.connection.msgVersion < 9) {
            return 43;
        }
        return 47;
    }

    protected void setModify() {
        this.modify = true;
        this.optimizeFetchAll = false;
    }

    public static class LobCtl
    extends Data {
        public LobCtl(AbstractLob abstractLob) {
            super(65531L, LobCtl.buildCtlData(abstractLob));
        }

        public static byte[] buildCtlData(AbstractLob abstractLob) {
            int headSize = abstractLob.getHeadSize();
            byte[] buffer = new byte[headSize];
            int offset = 0;
            ByteUtil.setByte(buffer, offset, (byte)abstractLob.storageType);
            ByteUtil.setLong(buffer, ++offset, abstractLob.id);
            ByteUtil.setUB4(buffer, offset += 8, abstractLob.storageType == 1 ? abstractLob.bytesLength : -1L);
            offset += 4;
            if (!abstractLob.connection.newLobFlag) {
                if (abstractLob.storageType == 2) {
                    ByteUtil.setUB2(buffer, offset, abstractLob.groupId);
                    ByteUtil.setUB2(buffer, offset += 2, abstractLob.fileId);
                    ByteUtil.setInt(buffer, offset += 2, abstractLob.pageNo);
                    offset += 4;
                }
            } else {
                int rowidLen;
                ByteUtil.setUB2(buffer, offset, abstractLob.groupId);
                ByteUtil.setUB2(buffer, offset += 2, abstractLob.fileId);
                ByteUtil.setInt(buffer, offset += 2, abstractLob.pageNo);
                ByteUtil.setInt(buffer, offset += 4, abstractLob.tabId);
                ByteUtil.setUB2(buffer, offset += 4, abstractLob.colId);
                offset += 2;
                int n2 = rowidLen = abstractLob.connection.msgVersion < 9 ? 8 : 12;
                if (abstractLob.rowId != null) {
                    ByteUtil.setBytes(buffer, offset, abstractLob.rowId);
                }
                offset += rowidLen;
                if (abstractLob.storageType == 4) {
                    ByteUtil.setLong(buffer, offset, -1L);
                    offset += 8;
                }
            }
            return buffer;
        }
    }
}

